import nqcg
import numpy as np
import time

# Define your objective function
def f( x ):
    x1 = x[0,0]**2
    x2 = x[1,0]**2 
    return 100*(x2 - x1**2 )**2 + (1-x1)**2 

# Initialization
x_0=np.matrix([-2,2]).T

# Instatiate the solver with the objective function and initial value
my_solver = nqcg.nonquadratic_conjugate_gradient_solver(
    x_0,
    objective_function = f,
    line_search_epsilon=0.01, 
    line_search_delta=0.1,
    line_search_K = 0.5,
    update_epsilon = 0.01,
    determinant_epsilon = 0.01
    )


# Run Solver
start = time.time()
x,fval = my_solver.run()
print 'x* = ',x
print 'f(x*) = ',fval
print 'time = ',time.time()-start
