#!/usr/bin/python

# Cressel Anderson
# Georgia Tech: CS8803OPT
# Karen Liu
# Nov. 14, 2008
# Line Search using DSC Algorithm

import numpy as np

class inexact_line_search_dsc( object ):
    '''Implementation of the algorithm on pg 105 in Practical
    Optimization by Antoniou and Lu'''
    
    def __init__( self, alpha, delta, f, K, epsilon ):

        self.x_0_1 = alpha
        self.delta_k = delta
        self.f = f
        self.K = K
        self.epsilon = epsilon
        
        self.k = 0

        self.fs = [[]]
        self.xs = [[]]
        # x_0_1
        self.xs.append([alpha])

    def step_2(self):
        self.k += 1
        # x_0_k
        self.fs.append([self.f(self.xs[self.k][0])])
        # x_-1_k
        self.xs[self.k] =  [self.xs[self.k][0] - self.delta_k] + self.xs[self.k]
        self.fs[self.k] =  [self.f(self.xs[self.k][0])] + self.fs[self.k]
        # x_1_k
        self.xs[self.k].append( self.xs[self.k][1] + self.delta_k )
        self.fs[self.k].append( self.f(self.xs[self.k][2]) )

    def step_3a(self):
        if self.fs[self.k][0] > self.fs[self.k][1]:
            self.p = 1
            return 'step4'
        else:
            self.fs[self.k] = [self.f( self.xs[self.k][0] )] + self.fs[self.k]

    def step_3b(self):
        if self.fs[self.k][0] < self.fs[self.k][1]:
            self.p = -1
            return 'step4'

    def step_3c(self):
        if ( self.fs[self.k][0] >= self.fs[self.k][1] and 
             self.fs[self.k][1] <= self.fs[self.k][3] ):
            return 'step_7'
                    
    def step_3(self):
        #print 'step_3a'
        v = self.step_3a()
        if v == 'step4':
            return

        #print 'step_3b'
        v = self.step_3b()
        if v == 'step4':
            return

        #print 'step_3c'
        self.step_3c()
        return 'step_7'
    
    def step_4(self):
        n = 1
        while 1:
            n += 1
            self.xs[self.k].append( self.xs[self.k][n-1] + 2**(n-1)*self.p*self.delta_k )
            self.fs[self.k].append( self.f(self.xs[self.k][-1] ))

            if self.fs[self.k][n] > self.fs[self.k][n-1]:
                break
        self.n = n

    def step_5(self):
        self.xm = self.xs[self.k][self.n-1] + 2**(self.n-2)*self.p*self.delta_k 
        self.f_m_k = self.f( self.xm )
        #print 'f_m_k,x_m_k = ',self.f_m_k,self.x_m_k

    def step_6(self):
        #print 'self.fns = ',self.fns
        #print 'self.x_0_k = ',self.x_0_k
        if self.f_m_k >= self.fs[self.k][self.n-1]:
            self.xs.append([ 1*(
                self.xs[self.k][self.n-1] +
                ( 2**(self.n-2)*
                  self.p*
                  self.delta_k*
                  (self.fs[self.k][self.n-2] - 
                   self.f_m_k))   
                /
                ( 2*( self.fs[self.k][self.n-2] - 
                      2*self.fs[self.k][self.n-1] +
                      self.f_m_k ))) ])

            self.fs.append( [self.f(self.xs[self.k+1][0])])


        else:
            self.xs.append([ 1*(
                self.xm +
                ( 2**(self.n-2)*
                  self.p*
                  self.delta_k*
                  (self.fs[self.k][self.n-1] - 
                   self.fs[self.k][self.n]))   
                /
                ( 2*( self.fs[self.k][self.n-1] - 
                      2*self.f_m_k +
                      self.fs[self.k][self.n]))) ])
            self.fs.append( [self.f(self.xs[self.k+1][0])])
                
        if 2**(self.n-2)*self.delta_k <= self.epsilon:
            return 'step_8'
        else:
            self.delta_k = self.K * self.delta_k

    def step_7( self ):
        self.xs.append([ 1*(
            self.xs[self.k][0] +
            ( self.delta_k*
              (self.fs[self.k][0] - 
               self.fs[self.k][2]))   
            /
            ( 2*( self.fs[self.k][0] - 
                  2*self.fs[self.k][1] +
                  self.fs[self.k][2] ))) ])
        self.fs.append( [self.f(self.xs[self.k+1][0])])

        if self.delta_k <= self.epsilon :
            return 'step_8'
        else:
            self.delta_k = self.K * self.delta_k

    def step_8( self ):
        #print 'x = '
        #print ''
        #print self.xs
        #print 'fs = '
        #print ''
        #print self.fs
        return ( self.xs[self.k][1], self.f(self.xs[self.k][1]))
        
    def run(self):
        run = True
        while run:

            self.step_2()
            v = self.step_3()
            if v == 'step_7':
                v2 = self.step_7()
                if v2 == 'step_8':
                    break
                else:
                    continue
            else:
                self.step_4()

            self.step_5()

            v = self.step_6()
            if v== 'step_8':
                break
            else:
                continue

        return self.step_8()
