import math
from math import sin, cos
import numpy as np
from numpy import power as pw

##
# Two link planar robot model taken from page 165 of Murry, Li, Sastry
def f(constants, x):
    theta1   = constants[0,0]   #
    theta2   = constants[1,0]   #
    dtheta1  = constants[2,0]   # 6 elements
    dtheta2  = constants[3,0]   #
    dthetas  = constants[2:4,0] #
    ddthetas = constants[4:6,0] #

    m1  = x[0,0]                #
    m2  = x[1,0]                #
    l1  = x[2,0]                #
    l2  = x[3,0]                # 
    w1  = x[4,0]                # 8 elements
    w2  = x[5,0]                #
    r1  = x[6,0]                #
    r2  = x[7,0]                # 

    c2 = cos(theta2)
    s2 = sin(theta2)

    Iz1 = (m1 / 12.0) * (pw(l1,2) + pw(w1,2))
    Iz2 = (m2 / 12.0) * (pw(l2,2) + pw(w2,2))

    alpha = Iz1 + Iz2 + m1 * pw(r1, 2) + m2*(pw(l1,2) + pw(r2, 2))
    beta  = m2*l1*r2
    delta = Iz2 + m2*pw(r2,2)

    M = np.matrix([[alpha + 2*beta*c2, delta+beta*c2],
                   [delta + beta*c2, delta]])

    C = np.matrix([[-beta*s2*dtheta2, -beta*s2*(dtheta1 + dtheta2)],
                   [beta*s2*dtheta1, 0]])

    return M*ddthetas + C*dthetas

##
# Returns a list of angles, torques pairs
def get_samples(x, num_samples):
    samples = 2 * np.pi * np.matrix(np.random.random_sample((6, num_samples)))
    return [(samples[:,i], f(samples[:,i], x)) for i in range(num_samples)]

##
# calculates least squares of || f(x) - t ||
def two_link_objective(data, x):
    v = 0.0
    for angles, recorded_torque in data:
        predicted = f(angles, x)
        diff = (recorded_torque - predicted)
        v = v + (diff.T * diff)[0,0]
    print x.T, 'objective', v
    return v

if __name__ == '__main__':
    import functools as ft
    import nqcg as cg
    import time

    #m1 m2 l1 l2 w1 w2 r1 r2
    correct_solution = np.matrix([5.0, 6.0, 3.0, 3.0, .3, .3, 1.5, 1.5]).T
    samples          = get_samples(correct_solution, 1000)
    objective_func   = ft.partial(two_link_objective, samples)

    # Initialization
                   #m1   m2   l1   l2   w1   w2   r1   r2
    x0 = np.matrix([5.0, 6.0, 3.3, 2.7, .28, .33, 1.1, 1.9]).T

    # Instatiate the solver with the objective function and initial value
    my_solver = cg.nonquadratic_conjugate_gradient_solver(x0, objective_function = objective_func )

    # Run Solver
    start = time.time()
    x,fval = my_solver.run()
    print 'x* = ',x
    print 'f(x*) = ',fval
    print 'time = ',time.time()-start
