import math
from math import sin, cos
import numpy as np

GRAVITY = 9.8
def f1(constants, x):
    theta   = constants[0,0]
    phi     = constants[1,0]

    dtheta  = constants[2,0]
    dphi    = constants[3,0]

    ddtheta = constants[4,0]
    ddphi   = constants[5,0]

    mass    = x[0,0]
    length  = x[1,0]

    term1 = mass * length * length * ddtheta 
    term2 = - mass * length * length * sin(theta) * cos(theta) * dphi * dphi
    term3 = mass * GRAVITY * length * sin(theta)
    return term1 + term2 + term3

def f2(constants, x):
    theta   = constants[0,0]
    phi     = constants[1,0]

    dtheta  = constants[2,0]
    dphi    = constants[3,0]

    ddtheta = constants[4,0]
    ddphi   = constants[5,0]

    mass    = x[0,0]
    length  = x[1,0]

    term1 = mass * length * length * np.power(sin(theta), 2) * ddphi
    term2 = 2 * mass * length * length * sin(theta) * cos(theta) * dtheta * dphi
    return term1 + term2

##
# Returns a list of angles, torques pairs
def get_samples(x, num_samples):
    samples = 2 * np.pi * np.matrix(np.random.random_sample((6, num_samples)))
    return [(samples[:,i], np.matrix([f1(samples[:,i], x), f2(samples[:,i], x)]).T) for i in range(num_samples)]

##
# calculates least squares of || f(x) - t ||
def pendulum_objective(data, x):
    v = 0.0
    for angles, recorded_torque in data:
        predicted = np.matrix([f1(angles, x), f2(angles, x)]).T
        diff = (recorded_torque - predicted)
        v = v + (diff.T * diff)[0,0]
    print x.T, 'objective', v
    return v

if __name__ == '__main__':
    import functools as ft
    import nqcg as cg
    import time

    correct_solution = np.matrix([10.0, 30.0]).T
    samples        = get_samples(correct_solution, 1000)
    objective_func = ft.partial(pendulum_objective, samples)

    # Initialization
    x0 = np.matrix([13.0, 33]).T
    x1 = np.matrix([10.21484413, 29.68277038]).T

    # Instatiate the solver with the objective function and initial value
    my_solver = cg.nonquadratic_conjugate_gradient_solver(x1, objective_function = objective_func )

    # Run Solver
    start = time.time()
    x,fval = my_solver.run()
    print 'x* = ',x
    print 'f(x*) = ',fval
    print 'time = ',time.time()-start


        

























