# Volatility
# Copyright (C) 2008 Volatile Systems
# Copyright (c) 2008 Brendan Dolan-Gavitt <bdolangavitt@wesleyan.edu>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details. 
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
#

"""
@author:       AAron Walters and Brendan Dolan-Gavitt
@license:      GNU General Public License 2.0 or later
@contact:      awalters@volatilesystems.com,bdolangavitt@wesleyan.edu
@organization: Volatile Systems
"""

from forensics.win32.regtypes import regtypes
from forensics.win32.rawreg import get_root, open_key, subkeys, values, value_data
from forensics.win32.hashdump import dump_memory_hashes
from forensics.object2 import *
from vutils import *

class hashdump(forensics.commands.command):

    # Declare meta information associated with this plugin
    
    meta_info = forensics.commands.command.meta_info 
    meta_info['author'] = 'Brendan Dolan-Gavitt'
    meta_info['copyright'] = 'Copyright (c) 2007,2008 Brendan Dolan-Gavitt'
    meta_info['contact'] = 'bdolangavitt@wesleyan.edu'
    meta_info['license'] = 'GNU General Public License 2.0 or later'
    meta_info['url'] = 'http://moyix.blogspot.com/'
    meta_info['os'] = 'WIN_32_XP_SP2'
    meta_info['version'] = '1.0'

    def parser(self):
        forensics.commands.command.parser(self)
        self.op.add_option('-y', '--sys-offset', help='SYSTEM hive offset (virtual)',
            action='store', type='int', dest='syshive')
        self.op.add_option('-s', '--sam-offset', help='SAM offset (virtual)',
            action='store', type='int', dest='samhive')

    def help(self):
        return  "Dump (decrypted) LM and NT hashes from the registry"
    
    def execute(self):
	(addr_space, symtab, types) = load_and_identify_image(self.op,
            self.opts)

        # In general it's not recommended to update the global types on the fly,
        # but I'm special and I know what I'm doing ;)
        types.update(regtypes)
        prof = Profile()

        if not self.opts.syshive or not self.opts.samhive:
            op.error("Both SYSTEM and SAM offsets must be provided")
        
        syshiveobj = Object("_CMHIVE", self.opts.syshive, addr_space, profile=prof)
        samhiveobj = Object("_CMHIVE", self.opts.samhive, addr_space, profile=prof)
        if not syshiveobj.Hive.BaseBlock.FileName.endswith("SYSTEM"):
            print "WARN: hive at %x does not appear to be a SYSTEM hive, but continuing anyways" % syshiveobj.offset
        if not samhiveobj.Hive.BaseBlock.FileName.endswith("SAM"):
            print "WARN: hive at %x does not appear to be a SAM hive, but continuing anyways" % samhiveobj.offset
       
        dump_memory_hashes(addr_space, types, self.opts.syshive, self.opts.samhive, prof)
