package laser.utilities;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

/**
 * <PRE>
 * Class Shrinker - A simple class that cuts the size of a file. 
 * <PRE>
 * 
 * @author <A HREF="mailto:2adonis5@cc.gatech.edu">Jorge</A>
 * @version Version 1.0, September 12, 2005
 */
public class Shrinker {

	/** The file to cut */
	private File fileToCut;
	
	/** Will cut the file from this line. */
	private int fromLine;
	
	/** Will cur the file up to this line */
	private int toLine;
	
	/**
	 * Constructor
	 * @param fileToCut
	 * @param fromLine
	 * @param toLine
	 */
	public Shrinker(File fileToCut, int fromLine, int toLine) {
		this.fileToCut = fileToCut;
		this.fromLine = fromLine;
		this.toLine = toLine;
	}
	
	/**
	 * Use to output one single frame of the .btf files
	 * @param fileToCut
	 */
	public Shrinker(File fileToCut) {
		this.fileToCut = fileToCut;
	}

	public String[] getFirstFrameLines(int[] numberLines) {
		String[] retval = new String[numberLines.length];
		
		try {
			BufferedReader tmpReader = 
            	new BufferedReader(new FileReader(fileToCut));
			String temp = null;
			int i = 0;
			temp = tmpReader.readLine();
			int numberLinesIndex = 0; 
			while (temp != null) {
				temp = tmpReader.readLine();
				
				if (temp != null && numberLinesIndex < 4) {
					if (i == numberLines[numberLinesIndex]) {
						retval[numberLinesIndex] = temp;
						numberLinesIndex++;
					}
				}
				
				i++;
			}
		} catch(IOException e) {
			System.out.println("IOException cause in getLaserInfo.");
        }
		
		return retval;
	}
	
	/**
	 * Returns the line numbers of the first frame
	 * @return
	 */
	public int[] getStartingLines() {
		int[] retval = new int[4];
		
		try {
			BufferedReader tmpReader = 
            	new BufferedReader(new FileReader(fileToCut));
			String temp = null;
			int i = 0;
			temp = tmpReader.readLine();
			String timestamp = new String(temp);
			retval[0] = 0;
			int retvalIndex = 1;
			while (temp != null) {
				temp = tmpReader.readLine();
				i = i + 1;
				if (temp != null && temp.equals(timestamp)) {
					retval[retvalIndex] = i;
					retvalIndex++;
				}
			}
		} catch(IOException e) {
			System.out.println("IOException cause in getLaserInfo.");
        }
		
		return retval;
	}
	
	private String[] getLinesToWrite() {
		String[] lines = new String[toLine - fromLine];
		try {
			BufferedReader tmpReader = 
            	new BufferedReader(new FileReader(fileToCut));
			int index = fromLine;
			int i = 0;
			while (i < fromLine) {
				tmpReader.readLine();
				i++;
			}
			i = 0;
			while (index < toLine) {
				String l = tmpReader.readLine();
				lines[i] = l;
				index++;
				i++;
			} 
		} catch(IOException e) {
			System.out.println("IOException cause in getLaserInfo.");
        }
		return lines;
	}

	public boolean createnewFile(File fileT, String[] lines) {
		File file = new File(fileT.getName() + "-1");
		try {
			file.createNewFile();
			FileWriter fileWriter = new FileWriter(file);
			BufferedWriter myWriter = new BufferedWriter(fileWriter);

			for (int i = 0; i < lines.length; i++) {
				myWriter.write(lines[i]);
				myWriter.newLine();
			}
			myWriter.close();
		} catch (IOException e) {
			return false;
		}
		return true;
	}
	
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

//    	File timeFile = new File("../laserData/bumpBTFs/small/timestamp.btf");
//    	
//    	Shrinker s = new Shrinker(timeFile);
//    	int[] firstFrameLines = s.getStartingLines();
//    	
//    	File[] files = new File[7];
//    	files[0] = new File("../laserData/bumpBTFs/small/id.btf");
//    	files[1] = new File("../laserData/bumpBTFs/small/type.btf");
//    	files[2] = new File("../laserData/bumpBTFs/small/timestamp.btf");
//    	files[3] = new File("../laserData/bumpBTFs/small/xscale.btf");
//    	files[4] = new File("../laserData/bumpBTFs/small/yscale.btf");
//    	files[5] = new File("../laserData/bumpBTFs/small/scanximage.btf");
//    	files[6] = new File("../laserData/bumpBTFs/small/scanyimage.btf");
//    	
//    	for (int i = 0; i < 7; i++) {
//        	Shrinker st = new Shrinker(files[i]);
//        	String[] lines = st.getFirstFrameLines(firstFrameLines);
//        	st.createnewFile(files[i], lines);
//    	}

    	
    	File[] files = new File[4];
    	files[0] = new File("../laserData/noBump/laser1nobump.log");
    	files[1] = new File("../laserData/noBump/laser2nobump.log");
    	files[2] = new File("../laserData/noBump/laser3nobump.log");
    	files[3] = new File("../laserData/noBump/laser4nobump.log");

    	for (int i = 0; i < 4; i++) {
    		Shrinker s = new Shrinker(files[i], 1000, 1500);
    		String[] lines = s.getLinesToWrite();
    		s.createnewFile(files[i], lines);
    	}

    }
	
}
