package laser.utilities;
/*
 * LaserFileHandler.java
 *
 * Created on November 23, 2004, 6:42 AM
 */

//package datamerge;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.Math;

/**
 * 
 * @author Wes
 */
public class LaserFileHandler {

	private BufferedReader myReader;

	private Long prevTimeStamp;

	private Long nextTimeStamp;

	private Long curTimeStamp;

	private String prevData;

	private String data;

	private String nextData;

	private BufferedWriter myWriter;

	private String readFileName;

	private String writeFileName;

	/** Creates a new instance of LaserFileHandler */
	public LaserFileHandler(BufferedReader aBufferedReader, String readFileName)
			throws java.io.IOException {
		this.myReader = aBufferedReader;
		this.readFileName = readFileName;

		this.nextTimeStamp = new Long("0");
		increment();
		increment();
	}

	public LaserFileHandler(BufferedReader aBufferedReader,
			String readFileName, String path, String writeFileName) throws java.io.IOException {
		this(aBufferedReader, readFileName);
		this.writeFileName = writeFileName;
			this.myWriter = new BufferedWriter(new FileWriter(new File(path
					+ File.separator + writeFileName)));
	}

	public String getReadFileName() {
		return readFileName;
	}

	public String getWriteFileName() {
		return writeFileName;
	}

	public Long getCurrentTimeStamp() {
		return curTimeStamp;
	}

	public Long getNextTimeStamp() {
		return nextTimeStamp;
	}

	public String getData() {
		return data;
	}

	/*
	 * returns false when next data is null meaning that there is no more data
	 */
	public boolean increment() throws java.io.IOException {
		if (nextTimeStamp != null) {
			prevData = data;
			prevTimeStamp = curTimeStamp;
			curTimeStamp = nextTimeStamp;
			data = nextData;

			String tmp;

			if ((tmp = myReader.readLine()) != null) {
				String[] arr = tmp.split(",", 2);
				nextTimeStamp = new Long(arr[0]);
				nextData = arr[1];
			} else {
				nextTimeStamp = null;
				nextData = null;
			}
			return true;
		} else
			return false;
	}

	public void writeCurrentData() throws java.io.IOException {
		writeDataWithTimeStamp(data, curTimeStamp);
	}

	public void writePreviousData() throws java.io.IOException {
		writeDataWithTimeStamp(prevData, prevTimeStamp);
	}

	private void writeDataWithTimeStamp(String data, Long timeStamp)
			throws java.io.IOException {
		myWriter.write(timeStamp + ", " + data);
		// myWriter.write(data);
		myWriter.newLine();
	}

	public void writeBlankLine() throws java.io.IOException {
		myWriter.write("#");
		myWriter.newLine();
	}

	public void close() throws java.io.IOException {
		myWriter.close();
		myReader.close();
	}

	public void SubtractBackgroundAndWriteToFile(String pointAvg[],
			String pointStdDev[]) throws java.io.IOException {

		do {
			String aScan[] = data.split(", ");
			double bsData[] = new double[aScan.length];
			for (int i = 0; i < aScan.length; i++) {
				if((Double.parseDouble(aScan[i]) > 8100) || (Math.abs(Double.parseDouble(aScan[i])
						- Double.parseDouble(pointAvg[i])) < 10)) {
					// 50 * Double.parseDouble(pointStdDev[i])){
					bsData[i] = -1;
				} else {
					bsData[i] = Double.parseDouble(aScan[i]);
				}
			}
			writeDataWithTimeStamp(makeStringFromDoubleArray(bsData),
					curTimeStamp);
		} while (increment());
	}

	private String makeStringFromDoubleArray(double dblArr[]) {
		String tmpStr = ("" + ((int) dblArr[0]));
		for (int i = 1; i < dblArr.length; i++) {
			tmpStr += (", " + ((int) dblArr[i]));
		}
		return tmpStr;
	}
}
