package laser.utilities;

import java.awt.Color;

/**
 * <PRE>
 * Class LaserData - Holds a LaserData object. A Laser data object is created
 * from the information of the laser in the config files that are in the
 * following format:
 * <name> <x> <y> <theta> <color1> <color2> <color3> <filename>
 * <PRE>
 * 
 * @author <A HREF="mailto:2adonis5@cc.gatech.edu">Jorge</A>
 * @version Version 1.0, September 13, 2005
 */
public class LaserData {

	/** The name of the laser */
	private String laserName;
	
	/** The x position */
	private double xPosition;
	
	/** The y position of the laser */
	private double yPosition;
	
	/** The theta of the position of the laser */
	private double theta;
	
	/** The R "Red" color */
	private int colorR;
	
	/** The G "Green" color */
	private int colorG;
	
	/** The B "Blue" color */
	private int colorB;
	
	/** The color created from the RGB */
	private Color color;
	
	/** The fileName specified */
	private String fileName;
	
	/**
	 * Creates a laser data object
	 * @param laserName
	 * @param xPosition
	 * @param yPosition
	 * @param theta
	 * @param colorR
	 * @param colorG
	 * @param colorB
	 */
	public LaserData(String laserName, double xPosition, double yPosition,
			double theta, int colorR, int colorG, int colorB, String filename) {
		this.laserName = laserName;
		this.xPosition = xPosition;
		this.yPosition = yPosition;
		this.theta = theta;
		this.colorR = colorR;
		this.colorG = colorG;
		this.colorB = colorB;
		this.fileName = filename;
		this.color =  new Color(this.colorR, this.colorG, this.colorB);
	}

	/**
	 * Returns the color created from the passed RGB to the constructor
	 * @return
	 */
	public Color getColor() {
		return color;
	}
	
	/**
	 * Returns the name of the laser
	 * @return
	 */
	public String getLaserName() {
		return laserName;
	}

	/**
	 * Returns the theta of the laser
	 * @return
	 */
	public double getTheta() {
		return theta;
	}

	/**
	 * Returns the x position of the laser
	 * @return
	 */
	public double getXPosition() {
		return xPosition;
	}

	/**
	 * Returns the y position of the lsaer
	 * @return
	 */
	public double getYPosition() {
		return yPosition;
	}
	
	/**
	 * Gets the filename
	 * @return
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * @return Returns the colorB.
	 */
	public int getColorB() {
		return colorB;
	}

	/**
	 * @return Returns the colorG.
	 */
	public int getColorG() {
		return colorG;
	}

	/**
	 * @return Returns the colorR.
	 */
	public int getColorR() {
		return colorR;
	}

	/**
	 * @param fileName The fileName to set.
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}
	
}
