package laser.utilities;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

/**
 * <PRE>
 * Class ConfigFileCreator - This class is responsible for
 * creating configuration files given a vector of LaserDatas. 
 * 
 * The configuration will be in the following format:
 * <number_of_lasers>
 * <name> <x> <y> <theta> <color1> <color2> <color3> <filename>
 * .....
 * <PRE>
 * 
 * @author <A HREF="mailto:2adonis5@cc.gatech.edu">Jorge</A>
 * @version Version 1.0, September 12, 2005
 */
public class ConfigFileCreator {

	/** Contains the data for the lasers to write */
	private Vector lasersData;
	
	/** The path and file name were we need to write the config file */
	private String outputFileName;
	
	/**
	 * Creates a configuration file creator object
	 * @param lasersData
	 */
	public ConfigFileCreator(Vector lasersInfo, String outputFileName) {
		this.lasersData = lasersInfo;
		this.outputFileName = outputFileName;
	}
	
	/**
	 * Creates a statistics configuration file
	 * @return
	 */
	public boolean createStatsConfigFile() {
		if (lasersData == null) {
			return false;
		}
		try {
			File file = new File(outputFileName);
			FileWriter fileWriter = new FileWriter(file);
			BufferedWriter myWriter = new BufferedWriter(fileWriter);

			int size = lasersData.size();
			myWriter.write(size + "");
			myWriter.newLine();
			for (int i = 0; i < lasersData.size(); i++) {
				LaserData laserData = (LaserData) lasersData.get(i);
				myWriter.write(laserData.getLaserName() + " ");
				myWriter.write(laserData.getFileName());
				myWriter.newLine();
			}
			myWriter.close();
		} catch (IOException e) {
			return false;
		}
		return true;
	}
	
	/**
	 * Creates the configuration file
	 * @return
	 */
	public boolean createConfigFile() {
		if (lasersData == null) {
			return false;
		}
		try {
			File file = new File(outputFileName);
			FileWriter fileWriter = new FileWriter(file);
			BufferedWriter myWriter = new BufferedWriter(fileWriter);

			int size = lasersData.size();
			myWriter.write(size + "");
			myWriter.newLine();
			for (int i = 0; i < lasersData.size(); i++) {
				LaserData laserData = (LaserData) lasersData.get(i);
				myWriter.write(laserData.getLaserName() + " ");
				myWriter.write(laserData.getXPosition() + " ");
				myWriter.write(laserData.getYPosition() + " ");
				myWriter.write(laserData.getTheta() + " ");
				myWriter.write(laserData.getColorR() + " ");
				myWriter.write(laserData.getColorG() + " ");
				myWriter.write(laserData.getColorB() + " ");
				myWriter.write(laserData.getFileName());
				myWriter.newLine();
			}
			myWriter.close();
		} catch (IOException e) {
			return false;
		}
		return true;
	}
	
}
