package laser.utilities;

/**
 * <PRE>
 * Class CollapsedData - Holds one frame of collapsed data
 * <PRE>
 * 
 * @author <A HREF="mailto:2adonis5@cc.gatech.edu">Jorge</A>
 * @version Version 1.0, October 30, 2005
 */
public class CollapsedData implements Comparable {

	/** The timestamp of the frame */
	private long timestamp;
	
	/** Id of object */
	private String id;
	
	/** The type of the data */
	private String type;
	
	/** X Scale data */
	private String xscale;
	
	/** Y Scale data */
	private String yscale;
	
	/** Scan X data */
	private String scanx;
	
	/** Scan Y data */
	private String scany;
	
	/**
	 * Constructor
	 * @param timestamp
	 * @param id
	 * @param type
	 * @param xscale
	 * @param yscale
	 * @param scanx
	 * @param scany
	 */
	public CollapsedData(String timestamp, String id, String type, String xscale,
			String yscale, String scanx, String scany) {
		this.timestamp = Long.parseLong(timestamp);
		this.id = id;
		this.type = type;
		this.xscale = xscale;
		this.yscale = yscale;
		this.scanx = scanx;
		this.scany = scany;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object arg0) {
		if (arg0 instanceof CollapsedData) {
			CollapsedData arg = (CollapsedData) arg0;
			if (arg.getTimestamp() == getTimestamp()) {
				return 0;
			} else if (arg.getTimestamp() > getTimestamp()) {
				return -1;
			} else {
				return 1;
			} 
		} else {
			return -1;
		}
	}
	
	/**
	 * @return Returns the id.
	 */
	public String getId() {
		return id;
	}
	
	/**
	 * @return Returns the scanx.
	 */
	public String getScanx() {
		return scanx;
	}
	
	/**
	 * @return Returns the scany.
	 */
	public String getScany() {
		return scany;
	}
	
	/**
	 * @return Returns the timestamp.
	 */
	public long getTimestamp() {
		return timestamp;
	}
	
	/**
	 * @return Returns the type.
	 */
	public String getType() {
		return type;
	}
	
	/**
	 * @return Returns the xscale.
	 */
	public String getXscale() {
		return xscale;
	}
	
	/**
	 * @return Returns the yscale.
	 */
	public String getYscale() {
		return yscale;
	}
	
	
	/**
	 * @param scanx The scanx to set.
	 */
	public void setScanx(String scanx) {
		this.scanx = scanx;
	}
	
	/**
	 * @param scany The scany to set.
	 */
	public void setScany(String scany) {
		this.scany = scany;
	}
	
	/**
	 * @param xscale The xscale to set.
	 */
	public void setXscale(String xscale) {
		this.xscale = xscale;
	}
	
	/**
	 * @param yscale The yscale to set.
	 */
	public void setYscale(String yscale) {
		this.yscale = yscale;
	}
}
