package laser.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;

import laser.utilities.ConfigFileCreator;
import laser.utilities.ConfigFileHandler;
import laser.utilities.LaserData;
import laser.utilities.LaserFileHandler;

/**
 * Class BackgroundSubtractor - The BackgroundSubtractor subtracts the
 * background from the laser scans.  It works by placing points in 
 * buckets (size determined by user input), finding the bucket with
 * enough points to place it over a percentage threshold (value
 * selected through emperical results), and then replacing all values
 * in that bucket and beyond with "0".
 * 
 * Input:
 * "java BackgroundSubtractor <input_directory> <output_directory>
 * The input_directory should be an existing directory that contains
 * the time and space registered laser scan files and nothing else.
 * The output_directory should also exist.  Files can be in it but may
 * be overwritten.
 * 
 */
public class BackgroundSubtractor {

	private static final String CURRENT_DIR = "." + File.separator;
	
	private LaserFileHandler myFileHandler;
	private BufferedReader statsReader;
	private String outputDir;
	
	public BackgroundSubtractor(String statsFileName, String laserFileName,
			String outputDir) {
		this.outputDir = outputDir;
		loadFile(new File(laserFileName));
		String pointAvg[];
		String pointStdDev[];

		try {
			File f = new File(statsFileName);
			statsReader = new BufferedReader(new FileReader(f));
			System.out.println("Loading stats from file " + f.getName() + ".");
			pointAvg = getStringArrayFromStatsFile();
			pointStdDev = getStringArrayFromStatsFile();
			statsReader.close();

			System.out.println("Subtracting background and writing to file...");
			myFileHandler.SubtractBackgroundAndWriteToFile(pointAvg,
					pointStdDev);
			myFileHandler.close();
			System.out.println("Done");
		} catch (java.io.IOException e) {
			System.out.println("IO Exception!");
		}
	}

	public static String getBGFileName(String fileName) {
		return fileName.substring(0, fileName.indexOf(".log"))
				+ "_bgSub.log";
	}
	
	private void loadFile(File aFile) {
		String fileName = aFile.getName();
		if (fileName.indexOf(".log") >= 0) {
			try {
				BufferedReader tmpReader = new BufferedReader(new FileReader(
						aFile));
				String bsFileName = getBGFileName(fileName);
					myFileHandler = new LaserFileHandler(tmpReader, fileName,
							outputDir + File.separator, bsFileName);
			} catch (java.io.IOException e) {
				System.out.println("IOException");
			}
		}
	}

	private String[] getStringArrayFromStatsFile() throws java.io.IOException {
		String tmp = statsReader.readLine();
		return tmp.split(", ");
	}
	
    /**
     * Exits the program.
     */
	public static void exitProgram() {
		System.out.println("Exiting program...");
		System.exit(1);
	}
		
	public static void main(String[] args) {

    	if (args != null) {
	        if (args.length != 2){
	        	
	        	String laserConfigFile = args[0];
	        	String outputDir = args[1];
	        	
	        	ConfigFileHandler laserConfigFileHandler = 
	        		new ConfigFileHandler(laserConfigFile);
	        	String[] lasers = laserConfigFileHandler.getLasersFileName();
	        		        	
	        	/*if (lasers != null && stats != null) {
	        		if (lasers.length == stats.length) {
	        			for (int i = 0; i < lasers.length; i++) {
	        				new BackgroundSubtractor(stats[i], lasers[i], outputDir);
	        			}
	        		}
	        		Vector configFileData = laserConfigFileHandler.getLasers();
		        	String[] laserEnvironFiles = laserConfigFileHandler.getLasersFileName();
					for (int i = 0; i < laserEnvironFiles.length; i++) {
						File f = new File(laserEnvironFiles[i]);
						String completeName = f.getName();
						int indexOfTypeOfFile = completeName.indexOf(".log");
						String name = completeName.substring(
								0, indexOfTypeOfFile);
						String bgName = name + "_bgSub.log";
						String bgFullPath = outputDir + File.separator + 
							bgName;				
						LaserData ld = (LaserData) configFileData.get(i);
						ld.setFileName(
								bgFullPath);
					}
	        		
	        		ConfigFileCreator configFileCreator = 
						new ConfigFileCreator(configFileData, 
								outputDir + File.separator + "bgSubOutput.cfg");
					configFileCreator.createConfigFile();
	        	} else {
	        		System.out.println("The configuration files are corrupted " + 
	        				"or the number of entries in the first configuration " +
							"file does not much the second configuration file.");
	        		exitProgram();
	        	}*/
	        } else {
	        	System.out.println(
	        			"usage: java BackgroundSubtractor <laser_dir> <output_dir>");
	        }
    	}

		System.out.println("Goodbye!");
	}
	
}
