package laser.blobdetect;

import javax.swing.*;

import java.awt.*;
import java.awt.geom.Point2D;
import java.awt.event.*;
import javax.swing.event.MouseInputListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

import laser.tracker.Track;
import laser.utilities.*;

/**
 * Class BlobLaserTracker - The BlobLaserTracker takes in the output of 
 * Laser2BTF, collapses the data and then creates tracks for the data set and 
 * outputs them into files.
 * 
 * Input:
 * "java BlobLaserTracker <input_directory> <output_directory>"
 * The input_directory should be an existing directory that contains
 * the output from Laser2BTF and nothing else.  The output_directory 
 * is created if it does not exist.  Files in it may be overwritten.
 * 
 * Output:
 * The output directory specified will contain the btf files created with
 * the tracks for the data.  Specifically, id.btf, timestamp.btf, xscale.btf,
 * and yscale.btf are created.
 * 
 */

public class BlobLaserTracker {
    private static DataSet btfDataSet;
    
    public BlobLaserTracker() {
    }
        	

	public static void exitProgram() {
		System.out.println("Exiting program...");
		System.exit(1);
	}

    public static void main(String[] args) {
    	if (args.length == 2) {
    		// Create output directory
    	    (new File(args[1])).mkdir();
    	    
    		// input, output for collapse and input for track, output for tracks
    		btfDataSet = new DataSet(args[0], args[1]);
    		btfDataSet.collapseDataSet();
    		btfDataSet.createReadersAndWriters();
    		btfDataSet.loadScanPoints();
        	btfDataSet.completeAllBlobs();
        	btfDataSet.closeReadersAndWriters();
        	btfDataSet.removeCollapseFiles();
        	btfDataSet.compressIds();
        	exitProgram();
    	} else {
    		System.out.println("usage: java BlobLaserTracker <input_dir> <output_dir>");
    	}
    }
}
