package laser.blobdetect;

import javax.swing.*;

import java.awt.*;
import java.awt.geom.Point2D;
import java.awt.event.*;
import javax.swing.event.MouseInputListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

import laser.tracker.Track;
import laser.utilities.*;

/* 
 * This displays a framed area.
 */
public class BlobDraw implements ActionListener {
    private JLabel label;
    private Point cursorPoint;
    private DataSet btfDataSet;
    private static String inputDir;
    
//    private static Vector unusedScanPoints = new Vector();
	
    public BlobDraw() {
    	btfDataSet = new DataSet(inputDir, inputDir);
//    	btfDataSet = new DataSet(inputDir, inputDir, inputDir);
    	btfDataSet.createReaders();
    	btfDataSet.loadScanPoints();
    }
    
    public Component createComponents() {
 //       JButton button = new JButton("Advance 50 Frames");
//        button.setMnemonic(KeyEvent.VK_I);
//        button.addActionListener(this);
//        label.setLabelFor(button);

        /*
         * An easy way to put space between a top-level container
         * and its contents is to put the contents in a JPanel
         * that has an "empty" border.
         */
        JPanel pane = new JPanel(new GridLayout(1, 2));
//        pane.add(button);
//        pane.add(label);
//        pane.setBorder(BorderFactory.createEmptyBorder(
//                                        30, //top
//                                        30, //left
//                                        10, //bottom
//                                        30) //right
//                                        );

        return pane;
    }
    
    private void buildUI(Container container) {
        container.setLayout(new BoxLayout(container,
                                          BoxLayout.PAGE_AXIS));

        CoordinateArea coordinateArea = new CoordinateArea(this);
        container.add(coordinateArea);

        label = new JLabel();
        container.add(label);

        //Align the left edges of the components.
        coordinateArea.setAlignmentX(Component.LEFT_ALIGNMENT);
        label.setAlignmentX(Component.LEFT_ALIGNMENT); //redundant

        // Setting up sample data, delete later
//        unusedScanPoints.add(new Point2D.Double(109.0, 460.0));
//        unusedScanPoints.add(new Point2D.Double(403.0, 249.0));
        
        coordinateArea.repaint();
    }
	
    public void updateCursorLocation(int x, int y) {
        if (x < 0 || y < 0) {
            cursorPoint = null;
            return;
        }
            
        if (cursorPoint == null) {
            cursorPoint = new Point();
        }
        
        cursorPoint.x = x;
        cursorPoint.y = y;
    }

    /**
     * Create the GUI and show it.  For thread safety, this method should be invoked from the 
     * event-dispatching thread.
     */
    private static void createAndShowGUI(String inputDir) {
        //Make sure we have nice window decorations.
        JFrame.setDefaultLookAndFeelDecorated(true);
        
        //Create and set up the window.
        JFrame frame = new JFrame("Laser Tracker");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

//        JButton completeButton = new JButton("Run");
//        completeButton.setMnemonic(KeyEvent.VK_I);
//        completeButton.addActionListener(this);
//        frame.add(completeButton);
        
        //Set up the content pane.
        BlobDraw controller = new BlobDraw();
        //        Component contents = app.createComponents();
        Component contents = controller.createComponents();
        frame.getContentPane().add(contents, BorderLayout.CENTER);

        //DataSet btfDataSet = new DataSet(inputDir, inputDir);
        controller.buildUI(frame.getContentPane());

        //Display the window.
        frame.pack();
        frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
 //   	btfDataSet.completeAllBlobs();
 //   	btfDataSet.closeReadersAndWriters();
 //   	exitProgram();
    }
    
	public static void exitProgram() {
		System.out.println("Exiting program...");
		System.exit(1);
	}

    public static void main(String[] args) {

    	//Schedule a job for the event-dispatching thread:        
    	if (args.length == 1) {
    		inputDir = args[0];
    		//creating and showing this application's GUI.
            javax.swing.SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    createAndShowGUI(inputDir); 
                }
            });
    	} else {
    		System.out.println("usage: java BlobDraw <input_dir>");
    	}
    }

    public static class CoordinateArea extends JComponent implements MouseInputListener {
        Point point = null;
        BlobDraw controller;
        Dimension preferredSize = new Dimension(1000,1000);
        Color gridColor;
        Point2D.Double gridSize = new Point2D.Double();
//        int countNum;
    
        public CoordinateArea(BlobDraw controller) {
            this.controller = controller;
//            this.countNum = 0; 
            
            //Add a border of 5 pixels at the left and bottom and 1 pixel at the top and right.
//            setBorder(BorderFactory.createMatteBorder(1,5,5,1,Color.RED));
            addMouseListener(this);
            addMouseMotionListener(this);
            setBackground(Color.WHITE);
            setOpaque(true);
        }
    
        public Dimension getPreferredSize() {
            return preferredSize;
        }
    
        protected void paintComponent(Graphics g) {
        	Point2D.Double randomPoint;
        	
        	//Paint background if we're opaque.
            if (isOpaque()) {
                g.setColor(getBackground());
                g.fillRect(0, 0, getWidth(), getHeight());
            }

            g.setColor(getForeground());
            
            Vector scanUnusedData = controller.btfDataSet.getUnusedScanPoints();
            // Paint unused points
            if (scanUnusedData != null) {
            	for (int i = 0; i < scanUnusedData.size(); i++) {
            		g.setColor(Color.GRAY);
            		randomPoint = (Point2D.Double) scanUnusedData.get(i);
//            		g.fillOval((int) Math.round(randomPoint.x/2), (int) Math.round(randomPoint.y/2), 8, 8);
            		g.fillOval((int) Math.round(randomPoint.x * 10), (int) Math.round(randomPoint.y * 10), 6, 6);
            	}
            }
            
            Vector scanCurrentData = controller.btfDataSet.getCurrentPassScanPoints();
            // Paint current points
            if (scanCurrentData != null) {
            	for (int i = 0; i < scanCurrentData.size(); i++) {
            		g.setColor(Color.RED);
            		randomPoint = (Point2D.Double) scanCurrentData.get(i);
//            		g.fillOval((int) Math.round(randomPoint.x/2), (int) Math.round(randomPoint.y/2), 4, 4);
            		g.fillOval((int) Math.round(randomPoint.x * 10), (int) Math.round(randomPoint.y * 10), 4, 4);
            	}
            }
            
            Vector blobs = controller.btfDataSet.getBlobs();
            for (int i = 0; i < blobs.size(); i++) {
            	Blob blob = (Blob) blobs.get(i);
            	
            	Vector blobScanPoints = blob.getBlobScanPoints();
            	if (blobScanPoints.size() > 3) {
            		for (int j = 0; j < blobScanPoints.size(); j++) {
            			g.setColor(Color.RED);
            			randomPoint = (Point2D.Double) blobScanPoints.get(j);
//            			g.fillOval((int) Math.round(randomPoint.x/2), (int) Math.round(randomPoint.y/2), 4, 4);
            			g.fillOval((int) Math.round(randomPoint.x * 10), (int) Math.round(randomPoint.y * 10), 4, 4);
            		}
            	
            		Point2D.Double center = blob.getBlobCenter();
            		Point2D.Double origCenter = blob.getBlobOriginalCenter();

            		g.setColor(Color.GREEN);
//            		g.fillOval((int) Math.round(origCenter.x/2), (int) Math.round(origCenter.y/2), 4, 4);
            		g.fillOval((int) Math.round(origCenter.x * 10), (int) Math.round(origCenter.y * 10), 4, 4);
            		g.setColor(Color.BLUE);
//            		g.fillOval((int) Math.round(center.x/2), (int) Math.round(center.y/2), 4, 4);
            		g.fillOval((int) Math.round(center.x * 10), (int) Math.round(center.y * 10), 4, 4);
            	}
            }

            Vector scanPreviousData = controller.btfDataSet.getPreviousPassScanPoints();
            // Paint current points
            if (scanPreviousData != null) {
            	for (int i = 0; i < scanPreviousData.size(); i++) {
            		g.setColor(Color.PINK);
            		randomPoint = (Point2D.Double) scanPreviousData.get(i);
//            		g.fillOval((int) Math.round(randomPoint.x/2), (int) Math.round(randomPoint.y/2), 4, 4);
            		g.fillOval((int) Math.round(randomPoint.x * 10), (int) Math.round(randomPoint.y * 10), 4, 4);
            	}
            }
        }
        
        //Methods required by the MouseInputListener interface.
        public void mouseClicked(MouseEvent e) {
        	int advanceFrameRate = 100;
        	
        	for (int i = 0; i < advanceFrameRate; i++) {
        		//        	countNum += countNum;
        		// if there are still unused scan points, find all the blobs.  if not, get a new time slice
        		if (controller.btfDataSet.getUnusedScanPoints().size() > 0) {
        			// while loop gets them all at once.  comment out while loop to see one blob at a time.
        			while (controller.btfDataSet.getUnusedScanPoints().size() > 0) {
        				controller.btfDataSet.calculateNextBlob();
        				//			repaint();
        			}
        			//    			controller.btfDataSet.writeLineToBTF();
        		} else {
        			controller.btfDataSet.loadScanPoints();
        			controller.btfDataSet.trackBlob();
        			//    			controller.btfDataSet.writeLineToBTF();
        			//    			if (countNum == 10) {
        			//    			if (e.getClickCount() == 10) {
        			//    				controller.btfDataSet.closeReadersAndWriters();
        			//    			}
        			//		repaint();
        		}
        		repaint();
        		//			controller.btfDataSet.writeLineToBTF();
        	}
        }
        
        public void mouseExited(MouseEvent e) {
        	controller.btfDataSet.closeReaders();
        	exitProgram();
        }
        public void mouseDragged(MouseEvent e) { }
        public void mouseEntered(MouseEvent e) { }
        public void mousePressed(MouseEvent e) { }
        public void mouseReleased(MouseEvent e) { }
        public void mouseMoved(MouseEvent e) { }

    }
}
