package laser.blobdetect;

import java.awt.Component;
import java.awt.Container;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;

import laser.blobdetect.CoordinatesDemo.CoordinateArea;
import laser.utilities.LaserTrackerConstants;

/**
 * Class BlobDetect - This is used to identify blobs in a data set of points.
 * Usage: java BlobDetect <input_dir>
 * 
 * @author <A HREF="mailto:summer@cc.gatech.edu">Summer Adams</A>
 * @version Version 1.0, February 25, 2006
 */
public class BlobDetect implements LaserTrackerConstants {
	
	/** Directory where the input files are located */
	private String inputDir;
			
	/** The buffered reader for the input timestamp.btf file */
	private BufferedReader timeReader;
	
	/** The buffered reader for the scanximage.btf file */
	private BufferedReader xReader;
	
	/** The buffered reader for the scanyimage.btf file */
	private BufferedReader yReader;
				
	/**
	 * Constructor
	 * @param inputDir
	 */
	public BlobDetect(String inputDir){
		
		System.out.println("Starting Tracker...");
		
		this.inputDir = inputDir;
		
		//creates the readers and writers
		createReadersAndWriters();
										
		closeReadersAndWriters();
		
		System.out.println("I'm Done");
	}
	
	
	/**
	 * Closes the buffered readers
	 */
	private void closeReadersAndWriters() {
		try {
			timeReader.close();
			xReader.close();
			yReader.close();
		} catch (IOException e) {
			System.out.println("Error: Error closing files");
			exitProgram();
		}
	}
	
	/**
	 * Creates the buffered readers
	 */
	private void createReadersAndWriters() {
		try {
			File timeIn = new File(inputDir + File.separator + TIME_STAMP_BTF);
			File xIn = new File(inputDir + File.separator + SCAN_X_IMAGE_BTF);
			File yIn = new File(inputDir + File.separator + SCAN_Y_IMAGE_BTF);
			
			timeReader = new BufferedReader(new FileReader(timeIn));
			xReader = new BufferedReader(new FileReader(xIn));
			yReader = new BufferedReader(new FileReader(yIn));			
		} catch (IOException e) {
			System.out.println("Error: error loading input files");
			exitProgram();
		}
	}
	
    /**
     * Exits the program.
     */
	public static void exitProgram() {
		System.out.println("Exiting program...");
		System.exit(1);
	}

	public static void main(String[] args){
		if (args.length == 1){
			String inputDir = args[0];
			new BlobDetect(inputDir);
		} else {
			System.out.println(
					"usage: java Tracker <input_dir>");
		}
	}
}