package laser.blobdetect;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.*;
import java.awt.geom.*;

/*
 * Class DataSet - Represents data sets
 * For now, only represents background subtracted btf as input and
 * 		tracked data as output (btf)
 */
public class Blob {
	
	private Vector blobScanPoints = new Vector();
	private Point2D.Double blobCenter = new Point2D.Double();
	private Point2D.Double blobOriginalCenter = new Point2D.Double();
	private boolean blobComplete = false;
	private boolean blobSignificant = false;	// Does this blob have enough points to care about?
	private int id = 0;
					
	public Blob(Point2D.Double blobCenter, Point2D.Double blobOriginalCenter, Vector blobScanPoints) {
		this.blobOriginalCenter = blobOriginalCenter;
		this.blobCenter = blobCenter;
		this.blobScanPoints.addAll(blobScanPoints);
//		this.id += 1;
//		this.blobScanPoints = blobScanPoints.;
	} // End of Constructor

	public Blob(Point2D.Double blobCenter, Point2D.Double blobOriginalCenter, Vector blobScanPoints, int blobSize) {
		this.blobOriginalCenter = blobOriginalCenter;
		this.blobCenter = blobCenter;
		this.blobScanPoints.addAll(blobScanPoints);
		this.id = blobSize;
//		this.blobScanPoints = blobScanPoints.;
	} // End of Constructor

	public Vector getBlobScanPoints() {
		return blobScanPoints;
	}

	public Point2D.Double getBlobCenter() {
		return blobCenter;
	}

	public Point2D.Double getBlobOriginalCenter() {
		return blobOriginalCenter;
	}

	public double getXOfCenter() {
		return blobCenter.x;
	}

	public double getYOfCenter() {
		return blobCenter.y;
	}

	public boolean getBlobComplete() {
		return blobComplete;
	}

	public boolean getBlobSignificant() {
		return blobSignificant;
	}

	public int getBlobId() {
		return id;
	}

	public void setBlobComplete(boolean blobComplete) {
		this.blobComplete = blobComplete;
	}

	public void setBlobCenter(Point2D.Double blobCenter) {
		this.blobCenter = blobCenter;
	}

	public void setId(int id) {
		this.id = id;
	}

}
