// Usage:  java TimeRegister <input_dir> <output_dir>

// Rounds the timestamps in a raw laser file down to the
// nearest lower integer divisible by TIMESTEP_LENGTH
// Each file in the <input_dir> must be a raw laser file

import java.io.*;
import java.util.*;

public class TimeRegister {
  // Global Constant List
  public static final double TIMESTEP_LENGTH = 50.0;


  public static void main(String args[]) throws Exception {
    // Variable List
    File[] inputFiles = (new File(args[0])).listFiles();
    BufferedReader input;
    PrintWriter output;
    String line = new String();
    String oldTime = new String();
    long newTime = 0;
    long previousTime = Long.MAX_VALUE;
    String previousLine = new String();
    long latestStartTime = 0;
    int count = 0;

    // Create output directory
    (new File(args[1])).mkdir();

    // Open the input files & and get the first line from each, storing the latest timestamp
    for(int i = 0; i < inputFiles.length; i++) {
      // Open a file
      input = new BufferedReader(new FileReader(inputFiles[i]));

      // Get line and save if latest timestamp
      if(new Long((line = input.readLine()).substring(0, line.indexOf(","))) > latestStartTime)
        latestStartTime = new Long(line.substring(0, line.indexOf(",")));

      // Close file
      input.close();
    }

    // Convert latestStartTime into newTime format
    latestStartTime = (long) (Math.floor(((new Double(latestStartTime)).doubleValue()) / TIMESTEP_LENGTH) * TIMESTEP_LENGTH);

    // For each input file
    for(int i = 0; i < inputFiles.length; i++) {
      // Open input and output files
      input = new BufferedReader(new FileReader(inputFiles[i]));
      output = new PrintWriter(new FileWriter(args[1] + File.separator + inputFiles[i].getName()));

      // For each line
      while((line = input.readLine()) != null) {
        // Give the user a clue
        if(count++ % 1000 == 0)
          System.out.print(".");

        // Extract the timestamp
        oldTime = line.substring(0, line.indexOf(","));

        // Adjust the timestamp
        newTime = (long) (Math.floor(((new Double(oldTime)).doubleValue()) / TIMESTEP_LENGTH) * TIMESTEP_LENGTH);

        // If the timestamp is less than the latestStartTime, ignore (though set previousLine, in case first timestamp is missing)
        if(new Long(newTime) < latestStartTime) {
          previousLine = new String((long) (newTime + TIMESTEP_LENGTH) + line.substring(line.indexOf(",")));
          previousTime = newTime;
          continue;
        }

        // If we skipped one or more timestamps, fill the gap with previousLine
        while(newTime - TIMESTEP_LENGTH > previousTime && previousTime > 0) {
          output.write(previousLine + "\n");
          previousTime += TIMESTEP_LENGTH;
          previousLine = new String((long) (previousTime + TIMESTEP_LENGTH) + previousLine.substring(previousLine.indexOf(",")));
        }

        // Then, if this is not a duplicate, output it
        if(previousTime != newTime) {
          // Output the timestamp
          output.write("" + newTime);

          // Output the rest of the line
          output.write(line.substring(line.indexOf(",")) + "\n");
        }

        // Store current information for next timestamp
        previousLine = new String((long) (newTime + TIMESTEP_LENGTH) + line.substring(line.indexOf(",")));
        previousTime = newTime;
      }

      // Close input and output files
      input.close();
      output.close();
    }
  }
}