// Eliminates points outside the specified range
// Usage:  OutOfBounds <Input-BTF-Dir> <Output-Dir> <Min-x> <Max-x> <Min-y> <Max-y>
// Outputs new btf directory with updated id.btf
import java.io.*;
import java.util.*;

public class OutOfBounds {
  // Global Constants

  // Global Variables

  public static void main(String[] args) {
    try {
      // Constants list
      double MIN_X = new Double(args[2]);
      double MAX_X = new Double(args[3]);
      double MIN_Y = new Double(args[4]);
      double MAX_Y = new Double(args[5]);

      // Variable List
      BufferedReader inputX = new BufferedReader(new FileReader(new File(args[0] + File.separator + "scanxscale.btf")));
      BufferedReader inputY = new BufferedReader(new FileReader(new File(args[0] + File.separator + "scanyscale.btf")));
      BufferedWriter outputX = new BufferedWriter(new FileWriter(new File(args[1] + File.separator + "scanxscale.btf")));
      BufferedWriter outputY = new BufferedWriter(new FileWriter(new File(args[1] + File.separator + "scanyscale.btf")));
      String tempX = new String();
      String tempY = new String();
      String[] xList = new String[361];
      String[] yList = new String[361];

      // For each line in the btf files
      // Read in an x line
      while((tempX = inputX.readLine()) != null) {
        // Read in a y line
        tempY = inputY.readLine();

        // Tokenize them
        xList = tempX.split(", ");
        yList = tempY.split(", ");

        // Reset temps
        tempX = new String();
        tempY = new String();

        // Check each x,y pair for inclusion in the bounds
        for(int i = 0; i < xList.length; i++) {
          // If in bounds
          if(new Double(xList[i]) > MIN_X && new Double(xList[i]) < MAX_X &&
             new Double(yList[i]) > MIN_Y && new Double(yList[i]) < MAX_Y) {
            // Add to new list
            tempX += xList[i] + ", ";
            tempY += yList[i] + ", ";
          }
        }

        // Eliminate trailing ", "
        tempX = tempX.substring(0, tempX.length() - 2);
        tempY = tempY.substring(0, tempY.length() - 2);

        // Write out new x and y lists
        outputX.write(tempX + "\n");
        outputY.write(tempY + "\n");
      }

      // Close files
      inputX.close();
      inputY.close();
      outputX.close();
      outputY.close();
    }
    catch(Exception e) {System.out.println(e);}
  }
}