#include "config.h"
#include <assert.h>
#include <fcntl.h>
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <string.h>
#include "io.h"
#include "unix_defs.h"

#include "test_funcs.h"

extern void init_written_data();

char *comment_array[] =
{"this is a comment in the file",
 "this is another comment in the file"};

first_rec rec1_array[13];

second_rec rec2_array[4];

third_rec rec3_array[5];

fourth_rec rec4;

fifth_rec rec5;

sixth_rec rec6_array[4];

nested_rec rec7_array[1];

later_rec rec8_array[3];

ninth_rec rec9_array[6];

string_array_rec string_array_array[6];

int
first_rec_eq(r1, r2)
first_rec *r1, *r2;
{
    if (r1->integer_field != r2->integer_field)
	return 0;
    if (r1->double_field != r2->double_field)
	return 0;
    if (r1->char_field != r2->char_field)
	return 0;
    return 1;
}

int
second_rec_eq(r1, r2)
second_rec *r1, *r2;
{
    if (r1->integer_field != r2->integer_field)
	return 0;
    if (r1->short_field != r2->short_field)
	return 0;
    if (r1->long_field != r2->long_field)
	return 0;
    if ((r1->string != NULL) || (r2->string != NULL)) {
	if ((r1->string != NULL) && (r2->string != NULL)) {
	    if (strcmp(r1->string, r2->string) != 0)
		return 0;
	} else {
	    return 0;
	}
    }
    if (r1->double_field != r2->double_field)
	return 0;
    if (r1->char_field != r2->char_field)
	return 0;
    return 1;
}

int
third_rec_eq(r1, r2)
third_rec *r1, *r2;
{
    if (r1->integer_field != r2->integer_field)
	return 0;
    if (r1->long_field != r2->long_field)
	return 0;
    if (r1->uint_field != r2->uint_field)
	return 0;
    if (r1->ulong_field != r2->ulong_field)
	return 0;
    if ((r1->string != NULL) || (r2->string != NULL)) {
	if ((r1->string != NULL) && (r2->string != NULL)) {
	    if (strcmp(r1->string, r2->string) != 0)
		return 0;
	} else {
	    return 0;
	}
    }
    if (r1->double_field != r2->double_field)
	return 0;
    if ((r1->string2 != NULL) || (r2->string2 != NULL)) {
	if ((r1->string2 != NULL) && (r2->string2 != NULL)) {
	    if (strcmp(r1->string2, r2->string2) != 0)
		return 0;
	} else {
	    return 0;
	}
    }
    if (r1->char_field != r2->char_field)
	return 0;
    if (r1->enum_field != r2->enum_field)
	return 0;
    return 1;
}

#define ARRAY_SIZE 14

int
fourth_rec_eq(r1, r2)
fourth_rec *r1, *r2;
{
    int i, j;
    if (r1->ifield != r2->ifield)
	return 0;
    for (i = 0; i < ARRAY_SIZE; i++) {
	if (r1->int_array[i] != r2->int_array[i])
	    return 0;
    }
    for (i = 0; i < 2; i++) {
	for (j = 0; j < 2; j++) {
	    if (r1->double_array[i][j] != r2->double_array[i][j])
		return 0;
	}
    }
    return 1;
}

int
emb_rec_eq(r1, r2)
embedded_rec *r1, *r2;
{
    if (r1->ifield != r2->ifield)
	return 0;
    if ((r1->string != NULL) || (r2->string != NULL)) {
	if ((r1->string != NULL) && (r2->string != NULL)) {
	    if (strcmp(r1->string, r2->string) != 0)
		return 0;
	} else {
	    return 0;
	}
    }
    if (r1->dfield != r2->dfield)
	return 0;
    return 1;
}

int
fifth_rec_eq(r1, r2)
fifth_rec *r1, *r2;
{
    int i;
    for (i = 0; i < 4; i++) {
	if (!emb_rec_eq(&r1->earray[i], &r2->earray[i]))
	    return 0;
    }
    return 1;
}

int
sixth_rec_eq(r1, r2)
sixth_rec *r1, *r2;
{
    int i;
    if (r1->icount != r2->icount)
	return 0;
    if ((r1->string != NULL) || (r2->string != NULL)) {
	if ((r1->string != NULL) && (r2->string != NULL)) {
	    if (strcmp(r1->string, r2->string) != 0)
		return 0;
	} else {
	    return 0;
	}
    }
    for (i = 0; i < r1->icount; i++) {
	if (r1->var_int_array[i] != r2->var_int_array[i])
	    return 0;
	if (r1->var_double_array[i] != r2->var_double_array[i])
	    return 0;
	if (!second_rec_eq(&r1->var_string_array[i], &r2->var_string_array[i]))
	    return 0;
    }
    if (r1->dfield != r2->dfield)
	return 0;
    return 1;
}

int
nested_rec_eq(r1, r2)
nested_rec *r1, *r2;
{
    if (r1->integer_field != r2->integer_field)
	return 0;
    if (!second_rec_eq(&r1->nested_rec, &r2->nested_rec))
	return 0;
    if ((r1->string != NULL) || (r2->string != NULL)) {
	if ((r1->string != NULL) && (r2->string != NULL)) {
	    if (strcmp(r1->string, r2->string) != 0)
		return 0;
	} else {
	    return 0;
	}
    }
    return 1;
}

int
later_rec_eq(r1, r2)
later_rec *r1, *r2;
{
    if (r1->integer_field != r2->integer_field)
	return 0;
    if ((r1->string != NULL) || (r2->string != NULL)) {
	if ((r1->string != NULL) && (r2->string != NULL)) {
	    if (strcmp(r1->string, r2->string) != 0)
		return 0;
	} else {
	    return 0;
	}
    }
    if (r1->double_field != r2->double_field)
	return 0;
    return 1;
}

int
ninth_rec_eq(r1, r2)
ninth_rec *r1, *r2;
{
    int i;
    if (r1->vec_length != r2->vec_length)
	return 0;
    for (i = 0; i < r1->vec_length; i++) {
	int j;
	if (r1->eventv[i].iov_len != r2->eventv[i].iov_len)
	    return 0;

	for (j = 0; j< r1->eventv[i].iov_len; j++) {
	    if (((char*)r1->eventv[i].iov_base)[j] != ((char*)r2->eventv[i].iov_base)[j]) 
		return 0;
	}
    }
    return 1;
}

int
string_array_eq(r1, r2)
string_array_rec *r1, *r2;
{
    int i;
    if (r1->array_len != r2->array_len)
	return 0;
    if ((r1->base_string != NULL) || (r2->base_string != NULL)) {
	if ((r1->base_string != NULL) && (r2->base_string != NULL)) {
	    if (strcmp(r1->base_string, r2->base_string) != 0)
		return 0;
	} else {
	    return 0;
	}
    }
    for (i = 0; i < r1->array_len; i++) {
	if ((r1->array[i] != NULL) || (r2->array[i] != NULL)) {
	    if ((r1->array[i] != NULL) && (r2->array[i] != NULL)) {
		if (strcmp(r1->array[i], r2->array[i]) != 0) {
		    printf("string array comparison failed for string entry %d\n",
			   i);
		    return 0;
		}
	    } else {
		printf("string array comparison failed for string entry %d\n",
		       i);
		return 0;
	    }
	}
    }
    return 1;
}

void
init_written_data()
{
    int i, j, k, index;
    memset((char *) &rec1_array, 0, sizeof(rec1_array));
    rec1_array[0].integer_field = 14;
    rec1_array[0].double_field = 2.717;
    rec1_array[0].char_field = 'A';
    rec1_array[1].integer_field = 17;
    rec1_array[1].double_field = rec1_array[0].double_field * 3.0;
    rec1_array[1].char_field = 'B';
    rec1_array[2].integer_field = rec1_array[1].integer_field * 2;
    rec1_array[2].double_field = rec1_array[1].double_field * 2.717;
    rec1_array[2].char_field = 'C';
    for (i = 0; i < 10; i++) {
	rec1_array[i + 3].integer_field = 2 * i * i;
	rec1_array[i + 3].double_field = 2.717 * (i * i);
	rec1_array[i + 3].char_field = 'D' + i;
    }

    memset((char *) &rec2_array[0], 0, sizeof(rec2_array));
    rec2_array[0].integer_field = 14;
    rec2_array[0].short_field = 27;
    rec2_array[0].long_field = 987234;
    rec2_array[0].string = "testing";
    rec2_array[0].double_field = 2.717;
    rec2_array[0].char_field = 'A';

    rec2_array[1].integer_field = 14;
    rec2_array[1].short_field = 27;
    rec2_array[1].long_field = 987234;
    rec2_array[1].string = NULL;
    rec2_array[1].double_field = 2.717;
    rec2_array[1].char_field = 'A';

    rec2_array[2].integer_field = 14;
    rec2_array[2].short_field = 27;
    rec2_array[2].long_field = 987234;
    rec2_array[2].string = NULL;
    rec2_array[2].double_field = 2.717;
    rec2_array[2].char_field = 'A';

    rec2_array[3].integer_field = 14;
    rec2_array[3].short_field = 27;
    rec2_array[3].long_field = 987234;
    rec2_array[3].string = "the end";
    rec2_array[3].double_field = 2.717;
    rec2_array[3].char_field = 'A';

    memset((char *) &rec3_array[0], 0, sizeof(rec3_array));
    rec3_array[0].integer_field = 14;
    rec3_array[0].long_field = 987234;
    rec3_array[0].uint_field = 0xf7e589ce;	/* = 4159015374 */
#if SIZEOF_LONG==64
    rec3_array[0].ulong_field = 0xf7e589ceec9dd130;
#else
    rec3_array[0].ulong_field = 0xec9dd130;	/* = 3969765680 */
#endif
    rec3_array[0].string = "testing";
    rec3_array[0].double_field = 2.717;
    rec3_array[0].string2 = "jambalaya";
    rec3_array[0].char_field = 'A';
    rec3_array[0].enum_field = Red_Stripe;

    rec3_array[1].integer_field = 14;
    rec3_array[1].long_field = 987234;
    rec3_array[1].uint_field = 0xf7e589ce;	/* = 4159015374 */
#if SIZEOF_LONG==64
    rec3_array[1].ulong_field = 0xf7e589ceec9dd130;
#else
    rec3_array[1].ulong_field = 0xec9dd130;	/* = 3969765680 */
#endif
    rec3_array[1].string = NULL;
    rec3_array[1].double_field = 2.717;
    rec3_array[1].string2 = "jambalaya";
    rec3_array[1].char_field = 'A';
    rec3_array[1].enum_field = Paulaner;

    rec3_array[2].integer_field = 14;
    rec3_array[2].long_field = 987234;
    rec3_array[2].uint_field = 0xf7e589ce;	/* = 4159015374 */
#if SIZEOF_LONG==64
    rec3_array[2].ulong_field = 0xf7e589ceec9dd130;
#else
    rec3_array[2].ulong_field = 0xec9dd130;	/* = 3969765680 */
#endif
    rec3_array[2].string = "testing";
    rec3_array[2].double_field = 2.717;
    rec3_array[2].string2 = NULL;
    rec3_array[2].char_field = 'A';
    rec3_array[2].enum_field = Pilsner;

    rec3_array[3].integer_field = 14;
    rec3_array[3].long_field = 987234;
    rec3_array[3].uint_field = 0xf7e589ce;	/* = 4159015374 */
#if SIZEOF_LONG==64
    rec3_array[3].ulong_field = 0xf7e589ceec9dd130;
#else
    rec3_array[3].ulong_field = 0xec9dd130;	/* = 3969765680 */
#endif
    rec3_array[3].string = NULL;
    rec3_array[3].double_field = 2.717;
    rec3_array[3].string2 = NULL;
    rec3_array[3].char_field = 'A';
    rec3_array[3].enum_field = Red_Stripe;

    rec3_array[4].integer_field = 14;
    rec3_array[4].long_field = 987234;
    rec3_array[4].uint_field = 0xf7e589ce;	/* = 4159015374 */
#if SIZEOF_LONG==64
    rec3_array[4].ulong_field = 0xf7e589ceec9dd130;
#else
    rec3_array[4].ulong_field = 0xec9dd130;	/* = 3969765680 */
#endif
    rec3_array[4].string = "testing";
    rec3_array[4].double_field = 2.717;
    rec3_array[4].string2 = "jambalaya";
    rec3_array[4].char_field = 'A';
    rec3_array[4].enum_field = Pilsner;

    memset((char *) &rec4, 0, sizeof(rec4));
    for (i = 0; i < ARRAY_SIZE; i++) {
	rec4.int_array[i] = 297 + i;
    }
    rec4.double_array[0][0] = 1.0;
    rec4.double_array[0][1] = 2.0;
    rec4.double_array[1][0] = 3.0;
    rec4.double_array[1][1] = 4.0;
    rec4.ifield = -rec4.int_array[ARRAY_SIZE - 1];

    memset((char *) &rec5, 0, sizeof(rec5));
    rec5.earray[0].dfield = 4.0;
    rec5.earray[0].ifield = 4;
    rec5.earray[0].string = "string20";
    rec5.earray[1].dfield = 3.0;
    rec5.earray[1].ifield = 3;
    rec5.earray[1].string = "string15";
    rec5.earray[2].dfield = 2.0;
    rec5.earray[2].ifield = 2;
    rec5.earray[2].string = "string10";
    rec5.earray[3].dfield = 1.0;
    rec5.earray[3].ifield = 1;
    rec5.earray[3].string = "string5";

    k = 0;
    for (i = 1; i < 20; i += 5) {
	rec6_array[k].string = malloc(10);
	memset(rec6_array[k].string, 0, 10);
	sprintf(rec6_array[k].string, "variant%d", i);
	rec6_array[k].icount = 2 * i;
	rec6_array[k].var_int_array = malloc(sizeof(((sixth_rec_ptr) 0)->var_int_array[0]) * rec6_array[k].icount);
	rec6_array[k].var_double_array = malloc(sizeof(double) * rec6_array[k].icount);
	rec6_array[k].var_string_array = malloc(sizeof(second_rec) * rec6_array[k].icount);
	for (j = 0; j < rec6_array[k].icount; j++) {
	    rec6_array[k].var_int_array[j] = 297 + j;
	    rec6_array[k].var_double_array[j] = 2.717 * j;
	    rec6_array[k].var_string_array[j].integer_field = 345 * j;
	    rec6_array[k].var_string_array[j].short_field = j;
	    rec6_array[k].var_string_array[j].long_field = 785 * j;
	    rec6_array[k].var_string_array[j].string = malloc(15);
	    memset(rec6_array[k].var_string_array[j].string, 0, 15);
	    sprintf(rec6_array[k].var_string_array[j].string,
		    "substring%d", j);
	    rec6_array[k].var_string_array[j].double_field = 3.1415 * j;
	    rec6_array[k].var_string_array[j].char_field = 'a' + 2 * j;
	}
	k++;
    }
    rec7_array[0].integer_field = 47;
    rec7_array[0].nested_rec.integer_field = 14;
    rec7_array[0].nested_rec.short_field = 27;
    rec7_array[0].nested_rec.long_field = 987234;
    rec7_array[0].nested_rec.string = "Another string";
    rec7_array[0].nested_rec.double_field = 2.717;
    rec7_array[0].nested_rec.char_field = 'A';
    rec7_array[0].string = "Yet another string";

    memset((char *) &rec8_array[0], 0, sizeof(rec8_array));
    rec8_array[0].integer_field = 9872346;
    rec8_array[0].string = "ABCD";
    rec8_array[0].double_field = 3.14159265358797323;

    rec8_array[1].integer_field = 23462346;
    rec8_array[1].string = "Efghij";
    rec8_array[1].double_field = 3.14159265358797323 * 2.0;

    rec8_array[2].integer_field = 2346987;
    rec8_array[2].string = "Klmn";
    rec8_array[2].double_field = 3.14159265358797323 * 3.0;

    index = 0;
    for (i = 1; i < 10; i += 2) {
        memset((char *) &rec9_array[index], 0, sizeof(ninth_rec));
	memset((char *) &string_array_array[index], 0, 
	       sizeof(string_array_rec));
	rec9_array[index].vec_length = i;
	rec9_array[index].eventv = malloc(sizeof(((ninth_rec_ptr) 0)->eventv[0]) * rec9_array[index].vec_length);

	string_array_array[index].array_len = i;
	string_array_array[index].array = malloc(sizeof(char*) * i);

	for (j = 0; j < rec9_array[index].vec_length; j++) {
	    int k;
	    rec9_array[index].eventv[j].iov_len = j + i;
	    rec9_array[index].eventv[j].iov_base = malloc(j + i);
	    string_array_array[index].array[j] = malloc(i + j + 2);

	    for (k=0; k<j+i; k++) {
		((char*)rec9_array[index].eventv[j].iov_base)[k] = 'A' + k + i/5;
		string_array_array[index].array[j][k] = 'a' + k + i;
	    }
	    string_array_array[index].array[j][k] = 0;
	}
	if ((i %4) == 1) {
	    string_array_array[index].base_string = NULL;
	} else {
	    string_array_array[index].base_string = strdup("Whoa there!");
	}
	index++;
    }
}

void
free_written_data()
{
    int i, j, k, index;
    k = 0;
    for (i = 1; i < 20; i += 5) {
	for (j = 0; j < rec6_array[k].icount; j++) {
	    free(rec6_array[k].var_string_array[j].string);
	}
	free(rec6_array[k].string);
	free(rec6_array[k].var_int_array);
	free(rec6_array[k].var_double_array);
	free(rec6_array[k].var_string_array);
	k++;
    }
    index = 0;
    for (i = 1; i < 10; i += 2) {
	for (j = 0; j < rec9_array[index].vec_length; j++) {
	    free(rec9_array[index].eventv[j].iov_base);
	    free(string_array_array[index].array[j]);
	}
	free(rec9_array[index].eventv);
	free(string_array_array[index].array);
	index++;
    }
}

IOField field_list[] = {
    {"integer field", "integer", 
       sizeof(int), IOOffset(first_rec_ptr, integer_field)},
    {"double field", "float",
       sizeof(double), IOOffset(first_rec_ptr, double_field)},
    {"char field", "char",
       sizeof(char), IOOffset(first_rec_ptr, char_field)},
    { NULL, NULL, 0, 0}
};

IOField field_list2[] = {
    {"integer field", "integer", 
       sizeof(int), IOOffset(second_rec_ptr, integer_field)},
    {"short field", "integer", 
       sizeof(short), IOOffset(second_rec_ptr, short_field)},
    {"long field", "integer", 
       sizeof(long), IOOffset(second_rec_ptr, long_field)},
    {"string field", "string",
       sizeof(char *), IOOffset(second_rec_ptr, string)},
    {"double field", "float",
       sizeof(double), IOOffset(second_rec_ptr, double_field)},
    {"char field", "char",
       sizeof(char), IOOffset(second_rec_ptr, char_field)},
    { NULL, NULL, 0, 0}
};

IOField field_list3[] = {
    {"integer field", "integer", 
       sizeof(int), IOOffset(third_rec_ptr, integer_field)},
    {"long field", "integer", 
       sizeof(long), IOOffset(third_rec_ptr, long_field)},
    {"uint field", "unsigned integer", 
       sizeof(int), IOOffset(third_rec_ptr, uint_field)},
    {"ulong field", "unsigned integer", 
       sizeof(long), IOOffset(third_rec_ptr, ulong_field)},
    {"string field", "string",
       sizeof(char *), IOOffset(third_rec_ptr, string)},
    {"double field", "float",
       sizeof(double), IOOffset(third_rec_ptr, double_field)},
    {"string field2", "string",
       sizeof(char *), IOOffset(third_rec_ptr, string2)},
    {"char field", "char",
       sizeof(char), IOOffset(third_rec_ptr, char_field)},
    {"enum field", "enumeration",
       sizeof(enum_type), IOOffset(third_rec_ptr, enum_field)},
    { NULL, NULL, 0, 0}
};

IOField field_list4[] = {
    {"ifield", "integer", 
       sizeof(long), IOOffset(fourth_rec_ptr, ifield)},
    {"int_array", IOArrayDecl(integer,ARRAY_SIZE), 
       sizeof(int), IOOffset(fourth_rec_ptr, int_array[0])},
    {"double field", "float[2][2]",
       sizeof(double), IOOffset(fourth_rec_ptr, double_array[0][0])},
    { NULL, NULL, 0, 0}
};

IOField embedded_field_list[] = {
    {"ifield", "integer",
       sizeof(short), IOOffset(embedded_rec_ptr, ifield)},
    {"string field", "string",
       sizeof(char *), IOOffset(embedded_rec_ptr, string)},
    {"dfield", "float",
       sizeof(double), IOOffset(embedded_rec_ptr, dfield)},
    {NULL, NULL, 0, 0}
};

IOField field_list5[] = {
    {"earray", "embedded[4]",
       sizeof(embedded_rec), IOOffset(fifth_rec_ptr, earray)},
    {NULL, NULL, 0, 0}
};

IOField later_field_list[] = {
    {"integer field", "integer", 
       sizeof(((later_rec_ptr)0)->integer_field), IOOffset(later_rec_ptr, integer_field)},
    {"string field", "string",
       sizeof(char *), IOOffset(later_rec_ptr, string)},
    {"double field", "float",
       sizeof(double), IOOffset(later_rec_ptr, double_field)},
    { NULL, NULL, 0, 0}
};

IOField later_field_list2[] = {
    {"integer field", "integer", 
       sizeof(((later_rec2_ptr)0)->integer_field), 
       IOOffset(later_rec2_ptr, integer_field)},
    {"string field", "string",
       sizeof(char *), IOOffset(later_rec2_ptr, string)},
    {"double field", "float",
       sizeof(double), IOOffset(later_rec2_ptr, double_field)},
    { NULL, NULL, 0, 0}
};

IOField nested_field_list[] = {
    {"integer field", "integer", 
       sizeof(((nested_rec_ptr)0)->integer_field), 
       IOOffset(nested_rec_ptr, integer_field)},
    {"nested record", "string format",
       sizeof(second_rec), IOOffset(nested_rec_ptr, nested_rec)},
    {"string field", "string",
       sizeof(char *), IOOffset(nested_rec_ptr, string)},
    { NULL, NULL, 0, 0}
};

IOField field_list6[] = {
    {"string field", "string",
       sizeof(char *), IOOffset(sixth_rec_ptr, string)},
    {"icount", "integer", 
       sizeof(long), IOOffset(sixth_rec_ptr, icount)},
    {"var_int_array", "integer[icount]",
       sizeof(((sixth_rec_ptr)0)->var_int_array[0]), IOOffset(sixth_rec_ptr, var_int_array)},
    {"var_string_array", "string format[icount]",
       sizeof(second_rec), IOOffset(sixth_rec_ptr, var_string_array)},
    {"double field", "float",
       sizeof(double), IOOffset(sixth_rec_ptr, dfield)},
    {"var_double_array", "float[icount]",
       sizeof(double), IOOffset(sixth_rec_ptr, var_double_array)},
    { NULL, NULL, 0, 0}
};

IOField event_vec_elem_fields[] =
{
    {"len", "integer", sizeof(((IOEncodeVector)0)[0].iov_len), 
     IOOffset(IOEncodeVector, iov_len)},
    {"elem", "char[len]", sizeof(char), IOOffset(IOEncodeVector,iov_base)},
    {(char *) 0, (char *) 0, 0, 0}
};

IOField field_list9[] =
{
    {"vec_length", "integer", sizeof(int),
     IOOffset(ninth_rec_ptr, vec_length)},
    {"eventv", "EventVecElem[vec_length]", sizeof(struct _io_encode_vec), 
     IOOffset(ninth_rec_ptr, eventv)},
    {(char *) 0, (char *) 0, 0, 0}
};

IOField string_array_field_list[] =
{
    {"array_len", "integer", sizeof(int),
     IOOffset(string_array_rec_ptr, array_len)},
    {"base_string", "string", sizeof(char*),
     IOOffset(string_array_rec_ptr, base_string)},
    {"array", "string[array_len]", sizeof(char*), 
     IOOffset(string_array_rec_ptr, array)},
    {(char *) 0, (char *) 0, 0, 0}
};
