#include "config.h"
#include <fcntl.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdlib.h>
#include <time.h>
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef HAVE_SOCKLIB_H
#include "sockLib.h"
#include "hostLib.h"
#endif
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#ifndef HAVE_WINSOCK_H
#ifdef HAVE_SYS_UN_H
#include <sys/un.h>
#endif
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif
#else
#include <winsock.h>
#endif
#ifdef HAVE_SYS_UIO_H
#include <sys/uio.h>
#endif
#include "assert.h"
#include "io.h"
#include "io_interface.h"
#include "io_internal.h"
#include "unix_defs.h"

#if !defined(SOCKET_DEFINED) && !defined(HAVE_WINDOWS_H)
extern int socket ARGS((int domain, int type, int protocol));
#endif
#if !defined(CONNECT_DEFINED) && !defined(HAVE_WINDOWS_H)
extern int connect ARGS((int s, struct sockaddr *name, int namelen));
#endif
#if !defined(GETHOSTNAME_DEFINED) && !defined(HAVE_WINDOWS_H)
extern int gethostname ARGS((char *name, int namelen));
#endif
#if !defined(SETSOCKOPT_DEFINED) && !defined(HAVE_WINDOWS_H)
extern int setsockopt ARGS((int s, int level, int optname, const char *optval, int optlen));
#endif
#ifndef PUTENV_DEFINED
extern int putenv ARGS((char *string));
#endif

static char test_byte = 'T';

static int
fill_hostaddr(void *addr, char *hostname)
{
#ifdef HAS_STRUCT_HOSTENT
    struct hostent *host_addr;
    
    host_addr = gethostbyname(hostname);
    if (host_addr == NULL) {
	unsigned long addr = inet_addr(hostname);
	if (addr == -1) {
	    /* 
	     *  not translatable as a hostname or 
	     * as a dot-style string IP address
	     */
	    return 0;
	}
	assert(sizeof(int) == sizeof(struct in_addr));
	*((int*)addr) = (int)addr;
    } else {
	memcpy(addr, host_addr->h_addr, host_addr->h_length);
    }
    return 1;
#else
    /* VxWorks ? */
    *((int *)addr) = hostGetByName(hostname);
    return 1;
#endif
}

static int format_server_verbose = -1;

extern int
establish_server_connection(iofile, do_fallback)
IOFile iofile;
int do_fallback;
{
    int sock;
    int junk_errno;
    char *junk_str;
    int delay_value = 1;
	
    if (os_sockets_init_func) {
	 os_sockets_init_func();
    }
    if ((iofile->server_fd == (void*)-1) || 
	(os_server_write_func(iofile->server_fd, &test_byte, 1, &junk_errno,
			      &junk_str) != 1)) {
	/* reestablish connection, name_str is the machine name */
	struct sockaddr_in sock_addr;
	char *format_server_host = getenv("FORMAT_SERVER_HOST");

	if (format_server_verbose == -1) {
	    if (getenv("FORMAT_SERVER_VERBOSE") == NULL) {
		format_server_verbose = 0;
	    } else {
		format_server_verbose = 1;
	    }
	}
	if (format_server_host == NULL) {
	    format_server_host = FORMAT_SERVER_HOST;	/* from configure */
	}
	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	    fprintf(stderr, "Failed to create socket for PBIO format server connection.  Not enough File Descriptors?\n");
	    return 0;
	}
	
	sock_addr.sin_family = AF_INET;
		
	if (fill_hostaddr(&sock_addr.sin_addr, format_server_host) == 0) {
	    fprintf(stderr, "Unknown Host \"%s\" specified as PBIO format server.\n",
		    format_server_host);
	    return 0;
	}
	sock_addr.sin_port = htons(FS_PORT);

	if (format_server_verbose) {
	    printf("Trying connection to format server on %s ...  ",
		   format_server_host);
	}
	if (connect(sock, (struct sockaddr *) &sock_addr,
		    sizeof sock_addr) < 0) {

	    if (format_server_verbose) {
		printf("failed\n");
	    }
	    if (!do_fallback) return 0;

	    /* fallback */
	    if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		fprintf(stderr, "Failed to create socket for PBIO format server connection.  Not enough File Descriptors?\n");
	       return 0;
	    }
	    format_server_host = "marquesas.cc.gatech.edu";
	    sock_addr.sin_family = AF_INET;
	    if (fill_hostaddr(&sock_addr.sin_addr, format_server_host) == 0){
		fprintf(stderr, "Unknown Host \"%s\" specified as PBIO format server.\n",
			format_server_host);
		return 0;
	    }
	    sock_addr.sin_port = htons(FS_PORT);
	    if (format_server_verbose) {
		printf("Trying fallback connection to format server on %s ...  ",
		       format_server_host);
	    }
	    if (connect(sock, (struct sockaddr *) &sock_addr,
			sizeof sock_addr) < 0) {
		fprintf(stderr, "Failed to connect to primary or fallback format servers.\n");
	        return 0;
	    }
	}
	if (format_server_verbose) {
	    printf("succeeded\n");
	}
	setsockopt(sock, IPPROTO_TCP, TCP_NODELAY, (char *) &delay_value,
		   sizeof(delay_value));
	iofile->server_fd = (void*)sock;
	server_write_header(iofile);
	/* 
	 * ignore SIGPIPE's  (these pop up when ports die.  we catch the 
	 * failed writes) 
	 */
#ifdef SIGPIPE
	signal(SIGPIPE, SIG_IGN);
#endif

    }
    return 1;
}
	
extern int (*establish_server_connection_ptr)ARGS((IOFile iofile, int do_fallback));
extern int pbio_fixed_format_ids;
extern INT4 PBIO_self_server_IP_addr;  /* declared in io_formats.c */

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

extern
 IOContext
create_server_IOcontext(format_rep_callback, get_port_callback, client_data)
PBIOGetFormatRepCallback format_rep_callback;
PBIOGetPortCallback get_port_callback;
void *client_data;
{
    IOFile iofile;

    struct hostent *host;
    char buf[MAXHOSTNAMELEN];
    gethostname(buf, MAXHOSTNAMELEN);
    host = gethostbyname(buf);
    PBIO_self_server_IP_addr = htonl(*((int *) host->h_addr_list[0]));

    iofile = new_IOFile();
    iofile->status = OpenNoHeader;
    iofile->IOversion = CURRENT_IO_VERSION;
    iofile->is_context = TRUE;
    reset_read_ahead(iofile);
    iofile->server_callback = format_rep_callback;
    iofile->server_get_port_callback = get_port_callback;
    iofile->server_client_data = client_data;
    return (IOContext) iofile;
}

extern
IOContext
create_IOcontext()
{
    IOFile iofile;

    if (establish_server_connection_ptr == NULL) {
	/* fill in function pointer used in io_formats.c */
	char *addr_str;
	char var_str[60];

	establish_server_connection_ptr = establish_server_connection;
	sprintf(var_str, "Server_conn_func_addr_%lx", (long) getpid());
	if ((addr_str = getenv(var_str)) == NULL) {
	    char addr_tmp[64];
	    sprintf(addr_tmp, "%s=%lx", var_str, 
		    (long)establish_server_connection);
	    addr_str = io_strdup(addr_tmp);
	    putenv(addr_str);
	}
    }
    if (pbio_fixed_format_ids == -1) {
	pbio_fixed_format_ids = 0;
	if (getenv("PBIO_FIXED_FORMAT_IDS") != NULL) {
	    pbio_fixed_format_ids = 1;
	} else if (getenv("PBIO_BIG_FORMAT_IDS") != NULL) {
	    pbio_fixed_format_ids = 0;
	}
    }
    iofile = new_IOFile();
    iofile->status = OpenNoHeader;
    iofile->IOversion = CURRENT_IO_VERSION;
    iofile->is_context = TRUE;
    reset_read_ahead(iofile);
    return (IOContext) iofile;
}

extern
IOContext
create_IOsubcontext(context)
IOContext context;
{
    IOFile iofile;

    /* fill in function pointer used in io_formats.c */
    establish_server_connection_ptr = establish_server_connection;

    iofile = new_IOFile();
    iofile->status = OpenNoHeader;
    iofile->IOversion = CURRENT_IO_VERSION;
    iofile->is_context = TRUE;
    iofile->master_context = context;
    reset_read_ahead(iofile);
    return (IOContext) iofile;
}
