
#include "config.h"
#include <fcntl.h>
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <string.h>
#include "io.h"
#include "unix_defs.h"

#include "test_funcs.h"

int
main()
{
    IOFile iofile = open_IOfile("test_output", "w");
    IOFormat first_rec_ioformat, second_rec_ioformat, third_rec_ioformat;
    IOFormat fourth_rec_ioformat, later_ioformat, nested_ioformat;
    IOFormat embedded_rec_ioformat, fifth_rec_ioformat, sixth_rec_ioformat;
    IOFormat ninth_rec_ioformat;
    IOFormat string_array_ioformat;
    struct _pbiovec vector[5];
    first_rec rec1;
    second_rec rec2;
    third_rec rec3;
    fourth_rec rec4;
    later_rec rec5;
    later_rec2 rec6;
    nested_rec rec7;
    fifth_rec emb_array;
    sixth_rec var_array;
    ninth_rec var_var;
    string_array_rec str_array;
    int i, j;

    first_rec array1[10];
    first_rec_ioformat = register_IOrecord_format("first format",
						  field_list,
						  iofile);
    second_rec_ioformat = register_IOrecord_format("string format",
						   field_list2,
						   iofile);
    third_rec_ioformat = register_IOrecord_format("two string format",
						  field_list3,
						  iofile);
    fourth_rec_ioformat = register_IOrecord_format("internal array format",
						   field_list4,
						   iofile);
    embedded_rec_ioformat = register_IOrecord_format("embedded",
						     embedded_field_list,
						     iofile);
    (void)embedded_rec_ioformat;
    fifth_rec_ioformat = register_IOrecord_format("structured array format",
						  field_list5,
						  iofile);
    sixth_rec_ioformat = register_IOrecord_format("variant array format",
						  field_list6,
						  iofile);
    write_comment_IOfile(iofile, "this is a comment in the file");
    memset((char *) &rec1, 0, sizeof(rec1));
    rec1.integer_field = 14;
    rec1.double_field = 2.717;
    rec1.char_field = 'A';
    if (!write_IOfile(iofile, first_rec_ioformat, &rec1))
	IOperror(iofile, "write failed\n");
    memset((char *) &emb_array, 0, sizeof(emb_array));
    memset((char *) &var_array, 0, sizeof(var_array));
    emb_array.earray[0].dfield = 4.0;
    emb_array.earray[0].ifield = 4;
    emb_array.earray[0].string = (char *) malloc(10);
    sprintf(emb_array.earray[0].string, "string%d", emb_array.earray[0].ifield * 5);
    emb_array.earray[1].dfield = 3.0;
    emb_array.earray[1].ifield = 3;
    emb_array.earray[1].string = (char *) malloc(10);
    sprintf(emb_array.earray[1].string, "string%d", emb_array.earray[1].ifield * 5);
    emb_array.earray[2].dfield = 2.0;
    emb_array.earray[2].ifield = 2;
    emb_array.earray[2].string = (char *) malloc(10);
    sprintf(emb_array.earray[2].string, "string%d", emb_array.earray[2].ifield * 5);
    emb_array.earray[3].dfield = 1.0;
    emb_array.earray[3].ifield = 1;
    emb_array.earray[3].string = (char *) malloc(10);
    sprintf(emb_array.earray[3].string, "string%d", emb_array.earray[3].ifield * 5);
    if (!write_IOfile(iofile, fifth_rec_ioformat, &emb_array))
	IOperror(iofile, "write failed\n");
    memset((char *) &rec2, 0, sizeof(rec2));
    rec2.integer_field = 14;
    rec2.short_field = 27;
    rec2.long_field = 987234;
    rec2.string = "testing";
    rec2.double_field = 2.717;
    rec2.char_field = 'A';
    if (!write_IOfile(iofile, second_rec_ioformat, &rec2))
	IOperror(iofile, "write failed\n");
    rec2.integer_field = 14;
    rec2.short_field = 27;
    rec2.long_field = 987234;
    rec2.string = NULL;
    rec2.double_field = 2.717;
    rec2.char_field = 'A';
    if (!write_IOfile(iofile, second_rec_ioformat, &rec2))
	IOperror(iofile, "write failed\n");
    rec1.integer_field = 17;
    rec1.double_field *= 3.0;
    rec1.char_field = 'B';
    write_IOfile(iofile, first_rec_ioformat, &rec1);
    rec2.integer_field = 14;
    rec2.short_field = 27;
    rec2.long_field = 987234;
    rec2.string = NULL;
    rec2.double_field = 2.717;
    rec2.char_field = 'A';
    if (!write_IOfile(iofile, second_rec_ioformat, &rec2))
	IOperror(iofile, "write failed\n");
    rec1.integer_field *= 2;
    rec1.double_field *= 2.717;
    rec1.char_field = 'C';
    write_comment_IOfile(iofile, "this is another comment in the file");
    write_IOfile(iofile, first_rec_ioformat, &rec1);
    memset((char *) &rec3, 0, sizeof(rec3));
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.uint_field = 0xf7e589ce;	/* = 4159015374 */
#if SIZEOF_LONG==64
    rec3.ulong_field = 0xf7e589ceec9dd130;
#else
    rec3.ulong_field = 0xec9dd130;	/* = 3969765680 */
#endif
    rec3.string = "testing";
    rec3.double_field = 2.717;
    rec3.string2 = "jambalaya";
    rec3.char_field = 'A';
    rec3.enum_field = Red_Stripe;
    if (!write_IOfile(iofile, third_rec_ioformat, &rec3))
	IOperror(iofile, "write failed\n");
    later_ioformat = register_IOrecord_format("later format",
					      later_field_list,
					      iofile);
    nested_ioformat = register_IOrecord_format("nested format",
					       nested_field_list,
					       iofile);
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.string = NULL;
    rec3.double_field = 2.717;
    rec3.string2 = "jambalaya";
    rec3.char_field = 'A';
    rec3.enum_field = Paulaner;
    if (!write_IOfile(iofile, third_rec_ioformat, &rec3))
	IOperror(iofile, "write failed\n");
    memset((char *) &rec7, 0, sizeof(rec7));
    rec7.integer_field = 47;
    rec7.nested_rec.integer_field = 14;
    rec7.nested_rec.short_field = 27;
    rec7.nested_rec.long_field = 987234;
    rec7.nested_rec.string = "Another string";
    rec7.nested_rec.double_field = 2.717;
    rec7.nested_rec.char_field = 'A';
    rec7.string = "Yet another string";
    if (!write_IOfile(iofile, nested_ioformat, &rec7))
	IOperror(iofile, "write failed\n");
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.string = "testing";
    rec3.double_field = 2.717;
    rec3.string2 = NULL;
    rec3.char_field = 'A';
    rec3.enum_field = Pilsner;
    if (!write_IOfile(iofile, third_rec_ioformat, &rec3))
	IOperror(iofile, "write failed\n");
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.string = NULL;
    rec3.double_field = 2.717;
    rec3.string2 = NULL;
    rec3.char_field = 'A';
    rec3.enum_field = Red_Stripe;
    if (!write_IOfile(iofile, third_rec_ioformat, &rec3))
	IOperror(iofile, "write failed\n");
    memset((char *) &rec5, 0, sizeof(rec5));
    rec5.integer_field = 9872346;
    rec5.string = "ABCD";
    rec5.double_field = 3.14159265358797323;
    vector[0].data = &rec5;
    vector[0].format = later_ioformat;

    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.string = "testing";
    rec3.double_field = 2.717;
    rec3.string2 = "jambalaya";
    rec3.char_field = 'A';
    rec3.enum_field = Pilsner;
    vector[1].data = &rec3;
    vector[1].format = third_rec_ioformat;

    rec2.integer_field = 14;
    rec2.short_field = 27;
    rec2.long_field = 987234;
    rec2.string = "the end";
    rec2.double_field = 2.717;
    rec2.char_field = 'A';
    vector[2].data = &rec2;
    vector[2].format = second_rec_ioformat;
    if (!writev_IOfile(iofile, &(vector[0]), 3))
	IOperror(iofile, "writev failed\n");
    for (i = 0; i < 10; i++) {
	memset((char *) &array1[i], 0, sizeof(array1[i]));
	array1[i].integer_field = 2 * i * i;
	array1[i].double_field = 2.717 * (i * i);
	array1[i].char_field = 'D' + i;
    }
    later_ioformat = register_IOrecord_format("later format",
					      later_field_list2,
					      iofile);
    if (!write_array_IOfile(iofile, first_rec_ioformat, &array1[0],
			    10, sizeof(array1[0])))
	IOperror(iofile, "write failed\n");

    memset((char *) &rec4, 0, sizeof(rec4));
    for (i = 0; i < ARRAY_SIZE; i++) {
	rec4.int_array[i] = 297 + i;
    }
    rec4.double_array[0][0] = 1.0;
    rec4.double_array[0][1] = 2.0;
    rec4.double_array[1][0] = 3.0;
    rec4.double_array[1][1] = 4.0;
    rec4.ifield = -rec4.int_array[ARRAY_SIZE - 1];
    vector[0].data = &rec4;
    vector[0].format = fourth_rec_ioformat;

    memset((char *) &rec6, 0, sizeof(rec6));
    rec6.integer_field = 23462346;
    rec6.string = "Efghij";
    rec6.double_field = 3.14159265358797323 * 2.0;
    vector[1].data = &rec6;
    vector[1].format = later_ioformat;
    if (!writev_IOfile(iofile, &(vector[0]), 2))
	IOperror(iofile, "writev failed\n");
    rec6.integer_field = 2346987;
    rec6.string = "Klmn";
    rec6.double_field = 3.14159265358797323 * 3.0;
    
    if (!write_IOfile(iofile, later_ioformat, &rec6))
	IOperror(iofile, "write failed\n");

    for (i = 1; i < 20; i += 5) {
        memset((char *) &var_array, 0, sizeof(var_array));
	var_array.string = malloc(10);
	sprintf(var_array.string, "variant%d", i);
	var_array.icount = 2 * i;
	var_array.var_int_array = malloc(sizeof(((sixth_rec_ptr) 0)->var_int_array[0]) * var_array.icount);
	var_array.var_double_array = malloc(sizeof(double) * var_array.icount);
	var_array.var_string_array = malloc(sizeof(second_rec) * var_array.icount);
        memset((char *) var_array.var_string_array, 0, 
	       sizeof(second_rec) * var_array.icount);
	for (j = 0; j < var_array.icount; j++) {
	    var_array.var_int_array[j] = 297 + j;
	    var_array.var_double_array[j] = 2.717 * j;
	    var_array.var_string_array[j].integer_field = 345 * j;
	    var_array.var_string_array[j].short_field = j;
	    var_array.var_string_array[j].long_field = 785 * j;
	    var_array.var_string_array[j].string = malloc(15);
	    sprintf(var_array.var_string_array[j].string,
		    "substring%d", j);
	    var_array.var_string_array[j].double_field = 3.1415 * j;
	    var_array.var_string_array[j].char_field = 'a' + 2 * j;
	}
	if (!write_IOfile(iofile, sixth_rec_ioformat, &var_array))
	    IOperror(iofile, "write failed");
	for (j = 0; j < var_array.icount; j++) {
	    free(var_array.var_string_array[j].string);
	}
	free(var_array.var_string_array);
	free(var_array.string);
	free(var_array.var_int_array);
	free(var_array.var_double_array);
    }

    register_IOrecord_format("EventVecElem", event_vec_elem_fields,
			     iofile);

    ninth_rec_ioformat = register_IOrecord_format("EventV",
						  field_list9,
						  iofile);
    string_array_ioformat = register_IOrecord_format("string_array",
						     string_array_field_list,
						     iofile);
    for (i = 1; i < 10; i += 2) {
        memset((char *) &var_var, 0, sizeof(var_var));
	memset((char *) &str_array, 0, sizeof(str_array));
	var_var.vec_length = i;
	var_var.eventv = malloc(sizeof(((ninth_rec_ptr) 0)->eventv[0]) * var_var.vec_length);

	str_array.array_len = i;
	str_array.array = malloc(sizeof(char*) * i);

	for (j = 0; j < var_var.vec_length; j++) {
	    int k;
	    var_var.eventv[j].iov_len = j + i;
	    var_var.eventv[j].iov_base = malloc(j + i);
	    str_array.array[j] = malloc(i + j + 2);
	    for (k=0; k<j+i; k++) {
		((char*)var_var.eventv[j].iov_base)[k] = 'A' + k + i/5;
		str_array.array[j][k] = 'a' + k + i;
	    }
	    str_array.array[j][k] = 0;
	}
	if ((i % 4) == 1) {
	    str_array.base_string = NULL;
	} else {
	    str_array.base_string = strdup("Whoa there!");
	}
	if (!write_IOfile(iofile, ninth_rec_ioformat, &var_var))
	    IOperror(iofile, "write failed");
	if (!write_IOfile(iofile, string_array_ioformat, &str_array))
	    IOperror(iofile, "write failed");
	for (j = 0; j < var_var.vec_length; j++) {
	    free(var_var.eventv[j].iov_base);
	}
    }

    close_IOfile(iofile);
    free_IOfile(iofile);
    return 0;
}
