
#define MAGIC_NUMBER 0x4356ffa9	/* random magic */
#define REVERSE_MAGIC_NUMBER 0xa9ff5643		/* byte reversed random
						 * magic */
#define MAGIC_FLOAT 0.0078125	/* random float */
#define CURRENT_IO_VERSION 5
#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif

#define FS_PORT 5347

extern char *architecture;

typedef enum {
    unknown_type, integer_type, unsigned_type, float_type,
    char_type, string_type, enumeration_type, boolean_type
} IOdata_type;

typedef enum {
    Format_Unknown= 10, Format_IEEE= 0  /* more later? */
} IOfloat_formats;


typedef struct IOtmp_buffer {
    void *tmp_buffer;
    int tmp_buffer_size;
    int tmp_buffer_in_use_size;
} IOtmp_buffer;

struct _format_wire_format_0;
typedef struct _format_wire_format_0 *format_rep;

typedef struct _IOFileStruct {
    void *file_id;
    int IOversion;
    IOStatus status;
    char *architecture;
    int reg_format_count;
    int byte_reversal;
    int pointer_size;
    int errno_val;
    char *result;

    IOinterface_func write_func;
    IOinterface_func read_func;
    int max_iov;
    void *iov;
    IOinterface_funcv writev_func;
    IOinterface_funcv readv_func;
    IOinterface_close close_func;
    IOinterface_poll  poll_func;

/* used for contexts but not true IOFile's */
    int is_context;
    IOContext master_context;
    PBIOGetFormatRepCallback server_callback;
    PBIOGetPortCallback server_get_port_callback;
    void *server_client_data;
    void *server_fd;
    int server_pid;
    int server_byte_reversal;

    int read_ahead;
    IORecordType next_record_type;
    IOFormat next_record_format;
    int next_record_len;
    int remaining_count;
    IOtmp_buffer tmp;
    int format_list_size;
    IOFormat *format_list;
} IOFileStruct;

typedef struct _IOVarInfoStruct {
    int string;
    int var_array;
    int byte_vector;
    IOdata_type data_type;
    int dimen1, dimen2;
    IOFieldPtr control_field;
} IOVarInfoStruct, *IOVarInfoList;

typedef struct _server_ID_struct {
    int length;
    char *value;
} server_ID_type;

typedef struct _IOFormatBody *IOFormatBodyPtr;

typedef struct _IOFormatStruct {
    IOFile iofile;
    int format_id;
    int native_format;
    IOFormat *field_subformats;
    IOConversionPtr conversion;
    int warned_about_null_conversion;
    IOFormatBodyPtr body;
} IOFormatStruct;

typedef struct _xml_output_info *xml_output_info;

typedef struct _IOFormatBody {
    int ref_count;
    char *format_name;
    server_ID_type server_ID;
    int record_length;
    int byte_reversal;
    int pointer_size;
    int IOversion;
    int field_count;
    int variant;
    IOFieldList field_list;
    IOVarInfoList var_list;
    IOOptInfo *opt_info;
    xml_output_info xml_out;
    format_rep server_format_rep;    
} IOFormatBody;

typedef struct _IOgetFieldStruct {
    int offset;
    int size;
    IOdata_type data_type;
    int byte_swap;
} IOgetFieldStruct;

typedef enum {
    none_required, direct_to_mem, buffer_and_convert, copy_strings
} IOconversion_type;

typedef struct _IOconvFieldStruct {
    IOgetFieldStruct src_field;
    int array_dimen1, array_dimen2;
    IOFieldPtr control_field;
    int dest_offset;
    int dest_size;
    IOConversionPtr subconversion;
} IOconvFieldStruct;

typedef void (*conv_routine) ARGS((void *src, void *dest, 
				   void *final_string_base, 
				   void *src_string_base));

typedef struct _IOConversionStruct {
    IOconversion_type conversion_type;
    int notify_of_format_change;
    IOFieldList native_field_list;
    int conv_count;
    int base_size_delta;	/* native size - file record length */
    double max_var_expansion;
    int target_pointer_size;
    IOFile iofile;
    IOFormat ioformat;
    conv_routine conv_func;
    conv_routine conv_func4;
    conv_routine conv_func2;
    conv_routine conv_func1;
    int required_alignment;
    int string_offset_size;
    int converted_strings;
    IOconvFieldStruct conversions[1];
} IOConversionStruct;

extern int IO_shut_up;

#if SIZEOF_INT == 4
#define FILE_INT int
#else
Whoops...  Unhandled.
#endif

extern void *io_malloc ARGS((int size));
extern void io_free ARGS((void *ptr));
extern void *io_realloc ARGS((void *ptr, int size));
extern char *io_strdup ARGS((const char *str));
extern IOdata_type str_to_data_type ARGS((const char *str));
extern IOdata_type array_str_to_data_type ARGS((const char *str, int *dimen1,
						int *dimen2));
extern const char *data_type_to_str ARGS((IOdata_type data_type));
extern int field_offset_compar ARGS((const void *a, const void *b));
extern int AtomicRead ARGS((void *fd, void *buffer, int length, IOFile iofile));
extern int AtomicWrite ARGS((void *fd, void *buffer, int length, IOFile iofile));
extern int get_AtomicInt ARGS((IOFile iofile, FILE_INT * buffer));
extern int put_AtomicInt ARGS((IOFile iofile, FILE_INT * buffer));

extern void IOconvert_record ARGS((IOConversionPtr conv, void *src,
				   void *dest, void *final_string_area,
				   void* src_string_area));
extern void reset_read_ahead ARGS((IOFile iofile));
extern void expand_IOFile ARGS((IOFile iofile));
extern int write_IOformat ARGS((IOFile iofile, IOFormat ioformat));
extern int sdump_value ARGS((char *str, const char*field_type, int field_size,
			     int field_offset, IOFile iofile, void *data,
			     void *string_base, int byte_reversal, 
			     int encode));
extern int count_IOfield ARGS((IOFieldList field_list));
extern char *get_IOstring_base ARGS((IOFieldPtr iofield, void *data, void *string_base));
extern void *get_IOaddr ARGS((IOFieldPtr iofield, void *data, void *string_base, int encode));
extern char *base_data_type ARGS((const char *data_type));
extern void dump_IOConversion ARGS((IOConversionPtr conv_ptr));
extern void dump_IOConversion_as_XML ARGS((IOConversionPtr conv_ptr));
extern int get_var_array_control ARGS((const char *str, IOFieldList fields));
extern int validate_data_type ARGS((const char *str));
extern int min_align_size ARGS((int size));
extern void generate_var_list ARGS((IOFormat ioformat));
extern conv_routine generate_conversion ARGS((IOConversionPtr conv, 
					      int base_alignment));
extern void pbio_internal_convert_field ARGS((IOFile iofile, 
					      IOFieldPtr src_spec, void *src,
					      IOdata_type dest_type, 
					      int dest_size, void *dest, 
					      int string_offset_size,
					      char *string_base, 
					      int size_delta,
					      int converted_strings));

extern void 
set_IOconversion_for_format ARGS((IOFile iofile, IOFormat file_ioformat,
				  IOFieldList native_field_list,
				  int native_struct_size));

#define Max(i,j) ((i<j) ? j : i)

/* negative IOformat numbers are reserved as escape codes! */
#define ARRAY_FOLLOWS -1
#define COMMENT_FOLLOWS	-2
#define FORMAT_FOLLOWS -3
#define REREGISTERED_FORMAT_FOLLOWS -4

#if SIZEOF_LONG_DOUBLE != 0 && SIZEOF_LONG_DOUBLE != SIZEOF_DOUBLE
#define MAX_FLOAT_TYPE long double
#else
#define MAX_FLOAT_TYPE double
#define MAX_FLOAT_GET get_IOdouble
#endif
#if SIZEOF_LONG_LONG != 0
#define MAX_INTEGER_TYPE long long
#else
#define MAX_INTEGER_TYPE long
#endif

#define MAX_UNSIGNED_TYPE unsigned MAX_INTEGER_TYPE

struct _format_server;

typedef struct _format_server *format_server;

typedef struct _FSclient {
    int port;			/* port's port number */
    char *hostname;		/* port's host name */
    char *usock_name;		/* port's unix socket name */
    void *fd;
    int byte_reversal;
    format_server fs;
    int provisional;
    int version;
} *FSClient;

typedef struct _internal_iovec {
    void *iov_base;
    int iov_offset;
    int iov_len;
} internal_iovec;

#if SIZEOF_INT == 4
#define INT4 int
#endif

#define INT2 short
#define UINT2 unsigned short

struct _field_wire_format {  /* 12 bytes total */
    UINT2 field_name_offset;
    UINT2 field_type_offset;
    INT4 field_size;
    INT4 field_offset;
};

struct _opt_info_wire_format {  /* 12 bytes total */
    INT4 info_type;
    INT4 info_len;
    INT4 info_offset;
};

struct _format_wire_format_0 {  /* 16 bytes for base */
/*byte 0*/    UINT2 format_rep_length;  /* transmitted in net byte order */
/*byte 2*/    unsigned char server_rep_version;
/*byte 3*/    unsigned char record_byte_order;
/*byte 4*/    unsigned char pointer_size;
/*byte 5*/    unsigned char header_size;
/*byte 6*/    UINT2 name_offset;	/* native host byte order */
/*byte 8*/    UINT2 field_count;
/*byte 10*/   UINT2 floating_point_rep;
/*byte 12*/   INT4 record_length;
};

struct _format_wire_format_1 {  /* 20 bytes for base */
/*byte 0*/    UINT2 format_rep_length;  /* transmitted in net byte order */
/*byte 2*/    unsigned char server_rep_version;
/*byte 3*/    unsigned char record_byte_order;
/*byte 4*/    unsigned char pointer_size;
/*byte 5*/    unsigned char header_size;
/*byte 6*/    UINT2 name_offset;	/* native host byte order */
/*byte 8*/    UINT2 field_count;
/*byte 10*/   UINT2 floating_point_rep;
/*byte 12*/   INT4 record_length;
/*byte 16*/   UINT2 opt_info_offset;
/*byte 18*/   unsigned char column_major_arrays;  /* false for C, true for Fortran */
/*byte 19*/   unsigned char unused_in_format_1;
};

struct _format_wire_format {
    union {
	struct _format_wire_format_0 f0;
	struct _format_wire_format_1 f1;
    }f;
};

typedef struct {
    unsigned char version;
    unsigned char salt;
    unsigned INT2 port;
    unsigned INT4 IP_addr;
    unsigned INT2 format_identifier;
} version_1_format_ID;

extern int pbio_fixed_format_ids;

extern int AtomicWriteV ARGS((IOFile iofile, internal_iovec *int_iov,
			      int iovcnt));

extern IOinterface_func os_file_read_func;
extern IOinterface_func os_file_write_func;
extern IOinterface_funcv os_file_readv_func;
extern IOinterface_funcv os_file_writev_func;

extern IOinterface_func os_read_func;
extern IOinterface_func os_write_func;
extern IOinterface_funcv os_readv_func;
extern IOinterface_funcv os_writev_func;
extern int os_max_iov;
extern IOinterface_close os_close_func;
extern IOinterface_poll os_poll_func;
extern IOinterface_open os_file_open_func;
extern IOinterface_func os_server_read_func;
extern IOinterface_func os_server_write_func;
extern IOinterface_init os_sockets_init_func;

extern IOFile new_IOFile ARGS((void));
extern IOFormat server_read_format();
extern IOFormat expand_ioformat_from_rep();
extern void server_write_header ARGS((IOFile iofile));
extern int write_format_to_fd ARGS((void *fd, IOFormat ioformat));
extern void free_IOformat ARGS((IOFormat format));
extern void IOfree_conversion ARGS((IOConversionPtr conv));
extern void server_get_server_ID ARGS((void *fd, void *server_ID));
extern void server_read_header ARGS((FSClient fsc));
extern void server_write_char ARGS((FSClient fsc, char *chr));
extern int establish_server_connection ARGS((IOFile iofile, int do_fallback));
extern int serverAtomicRead ARGS((void* fd, void *buffer, int length));
extern void print_format_ID ARGS((IOFormat ioformat));
extern IOFormat new_IOFormat();
extern int version_of_format_ID ARGS((void *server_ID));
extern void print_server_ID ARGS((unsigned char *ID));
extern int IOhas_XML_info ARGS((IOFormat ioformat));
extern void free_XML_output_info ARGS((xml_output_info info));
extern void dump_XML_record ARGS((IOFormat ioformat, void *data, int encoded));
extern int header_size_IOformat ARGS((IOFormat ioformat));
