typedef struct {
     int address;  /* if TRUE, reg contains the *address* of the data */
     IOdata_type data_type;
     int size;
     int offset;
     int aligned;
     int byte_swap;
     dr_reg_t vc_reg;
     dr_reg_t vc_reg2; /* used for paired regs to support non-native data types */
} iogen_oprnd, *iogen_oprnd_ptr;

iogen_oprnd
gen_fetch ARGS((drisc_ctx c, dr_reg_t src_reg, int offset, int size,
		IOdata_type data_type, int aligned, int byte_swap));

iogen_oprnd
gen_operand ARGS((dr_reg_t src_reg, int offset, int size,
		  IOdata_type data_type, int aligned, int byte_swap));

void
gen_load ARGS((drisc_ctx c, iogen_oprnd_ptr src_oprnd));

void
gen_byte_swap ARGS((drisc_ctx c, iogen_oprnd_ptr src_oprnd));

void
gen_store ARGS((drisc_ctx c, 
		iogen_oprnd src, dr_reg_t dest_reg, int offset, int size,
		IOdata_type data_type, int aligned));

void
gen_memcpy ARGS((drisc_ctx c, dr_reg_t src, int src_offset, dr_reg_t dest,
		 int dest_offset, dr_reg_t size));

void
free_oprnd ARGS((drisc_ctx c, iogen_oprnd oprnd));

iogen_oprnd
gen_type_conversion ARGS((drisc_ctx c, iogen_oprnd src_oprnd, IOdata_type data_type));

iogen_oprnd
gen_size_conversion ARGS((drisc_ctx c, iogen_oprnd src_oprnd, int size));

