#ifndef __I_O__
#define __I_O__

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus)
#ifndef ARGS
#define ARGS(args) args
#endif
#ifndef	NULL
/* 
 * NULL --
 *      Null pointer.
 */
#define NULL	((void *) 0)
#endif
#else
#ifndef ARGS
#define ARGS(args) (/*args*/)
#endif
#ifndef	NULL
/* 
 * NULL --
 *      Null pointer.
 */
#define NULL	0
#endif
#endif

#ifndef IOOffset
#define IOOffset(p_type,field) \
	((int) (((char *) (&(((p_type)NULL)->field))) - ((char *) NULL)))
#if defined(__STDC__) || defined(__ANSI_CPP__) || defined(_MSC_VER)
#define IOstr(s) #s
#else
#define IOstr(s) "s"
#endif
#define IOArrayDecl(type, size) IOstr(type[size])
#define IOArrayDecl2(type, size, size2) IOstr(type[size][size2])

typedef struct _IOField {
    const char *field_name;	/* Field name */
    const char *field_type;	/* Representation type desired */
    int field_size;		/* Size in bytes of representation */
    int field_offset;		/* Offset from base to put field value */
} IOField, *IOFieldList;
#endif

typedef struct _IOOptInfo {
    int info_type;
    int info_len;
    char *info_block;
} IOOptInfo;

typedef struct _IOConversionStruct *IOConversionPtr;

typedef struct _IOFormatStruct *IOFormat;

typedef enum {
    OpenNoHeader, OpenHeader, OpenForRead, OpenBeginRead, Closed
} IOStatus;

typedef enum {
    IOerror, IOend, IOdata, IOformat, IOcomment
} IORecordType;

typedef struct _IOFileStruct *IOFile;

typedef struct _IOContextStruct *IOContext;

typedef struct _IOgetFieldStruct *IOFieldPtr;

typedef struct IOtmp_buffer *IOBuffer;

typedef struct _pbiovec {
    void *data;
    IOFormat format;
} *pbiovec;

/* File operations */
extern IOFile
open_IOfile ARGS((const char *path, const char *flag_str));

extern IOFile
open_IOfd ARGS((int fd, const char *flags));

extern IOFile
open_version_IOfd ARGS((int fd, int version));

extern int
version_of_IOfile ARGS((IOFile iofile));

extern void
set_fd_IOfile ARGS((IOFile iofile, int fd));

extern void
close_IOfile ARGS((IOFile iofile));

extern int
poll_IOfile ARGS((IOFile iofile));

extern int
file_id_IOfile ARGS((IOFile iofile));

extern void
dump_IOFile ARGS((IOFile iofile));
extern void
dump_IOFile_as_XML ARGS((IOFile iofile));

extern void
free_IOfile ARGS((IOFile iofile));

extern IOContext
create_IOcontext();

typedef void *(*PBIOGetFormatRepCallback) ARGS((void *format_ID, 
						int format_ID_length, 
						int host_IP,
						int host_port,
						void *app_context,
						void *client_data));


typedef int (*PBIOGetPortCallback) ARGS((void *client_data));


extern IOContext
create_server_IOcontext ARGS((PBIOGetFormatRepCallback format_rep_callback, 
			      PBIOGetPortCallback get_port_callback, 
			      void *client_data));

extern void
free_IOcontext ARGS((IOContext context));

extern IOContext
create_IOsubcontext ARGS((IOContext master_context));

extern void
free_IOsubcontext ARGS((IOContext context));

extern char *
encode_IOcontext_buffer ARGS((IOContext iocontext, IOFormat ioformat,
			      void *data, int *buf_size));

extern char *
encode_IOcontext_bufferB ARGS((IOContext iocontext, IOFormat ioformat,
			       IOBuffer iobuffer, void *data, 
			       int *buf_size));

typedef struct _io_encode_vec {
     void *iov_base;
     long  iov_len;
} *IOEncodeVector;

extern IOEncodeVector
encode_IOcontext_to_vector ARGS((IOContext iocontext, IOFormat ioformat,
				 void *data));

extern IOEncodeVector
encode_IOcontext_release_vector ARGS((IOContext iocontext, IOFormat ioformat,
				      void *data));

extern IOBuffer create_IOBuffer();
extern void free_IOBuffer(IOBuffer buf);

extern IOEncodeVector
encode_IOcontext_vectorB ARGS((IOContext iocontext, IOBuffer tmp_buffer,
			       IOFormat ioformat, void *data));

extern int decode_in_place_possible ARGS((IOFormat));

extern int
decode_IOcontext ARGS((IOContext iocontext, char *src, void *data));

extern int
decode_to_buffer_IOcontext ARGS((IOContext iocontext, char *src, void *data));

extern int
decode_in_place_IOcontext ARGS((IOContext iocontext, char *src,
				void **dest_ptr));

/* format operations */
extern
IOFormat
register_IOrecord_format ARGS((const char *format_name,
			       IOFieldList field_list, IOFile iofile));

extern
IOFormat
register_opt_format ARGS((const char *format_name, IOFieldList field_list,
			  IOOptInfo *optinfo, IOContext iocontext));

extern void *
get_optinfo_IOFormat ARGS((IOFormat ioformat, int info_type, int *len_p));

extern
IOFormat
register_general_IOrecord_format ARGS((const char *format_name,
				       IOFieldList field_list, IOFile iofile,
				       int pointer_size, IOOptInfo *optinfo));

extern
IOFormat
register_IOcontext_format ARGS((const char *format_name, IOFieldList field_list, IOContext iocontext));

extern void
dump_IOFormat ARGS((IOFormat ioformat));
extern void
dump_IOFormat_as_XML ARGS((IOFormat ioformat));

extern IOFormat
read_format_IOfile ARGS((IOFile iofile));

IOFormat *
get_subformats_IOformat ARGS((IOFormat ioformat));

IOFormat *
get_subformats_IOcontext ARGS((IOContext iocontext, void *buffer));

char **
get_subformat_names ARGS((IOFieldList field_list));

extern IOFormat
get_format_IOcontext ARGS((IOContext iocontext, void *buffer));

extern IOFormat
get_format_app_IOcontext ARGS((IOContext iocontext, void *buffer, 
			       void *app_context));

extern char *
get_server_rep_IOformat ARGS((IOFormat ioformat, int *rep_length));

extern char *
get_server_ID_IOformat ARGS((IOFormat ioformat, int *id_length));

extern IOFormat
load_external_format_IOcontext ARGS((IOContext iocontext, char *server_id,
				     int id_size, char *server_rep));

extern void
add_opt_info_IOformat ARGS((IOFormat format, int typ, int len, void *block));

extern int
index_of_IOformat ARGS((IOFormat format));

extern IOFormat
next_IOrecord_format ARGS((IOFile iofile));

extern IOFormat
get_IOformat_by_name ARGS((IOFile iofile, const char *name));

extern IOFormat
get_IOformat_by_name_IOcontext ARGS((IOContext iocontext, const char *name));

extern IOFormat
get_local_format_IOcontext ARGS((IOContext iocontext, void *buffer));

extern char *
name_of_IOformat ARGS((IOFormat format));

extern char *
global_name_of_IOformat ARGS((IOFormat format));

extern int
global_name_eq ARGS((IOFormat format1, IOFormat format2));

extern int
pointer_size_of_IOformat ARGS((IOFormat format));

extern IOFile
iofile_of_IOformat ARGS((IOFormat format));

extern
void
set_IOconversion ARGS((IOFile iofile, const char *formatname, IOFieldList field_list,
		       int struct_size));

extern
void
set_conversion_IOcontext ARGS((IOContext iocontext, IOFormat ioformat, 
			       IOFieldList field_list, int struct_size));

extern
int
has_conversion_IOformat ARGS((IOFormat ioformat));

extern
void
set_general_IOconversion ARGS((IOFile iofile, const char *formatname, 
			       IOFieldList field_list, int struct_size,
			       int pointer_size));

extern
void
set_local_IOconversion ARGS((IOFile iofile, const char *formatname));

extern
IOConversionPtr
IOcreate_mem_conv ARGS((IOFieldList old_field_list,
			int old_struct_size, int old_pointer_size,
			IOFieldList new_field_list,
			int new_struct_size, int new_pointer_size));
extern
void
set_notify_of_format_change ARGS((IOFile iofile, const char *formatname, int value));

/* Field List operations */
extern
IOFieldList
field_list_of_IOformat ARGS((IOFormat format));

extern
int
compare_field_lists ARGS((IOFieldList list1, IOFieldList list2));

typedef enum {Format_Less, Format_Greater, Format_Equal, 
	      Format_Incompatible} IOformat_order;

IOformat_order IOformat_cmp ARGS((IOFormat format1, IOFormat format2));

extern
IOFieldList
copy_field_list ARGS((IOFieldList list));

extern
IOFieldList
get_local_field_list ARGS((IOFormat ioformat));

extern
IOFieldList
localize_field_list ARGS((IOFieldList list, IOContext c));

extern
void
free_field_list ARGS((IOFieldList list));

extern
IOFieldList
max_field_lists ARGS((IOFieldList list1, IOFieldList list2));

extern
void
force_align_field_list ARGS((IOFieldList field_list, int pointer_size));

extern
int
struct_size_IOfield ARGS((IOFile iofile, IOFieldList list));

extern
int
struct_size_field_list ARGS((IOFieldList list, int pointer_size));


/* Normal input and output operations */
extern
IORecordType
next_IOrecord_type ARGS((IOFile iofile));

extern int
write_IOfile ARGS((IOFile iofile, IOFormat ioformat, void *data));

extern int
writev_IOfile ARGS((IOFile iofile, pbiovec vec, int count));

extern int
read_IOfile ARGS((IOFile iofile, void *data));

extern int
read_to_buffer_IOfile ARGS((IOFile iofile, void *data, int buffer_len));

extern int
write_comment_IOfile ARGS((IOFile iofile, const char *comment));

extern
char *
read_comment_IOfile ARGS((IOFile iofile));

extern int
next_IOrecord_length ARGS((IOFile iofile));

extern int
this_IOrecord_length ARGS((IOContext context, char *src, int record_length));

/* array of record operations */
extern int
next_IOrecord_count ARGS((IOFile iofile));

extern int
read_array_IOfile ARGS((IOFile iofile, void *data, int count,
			int struct_size));

extern int
write_array_IOfile ARGS((IOFile iofile, IOFormat ioformat, void *data,
			 int count, int struct_size));

extern void
dump_unencoded_IOrecord ARGS((IOFile iofile, IOFormat ioformat, void *data));
extern int
dump_limited_unencoded_IOrecord ARGS((IOFile iofile, IOFormat ioformat,
				      void *data, int character_limit));
extern void
dump_unencoded_IOrecord_as_XML ARGS((IOFile iofile, IOFormat ioformat, void *data));

/* raw data handling operations */
extern void
dump_raw_IOrecord ARGS((IOFile iofile, IOFormat ioformat, void *data));
extern void
dump_raw_IOrecord_as_XML ARGS((IOFile iofile, IOFormat ioformat, void *data));

extern void
dump_encoded_as_XML ARGS((IOContext iocontext, void *data));

extern char*
IOencoded_to_XML_string ARGS((IOContext iocontext, void *data));

extern char*
IOunencoded_to_XML_string ARGS((IOContext iocontext, IOFormat ioformat, 
				void *data));

extern int
next_raw_IOrecord_length ARGS((IOFile iofile));

extern int
read_raw_IOfile ARGS((IOFile iofile, void *data, int buffer_max, IOFormat *ioformatptr));

extern int
read_raw_array_IOfile ARGS((IOFile iofile, IOFormat ioformat, void *data,
			    int count, int struct_size));

extern
IOFieldPtr
get_IOfieldPtrFromList ARGS((IOFieldList field_list, const char *field_name));

extern
IOFieldPtr
get_IOfieldPtr ARGS((IOFile iofile, const char *formatname, const char *fieldname));

extern
IOFieldPtr
get_local_IOfieldPtr ARGS((IOFile iofile, const char *formatname, const char *fieldname));

extern
int
IOhas_error ARGS((IOFile iofile));

extern
void
IOperror ARGS((IOFile iofile, char *str));

extern
void
IOprint_version();

extern float get_IOfloat ARGS((IOFieldPtr iofield, void *data));
extern double get_IOdouble ARGS((IOFieldPtr iofield, void *data));
extern short get_IOshort ARGS((IOFieldPtr iofield, void *data));
extern int get_IOint ARGS((IOFieldPtr iofield, void *data));
extern long get_IOlong ARGS((IOFieldPtr iofield, void *data));
extern void get_IOlong8 ARGS((IOFieldPtr iofield, void *data, unsigned long *low_long, long *high_long));
#if defined(SIZEOF_LONG_LONG)
#if SIZEOF_LONG_LONG != 0
extern long long get_IOlong_long ARGS((IOFieldPtr iofield, void *data));
extern unsigned long long get_IOulong_long ARGS((IOFieldPtr iofield, void *data));
#endif
#endif
#if defined(SIZEOF_LONG_DOUBLE)
#if SIZEOF_LONG_DOUBLE != 0
extern long double get_IOlong_double ARGS((IOFieldPtr iofield, void *data));
#endif
#endif
extern unsigned short get_IOushort ARGS((IOFieldPtr iofield, void *data));
extern unsigned int get_IOuint ARGS((IOFieldPtr iofield, void *data));
extern unsigned long get_IOulong ARGS((IOFieldPtr iofield, void *data));
extern int get_IOulong8 ARGS((IOFieldPtr iofield, void *data, unsigned long *low_long, unsigned long *high_long));
extern char *get_IOstring ARGS((IOFieldPtr iofield, void *data));
extern char get_IOchar ARGS((IOFieldPtr iofield, void *data));
extern int get_IOenum ARGS((IOFieldPtr iofield, void *data));

extern void put_IOdouble ARGS((IOFieldPtr iofield, double, void *data));
extern void put_IOshort ARGS((IOFieldPtr iofield, int, void *data));
extern void put_IOint ARGS((IOFieldPtr iofield, int, void *data));
extern void put_IOlong ARGS((IOFieldPtr iofield, long, void *data));
extern void put_IOlong8 ARGS((IOFieldPtr iofield, void *data, unsigned long low_long, long high_long));
extern void put_IOushort ARGS((IOFieldPtr iofield, unsigned int, void *data));
extern void put_IOuint ARGS((IOFieldPtr iofield, unsigned int, void *data));
extern void put_IOulong ARGS((IOFieldPtr iofield, unsigned long, void *data));
extern void put_IOstring ARGS((IOFieldPtr iofield, const char *, void *data));
extern void put_IOchar ARGS((IOFieldPtr iofield, int, void *data));
extern void put_IOenum ARGS((IOFieldPtr iofield, int, void *data));
extern int IO_field_type_eq ARGS((const char *str1, const char *str2));
#if defined(__cplusplus) || defined(c_plusplus)
}
#endif
#endif
