
#include <stdio.h>
#include <stdlib.h>

#include "config.h"
#include <string.h>
#include "io.h"
#include "unix_defs.h"
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#define sleep(x) Sleep(1000*x)
#else
extern int sleep();
#endif

#include "test_funcs.h"

int
main(argc, argv)
int argc;
char **argv;
{

    IOContext context = create_IOcontext(NULL);
    IOFormat first_rec_ioformat;
    int continuous_test = 0;
    int XML_test = 0;

    if (argc > 1) {
	if (strcmp(argv[1], "-c") == 0) {
	    continuous_test++;
	    printf("Doing continuous test\n");
	}
	if (strcmp(argv[1], "-x") == 0) {
	    XML_test++;
	    printf("Doing XML test\n");
	}
    }
    
    if (XML_test) {
	IOOptInfo opt_info[2];
	opt_info[0].info_type = 0x584D4C20;
	opt_info[0].info_len = 44;
	opt_info[0].info_block = "this is a bunch of text meant to be XML text";
	opt_info[1].info_type = 0;
	
	first_rec_ioformat = register_opt_format("first format", field_list,
						 opt_info, context);
	dump_IOFormat(first_rec_ioformat);
    } else if (!continuous_test) {
	first_rec_ioformat = register_IOcontext_format("first format",
						       field_list,
						       context);
	printf("format is %lx\n", (long)first_rec_ioformat);
    } else {
	while (1) {
	    IOContext context = create_IOcontext(NULL);


	    first_rec_ioformat = register_IOcontext_format("first format",
							   field_list,
							   context);
	    printf("first format is %lx\n", (long)first_rec_ioformat);
	    sleep(10);


	    first_rec_ioformat = register_IOcontext_format("string format",
							   field_list2,
							   context);
	    printf("second format is %lx\n", (long)first_rec_ioformat);
	    sleep(20);


	    first_rec_ioformat = register_IOcontext_format("two string format",
							   field_list3,
							   context);
	    printf("third format is %lx\n", (long)first_rec_ioformat);
	    sleep(30);


	    first_rec_ioformat = register_IOcontext_format("internal array format",
							   field_list4,
							   context);
	    printf("fourth format is %lx\n", (long)first_rec_ioformat);
	    sleep(40);

	    first_rec_ioformat = register_IOcontext_format("embedded",
							   embedded_field_list,
							   context);
	    printf("embedded format is %lx\n", (long)first_rec_ioformat);
	    sleep(50);


	    first_rec_ioformat = register_IOcontext_format("structured array format",
							   field_list5,
							   context);
	    printf("fifth format is %lx\n", (long)first_rec_ioformat);
	    sleep(60);


	    first_rec_ioformat = register_IOcontext_format("later format",
							   later_field_list,
							   context);
	    printf("later format is %lx\n", (long)first_rec_ioformat);
	    sleep(70);


	    first_rec_ioformat = register_IOcontext_format("later format",
							   later_field_list2,
							   context);
	    printf("later2 format is %lx\n", (long)first_rec_ioformat);
	    sleep(80);


	    first_rec_ioformat = register_IOcontext_format("nested format",
							   nested_field_list,
							   context);
	    printf("nested format is %lx\n", (long)first_rec_ioformat);
	    sleep(90);


	    first_rec_ioformat = register_IOcontext_format("variant array format",
							   field_list6,
							   context);
	    printf("sixth format is %lx\n", (long)first_rec_ioformat);
	    sleep(100);


	    first_rec_ioformat = register_IOcontext_format("EventVecElem",
							   event_vec_elem_fields,
							   context);
	    printf("eventvec format is %lx\n", (long)first_rec_ioformat);
	    sleep(110);


	    first_rec_ioformat = register_IOcontext_format("EventV",
							   field_list9,
							   context);
	    printf("ninth format is %lx\n", (long)first_rec_ioformat);
	    sleep(120);


	    first_rec_ioformat = register_IOcontext_format("string_array",
							   string_array_field_list,
							   context);
	    printf("string array format is %lx\n", (long)first_rec_ioformat);
	    sleep(130);

	    free_IOcontext(context);
	}
    }
    return 0;
}
