
#include <stdio.h>
#include <stdlib.h>

#include "config.h"
#include <string.h>
#include "io.h"
#include "unix_defs.h"
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#define sleep(x) Sleep(1000*x)
#else
#include <netinet/in.h>
extern int sleep();
#endif

#include "io_interface.h"
#include "io_internal.h"
extern int (*establish_server_connection_ptr)ARGS((IOFile iofile, int do_fallback));

static int
serverAtomicWrite(fd, buffer, length)
void* fd;
void *buffer;
int length;
{
     char *junk_result_str;
     int junk_errno;
     return os_server_write_func(fd, buffer, length, &junk_errno,
				&junk_result_str);
}

int
main(argc, argv)
int argc;
char **argv;
{

    IOContext context = create_IOcontext(NULL);
    IOFile iofile = (IOFile) context;
    int format_count, i;
    server_ID_type *format_list;
    char format_dump_char = 'D';

    if (establish_server_connection_ptr(iofile, 1) == 0) {
	printf("Failed to contact format server\n");
	return 0;
    }

    if (serverAtomicWrite(iofile->server_fd, &format_dump_char, 1) != 1) {
	fprintf(stderr, "dump write failed\n");
	exit(1);
    }
    if (serverAtomicRead(iofile->server_fd, &format_count, 4) != 4) {
	fprintf(stderr, "dump count read failed\n");
	exit(1);
    }
    format_count = ntohl(format_count);
    printf("There are %d formats registered\n", format_count);
    format_list = malloc(sizeof(format_list[0]) * format_count);
    for (i=0; i < format_count; i++) {
	if (serverAtomicRead(iofile->server_fd, &format_list[i].length, 
			     4) != 4) {
	    fprintf(stderr, "dump list read failed\n");
	    exit(1);
	}
	format_list[i].length = ntohl(format_list[i].length);
	format_list[i].value = malloc(format_list[i].length);
	if (serverAtomicRead(iofile->server_fd, format_list[i].value,
			     format_list[i].length)
			     != format_list[i].length) {
	    fprintf(stderr, "dump list read failed\n");
	    exit(1);
	}
    }
    for (i=0; i < format_count; i++) {
	IOFormat tmp_format =
	    get_format_IOcontext(context, format_list[i].value);
	printf("\n\nFormat %d (server size %d) is:\n", i,
	       tmp_format->body->server_format_rep->format_rep_length);
	if ( tmp_format != NULL ) {
	    dump_IOFormat(tmp_format);
	} else {
	    printf("Get format failed!\n");
	}
    }
    return 0;
}	
