#include "fcntl.h"
#include "io.h"

typedef struct _first_rec {
    int 	i;
    long  	j;
    double 	d;
    char        *s;
    char 	c;
} first_rec, *first_rec_ptr;

static IOField field_list[] = {
    {"i", "integer", sizeof(int), IOOffset(first_rec_ptr, i)},
    {"j", "integer", sizeof(long), IOOffset(first_rec_ptr, j)},
    {"d", "float",   sizeof(double), IOOffset(first_rec_ptr, d)},
    {"s", "string", sizeof(char *), IOOffset(first_rec_ptr, s)},
    {"c", "integer", sizeof(char), IOOffset(first_rec_ptr, c)},
    {NULL, NULL, 0, 0},
};

int main()
{
    IOFile iofile = open_IOfile("test_output", O_WRONLY|O_CREAT|O_TRUNC);
    IOFormat first_rec_ioformat;
    first_rec rec1;
    char str[64];
    int i;

    first_rec_ioformat = register_IOrecord_format("first format",
                                                  field_list,
                                                  iofile);
    strcpy(str, "A String");
    rec1.s = str;
    for(i=0; i<10; i++) {
        rec1.i = i;  rec1.j = 2*i; rec1.d = 2.727 + i; rec1.c = 'A' + 2*i;
	strcat(str, "!");
        if(!write_IOfile(iofile, first_rec_ioformat, &rec1)) {
           printf("write failed\n");
        }
    }
    close_IOfile(iofile);
}
