#include "fcntl.h"
#include "io.h"

typedef struct _first_rec {
    int 	i;
    long  	j;
    double 	d;
    char        *s;
    char 	c;
} first_rec, *first_rec_ptr;

typedef struct R3vector_struct {
    double x, y, z;
} R3vector;

typedef struct particle_struct {
    R3vector	loc;
    R3vector	deriv1;
    R3vector	deriv2;
} particle;

static IOField field_list[] = {
    {"i", "integer", sizeof(int), IOOffset(first_rec_ptr, i)},
    {"j", "integer", sizeof(long), IOOffset(first_rec_ptr, j)},
    {"d", "float",   sizeof(double), IOOffset(first_rec_ptr, d)},
    {"s", "string", sizeof(char *), IOOffset(first_rec_ptr, s)},
    {"c", "integer", sizeof(char), IOOffset(first_rec_ptr, c)},
    {NULL, NULL, 0, 0},
};

static IOField R3field_list[] = {
    {"x", "float", sizeof(double), IOOffset(R3vector*, x)},
    {"y", "float", sizeof(double), IOOffset(R3vector*, y)},
    {"z", "float", sizeof(double), IOOffset(R3vector*, z)},
    {NULL, NULL, 0, 0},
};

static IOField particle_field_list[] = {
    {"location", "R3vector", sizeof(R3vector), IOOffset(particle*, loc)},
    {"derivative1", "R3vector", sizeof(R3vector), IOOffset(particle*, deriv1)},
    {"derivative2", "R3vector", sizeof(R3vector), IOOffset(particle*, deriv2)},
    {NULL, NULL, 0, 0},
};

int main()
{
    IOFile iofile = open_IOfile("test_output", O_WRONLY|O_CREAT|O_TRUNC);
    IOFormat first_rec_ioformat, vec_ioformat, particle_ioformat;
    first_rec rec1;
    char str[64];
    int i;

    first_rec_ioformat = register_IOrecord_format("first format",
                                                  field_list, iofile);
    vec_ioformat = register_IOrecord_format("R3vector",
                                             R3field_list, iofile);
    particle_ioformat = register_IOrecord_format("particle",
                                                  particle_field_list, iofile);
    srandom(time(NULL));
    strcpy(str, "A String");
    rec1.s = str;
    for(i=0; i<10; i++) {
	if (random() % 2 == 1) {
	    rec1.i = i;  rec1.j = 2*i; rec1.d = 2.727 + i; rec1.c = 'A' + 2*i;
	    strcat(str, "!");
	    if(!write_IOfile(iofile, first_rec_ioformat, &rec1)) {
		printf("write failed\n");
	    }
	} else {
	    particle p;
	    double s = i * i;
	    double c = s * i;
	    p.deriv2.x = 3.0*i;  p.deriv2.y = 4.2*i;  p.deriv2.z = 4.8*i;
	    p.deriv1.x = 1.5*s;  p.deriv1.y = 2.1*s;  p.deriv1.z = 2.4*s;
	    p.loc.x    =  .5*c;  p.loc.y    =  .7*c;  p.loc.z    =  .8*c;
	    if(!write_IOfile(iofile, particle_ioformat, &p)) {
		printf("write failed\n");
	    }
	}
    }
    close_IOfile(iofile);
}
