#include "fcntl.h"
#include "io.h"

typedef struct _first_rec {
    int 	i;
    long  	j;
    double 	d;
    char        *s;
    char 	c;
} first_rec, *first_rec_ptr;

static IOField field_list[] = {
    {"i", "integer", sizeof(int), IOOffset(first_rec_ptr, i)},
    {"j", "integer", sizeof(long), IOOffset(first_rec_ptr, j)},
    {"d", "float",   sizeof(double), IOOffset(first_rec_ptr, d)},
    {"s", "string", sizeof(char *), IOOffset(first_rec_ptr, s)},
    {"c", "integer", sizeof(char), IOOffset(first_rec_ptr, c)},
    {NULL, NULL, 0, 0},
};
void
main(argc, argv)
int argc;
char **argv;
{
    IOFile iofile = open_IOfile("test_output", O_RDONLY);
    first_rec rec1;
    int i;

    set_IOconversion(iofile, "first format", field_list, sizeof(first_rec));
    for(i=0; i<10; i++) {
        read_IOfile(iofile, &rec1);
        printf("rec had %d, %d, %g, %s, %c\n", rec1.i, rec1.j, rec1.d, 
	       rec1.s, rec1.c);
    }
    close(iofile);
    exit(0);    
}
