#include "fcntl.h"
#include "io.h"

typedef struct _first_rec {
    int 	i;
    long  	j;
    double 	d;
    char        *s;
    char 	c;
} first_rec, *first_rec_ptr;

typedef struct R3vector_struct {
    double x, y, z;
} R3vector;

typedef struct particle_struct {
    R3vector	loc;
    R3vector	deriv1;
    R3vector	deriv2;
} particle;

static IOField field_list[] = {
    {"i", "integer", sizeof(int), IOOffset(first_rec_ptr, i)},
    {"j", "integer", sizeof(long), IOOffset(first_rec_ptr, j)},
    {"d", "float",   sizeof(double), IOOffset(first_rec_ptr, d)},
    {"s", "string", sizeof(char *), IOOffset(first_rec_ptr, s)},
    {"c", "integer", sizeof(char), IOOffset(first_rec_ptr, c)},
    {NULL, NULL, 0, 0},
};

static IOField R3field_list[] = {
    {"x", "float", sizeof(double), IOOffset(R3vector*, x)},
    {"y", "float", sizeof(double), IOOffset(R3vector*, y)},
    {"z", "float", sizeof(double), IOOffset(R3vector*, z)},
    {NULL, NULL, 0, 0},
};

static IOField particle_field_list[] = {
    {"location", "R3vector", sizeof(R3vector), IOOffset(particle*, loc)},
    {"derivative1", "R3vector", sizeof(R3vector), IOOffset(particle*, deriv1)},
    {"derivative2", "R3vector", sizeof(R3vector), IOOffset(particle*, deriv2)},
    {NULL, NULL, 0, 0},
};

void
main(argc, argv)
int argc;
char **argv;
{
    IOFile iofile = open_IOfile("test_output", O_RDONLY);
    IOFormat first_format, particle_format, next_format;

    while(1) {
	switch(next_IOrecord_type(iofile)) {
	case IOend:
	case IOerror:
	    close(iofile);
	    exit(0);
	    break;
	case IOformat:
	    next_format = read_format_IOfile(iofile);
	    if (strcmp("first format", name_of_IOformat(next_format)) == 0) {
		first_format = next_format;
		set_IOconversion(iofile, "first format", field_list, sizeof(first_rec));
	    } else if (strcmp("particle", name_of_IOformat(next_format)) == 0) {
		particle_format = next_format;
		set_IOconversion(iofile, "particle", particle_field_list, sizeof(particle));
	    } else if (strcmp("R3vector", name_of_IOformat(next_format)) == 0) {
		set_IOconversion(iofile, "R3vector", R3field_list, sizeof(R3vector));
	    } else {
		/* no need to track other formats */
	    }
	    break;
	case IOdata:
	    next_format = next_IOrecord_format(iofile);
	    if (next_format == first_format) {
		first_rec rec1;
		read_IOfile(iofile, &rec1);
		printf("rec had %d, %d, %g, %s, %c\n", rec1.i, rec1.j, rec1.d, 
		       rec1.s, rec1.c);
	    } else if (next_format == particle_format) {
		particle p;
		read_IOfile(iofile, &p);
		printf("particle.loc = %g, %g, %g, deriv1 = %g, %g, %g\n", p.loc.x,
		       p.loc.y, p.loc.z, p.deriv1.x, p.deriv1.y, p.deriv1.z); 
	    } else {
		/* read and discard other records */
		read_IOfile(iofile, NULL);
	    }
	    break;
	case IOcomment:
	    {
		char *comment = read_comment_IOfile(iofile);
		printf("Got comment >%s<\n", comment);
		break;
	    }
	}
    }
}
