dnl Local additions to Autoconf macros.
dnl 
dnl
AC_DEFUN(AC_FPRINTF_DEFINED,
[AC_MSG_CHECKING(whether stdio.h declares fprintf)
AC_CACHE_VAL(ac_cv_fprintf_found,
[AC_EGREP_HEADER(
changequote(<<, >>)dnl
<<[[^a-zA-Z_]fprintf[^a-zA-Z_]]>>changequote([, ])dnl
, stdio.h, ac_cv_fprintf_found=yes, ac_cv_fprintf_found=no)
])
AC_MSG_RESULT($ac_cv_fprintf_found)
if test $ac_cv_fprintf_found = yes; then
   AC_DEFINE(FPRINTF_DEFINED,1)
fi
])dnl
AC_DEFUN(AC_PRINTF_DEFINED,
[AC_MSG_CHECKING(whether stdio.h declares printf)
AC_CACHE_VAL(ac_cv_printf_found,
[AC_EGREP_HEADER(
changequote(<<, >>)dnl
<<[[^a-zA-Z_]printf[^a-zA-Z_]]>>changequote([, ])dnl
, stdio.h, ac_cv_printf_found=yes, ac_cv_printf_found=no)
])
AC_MSG_RESULT($ac_cv_printf_found)
if test $ac_cv_printf_found = yes; then
   AC_DEFINE(PRINTF_DEFINED,1)
fi
])dnl
AC_DEFUN(AC_WRITE_DEFINED,
[AC_MSG_CHECKING(whether unistd.h declares write)
AC_CACHE_VAL(ac_cv_write_found,
[AC_EGREP_HEADER(
changequote(<<, >>)dnl
<<[[^a-zA-Z_]write[^a-zA-Z_]]>>changequote([, ])dnl
, unistd.h, ac_cv_write_found=yes, ac_cv_write_found=no)
])
AC_MSG_RESULT($ac_cv_write_found)
if test $ac_cv_write_found = yes; then
   AC_DEFINE(WRITE_DEFINED,1)
fi
])dnl
AC_DEFUN(AC_READ_DEFINED,
[AC_MSG_CHECKING(whether unistd.h declares read)
AC_CACHE_VAL(ac_cv_read_found,
[AC_EGREP_HEADER(
changequote(<<, >>)dnl
<<[[^a-zA-Z_]read[^a-zA-Z_]]>>changequote([, ])dnl
, unistd.h, ac_cv_read_found=yes, ac_cv_read_found=no)
])
AC_MSG_RESULT($ac_cv_read_found)
if test $ac_cv_read_found = yes; then
   AC_DEFINE(READ_DEFINED,1)
fi
])dnl
AC_DEFUN(AC_SSCANF_DEFINED,
[AC_MSG_CHECKING(whether stdio.h declares sscanf)
AC_CACHE_VAL(ac_cv_sscanf_found,
[AC_EGREP_HEADER(
changequote(<<, >>)dnl
<<[[^a-zA-Z_]sscanf[^a-zA-Z_]]>>changequote([, ])dnl
, stdio.h, ac_cv_sscanf_found=yes, ac_cv_sscanf_found=no)
])
AC_MSG_RESULT($ac_cv_sscanf_found)
if test $ac_cv_sscanf_found = yes; then
   AC_DEFINE(SSCANF_DEFINED,1)
fi
])dnl
AC_DEFUN(AC_STRDUP_DEFINED,
[AC_MSG_CHECKING(whether string.h declares strdup)
AC_CACHE_VAL(ac_cv_strdup_found,
[AC_EGREP_HEADER(
changequote(<<, >>)dnl
<<[[^a-zA-Z_]strdup[^a-zA-Z_]]>>changequote([, ])dnl
, string.h, ac_cv_strdup_found=yes, ac_cv_strdup_found=no)
])
AC_MSG_RESULT($ac_cv_strdup_found)
if test $ac_cv_strdup_found = yes; then
   AC_DEFINE(STRDUP_DEFINED,1)
fi
])dnl
AC_DEFUN(AC_BZERO_DEFINED,
[AC_MSG_CHECKING(whether string.h declares bzero)
AC_CACHE_VAL(ac_cv_bzero_found,
[AC_EGREP_HEADER(
changequote(<<, >>)dnl
<<[[^a-zA-Z_]bzero[^a-zA-Z_]]>>changequote([, ])dnl
, string.h, ac_cv_bzero_found=yes, ac_cv_bzero_found=no)
])
AC_MSG_RESULT($ac_cv_bzero_found)
if test $ac_cv_bzero_found = yes; then
   AC_DEFINE(BZERO_DEFINED,1)
fi
])dnl
dnl  AC_SEARCH(variable to define, options to try)
define(AC_SEARCH,
[tmp_search_results=""
for tmp_search_value in $1; do 
   if test -r $tmp_search_value; then 
	tmp_search_results=$tmp_search_value
	break
   fi 
done
])dnl
AC_DEFUN(AC_HPPCEL_SET_ARCH,
[if test -z "$hppcel_cv_arch"; then
AC_MSG_CHECKING(HPPCEL architecture)
AC_CACHE_VAL(hppcel_cv_arch,[
if test -x $srcdir/config.guess; then
target=`$srcdir/config.guess`
else
UNAME_MACHINE=`(uname -m) 2>/dev/null` || UNAME_MACHINE=unknown
UNAME_RELEASE=`(uname -r) 2>/dev/null` || UNAME_RELEASE=unknown
UNAME_SYSTEM=`(uname -s) 2>/dev/null` || UNAME_SYSTEM=unknown
UNAME_VERSION=`(uname -v) 2>/dev/null` || UNAME_VERSION=unknown
target="${UNAME_MACHINE}:${UNAME_SYSTEM}:${UNAME_RELEASE}:${UNAME_VERSION}"
fi
case "$target" in
    sparc-*-*)
    	hppcel_cv_arch=sparc;;
    ksr1-*-*)
	hppcel_cv_arch=ksr;;
    ksr2-*-*)
	hppcel_cv_arch=ksr;;
    *-*-irix*)
	hppcel_cv_arch=sgi;;
    rs6000-*-*)
	hppcel_cv_arch=rs6000;;
    *-*-*)
	hppcel_cv_arch=`echo $target | sed 's/-.*//'`;;
esac
]
AC_MSG_RESULT($hppcel_cv_arch)
fi
)])dnl
dnl ac_find_hppcel_package(package, file_to_find, variable_to_set, suggestion)
AC_DEFUN(AC_FIND_HPPCEL_PACKAGE,
[AC_HPPCEL_SET_ARCH
$3=""
search_list=""
CHAOS_HOMEDIR=`echo "echo ~chaos" | csh -sf  2>/dev/null` || CHAOS_HOMEDIR=""
PARALLEL_HOMEDIR=`echo "echo ~parallel" | csh -sf  2>/dev/null` || PARALLEL_HOMEDIR=""
if test -n "$4"; then
EXPANDED=`echo "echo $4" | csh -sf 2>/dev/null` || EXPANDED=""
search_list="$search_list $EXPANDED/$1/$2 $EXPANDED/$1/$hppcel_cv_arch/$2 $EXPANDED/$1/include/$2 $EXPANDED/$1/lib/$hppcel_cv_arch/$2 $EXPANDED/$2 $EXPANDED/$hppcel_cv_arch/$2 $EXPANDED/include/$2 $EXPANDED/lib/$hppcel_cv_arch/$2"
fi
search_list="$search_list /usr/lib/$2 /usr/local/lib/$2 /usr/include/$2 /opt/$1/lib/$2 /opt/$1/include/$2"
search_list="$search_list ../$1/$2 $HOME/$1/$2 $HOME/$1/$hppcel_cv_arch/$2"
if test -n "$CHAOS_HOMEDIR"; then
search_list="$search_list $CHAOS_HOMEDIR/$1/$2 $CHAOS_HOMEDIR/$1/$hppcel_cv_arch/$2 $CHAOS_HOMEDIR/$1/include/$2 $CHAOS_HOMEDIR/$1/lib/$hppcel_cv_arch/$2"
fi
if test -n "$PARALLEL_HOMEDIR"; then
search_list="$search_list $PARALLEL_HOMEDIR/$1/$2 $PARALLEL_HOMEDIR/$1/$hppcel_cv_arch/$2 $PARALLEL_HOMEDIR/$1/include/$2 $PARALLEL_HOMEDIR/$1/lib/$hppcel_cv_arch/$2"
fi
AC_SEARCH($search_list)
if test -n "$tmp_search_results"; then
$3=$tmp_search_results
fi
])dnl

dnl ac_require_hppcel_package(package, include_file, library_file)
AC_DEFUN(AC_REQUIRE_HPPCEL_PACKAGE,
[AC_HPPCEL_SET_ARCH
AC_ARG_WITH($1, [  -with-$1=<directory>	Where to find $1 package])
if test -n "$with_$1"; then
unset ac_cv_$1_include_arg
unset ac_cv_$1_link_arg
fi
AC_MSG_CHECKING(needed include args for $1 package)
AC_CACHE_VAL(ac_cv_$1_include_arg, 
[AC_FIND_HPPCEL_PACKAGE($1, $2, hppcel_tmp, $with_$1)
if test -n "$hppcel_tmp"; then
ac_cv_$1_include_arg=-I`echo $hppcel_tmp | sed 's/.$2//'`
fi
])
AC_MSG_RESULT($ac_cv_$1_include_arg)
CPPFLAGS="$CPPFLAGS $ac_cv_$1_include_arg"
if test -n "$3"; then
AC_MSG_CHECKING(needed link args for $1 package)
AC_CACHE_VAL(ac_cv_$1_link_arg, 
[AC_FIND_HPPCEL_PACKAGE($1, $3, hppcel_tmp, $with_$1)
if test -n "$hppcel_tmp"; then
ac_cv_$1_link_arg=-L`echo $hppcel_tmp | sed 's/.$3//'`
fi
])
AC_MSG_RESULT($ac_cv_$1_link_arg)
LDFLAGS="$LDFLAGS $ac_cv_$1_link_arg"
fi
])dnl
