
#include "config.h"
#include <fcntl.h>
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <string.h>
#include <assert.h>
#include "io.h"
#include "unix_defs.h"

#include "test_funcs.h"

static void test_receive ARGS((char *buffer, int buf_size, int finished,
			       int test_level));
static void test_all_receive ARGS((char *buffer, int buf_size, int finished));
static void write_buffer ARGS((char *buf, int size));
static void read_test_only();

static int write_output = 0;
static char *output_file = NULL;
static char *read_file = NULL;
static int fail = 0;

int
main(argc, argv)
int argc;
char **argv;
{
    IOContext src_context = create_IOcontext(NULL);
    IOFormat first_rec_ioformat, second_rec_ioformat, third_rec_ioformat;
    IOFormat fourth_rec_ioformat, later_ioformat, nested_ioformat;
    IOFormat embedded_rec_ioformat, fifth_rec_ioformat;
    char *xfer_buffer;
    int buf_size;
    first_rec rec1;
    first_rec array1[10];
    second_rec rec2;
    third_rec rec3;
    fourth_rec rec4;
    later_rec rec5;
    later_rec2 rec6;
    nested_rec rec7;
    fifth_rec emb_array;
    sixth_rec var_array;
    ninth_rec var_var;
    string_array_rec str_array;
    int i, j;
    IOFormat sixth_rec_ioformat, ninth_rec_ioformat, string_array_ioformat;

    for (i=1; i<argc; i++) {
	if (strcmp(argv[i], "-w") == 0) {
	    output_file = argv[++i];
	    write_output++;
	} else if (strcmp(argv[i], "-r") == 0) {
	    read_file = argv[++i];
	}
    }

    if (read_file) {
	read_test_only();
	if (fail) exit(1);
	exit(0);
    }
    first_rec_ioformat = register_IOcontext_format("first format",
						  field_list,
						  src_context);
    second_rec_ioformat = register_IOcontext_format("string format",
						   field_list2,
						   src_context);
    third_rec_ioformat = register_IOcontext_format("two string format",
						  field_list3,
						  src_context);
    fourth_rec_ioformat = register_IOcontext_format("internal array format",
						   field_list4,
						   src_context);
    embedded_rec_ioformat = register_IOcontext_format("embedded",
						     embedded_field_list,
						     src_context);
    (void)embedded_rec_ioformat;
    fifth_rec_ioformat = register_IOcontext_format("structured array format",
						  field_list5,
						  src_context);
    sixth_rec_ioformat = register_IOcontext_format("variant array format",
						  field_list6,
						  src_context);
/*    write_comment_IOfile(src_context, "this is a comment in the file");*/
    memset((char *) &rec1, 0, sizeof(rec1));
    rec1.integer_field = 14;
    rec1.double_field = 2.717;
    rec1.char_field = 'A';
    xfer_buffer = encode_IOcontext_buffer(src_context, first_rec_ioformat, &rec1, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    memset((char *) &emb_array, 0, sizeof(emb_array));
    emb_array.earray[0].dfield = 4.0;
    emb_array.earray[0].ifield = 4;
    emb_array.earray[0].string = (char *) malloc(10);
    memset(emb_array.earray[0].string, 0, 10);
    sprintf(emb_array.earray[0].string, "string%d", emb_array.earray[0].ifield * 5);
    emb_array.earray[1].dfield = 3.0;
    emb_array.earray[1].ifield = 3;
    emb_array.earray[1].string = (char *) malloc(10);
    memset(emb_array.earray[1].string, 0, 10);
    sprintf(emb_array.earray[1].string, "string%d", emb_array.earray[1].ifield * 5);
    emb_array.earray[2].dfield = 2.0;
    emb_array.earray[2].ifield = 2;
    emb_array.earray[2].string = (char *) malloc(10);
    memset(emb_array.earray[2].string, 0, 10);
    sprintf(emb_array.earray[2].string, "string%d", emb_array.earray[2].ifield * 5);
    emb_array.earray[3].dfield = 1.0;
    emb_array.earray[3].ifield = 1;
    emb_array.earray[3].string = (char *) malloc(10);
    memset(emb_array.earray[3].string, 0, 10);
    sprintf(emb_array.earray[3].string, "string%d", emb_array.earray[3].ifield * 5);
    xfer_buffer = encode_IOcontext_buffer(src_context, fifth_rec_ioformat, &emb_array, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    memset((char *) &rec2, 0, sizeof(rec2));
    rec2.integer_field = 14;
    rec2.short_field = 27;
    rec2.long_field = 987234;
    rec2.string = "testing";
    rec2.double_field = 2.717;
    rec2.char_field = 'A';
    xfer_buffer = encode_IOcontext_buffer(src_context, second_rec_ioformat, &rec2, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    rec2.integer_field = 14;
    rec2.short_field = 27;
    rec2.long_field = 987234;
    rec2.string = NULL;
    rec2.double_field = 2.717;
    rec2.char_field = 'A';
    xfer_buffer = encode_IOcontext_buffer(src_context, second_rec_ioformat, &rec2, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    rec1.integer_field = 17;
    rec1.double_field *= 3.0;
    rec1.char_field = 'B';
    xfer_buffer = encode_IOcontext_buffer(src_context, first_rec_ioformat, &rec1, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    rec2.integer_field = 14;
    rec2.short_field = 27;
    rec2.long_field = 987234;
    rec2.string = NULL;
    rec2.double_field = 2.717;
    rec2.char_field = 'A';
    xfer_buffer = encode_IOcontext_buffer(src_context, second_rec_ioformat, &rec2, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    rec1.integer_field *= 2;
    rec1.double_field *= 2.717;
    rec1.char_field = 'C';
/*    write_comment_IOfile(iofile, "this is another comment in the file");*/
    xfer_buffer = encode_IOcontext_buffer(src_context, first_rec_ioformat, &rec1, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    memset((char *) &rec3, 0, sizeof(rec3));
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.uint_field = 0xf7e589ce;	/* = 4159015374 */
#if SIZEOF_LONG==64
    rec3.ulong_field = 0xf7e589ceec9dd130;
#else
    rec3.ulong_field = 0xec9dd130;	/* = 3969765680 */
#endif
    rec3.string = "testing";
    rec3.double_field = 2.717;
    rec3.string2 = "jambalaya";
    rec3.char_field = 'A';
    rec3.enum_field = Red_Stripe;
    xfer_buffer = encode_IOcontext_buffer(src_context, third_rec_ioformat, &rec3, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    later_ioformat = register_IOcontext_format("later format",
					      later_field_list,
					      src_context);
    nested_ioformat = register_IOcontext_format("nested format",
					       nested_field_list,
					       src_context);
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.string = NULL;
    rec3.double_field = 2.717;
    rec3.string2 = "jambalaya";
    rec3.char_field = 'A';
    rec3.enum_field = Paulaner;
    xfer_buffer = encode_IOcontext_buffer(src_context, third_rec_ioformat, &rec3, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    memset((char *) &rec7, 0, sizeof(rec7));
    rec7.integer_field = 47;
    rec7.nested_rec.integer_field = 14;
    rec7.nested_rec.short_field = 27;
    rec7.nested_rec.long_field = 987234;
    rec7.nested_rec.string = "Another string";
    rec7.nested_rec.double_field = 2.717;
    rec7.nested_rec.char_field = 'A';
    rec7.string = "Yet another string";
    xfer_buffer = encode_IOcontext_buffer(src_context, nested_ioformat, &rec7, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.string = "testing";
    rec3.double_field = 2.717;
    rec3.string2 = NULL;
    rec3.char_field = 'A';
    rec3.enum_field = Pilsner;
    xfer_buffer = encode_IOcontext_buffer(src_context, third_rec_ioformat, &rec3, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.string = NULL;
    rec3.double_field = 2.717;
    rec3.string2 = NULL;
    rec3.char_field = 'A';
    rec3.enum_field = Red_Stripe;
    xfer_buffer = encode_IOcontext_buffer(src_context, third_rec_ioformat, &rec3, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    memset((char *) &rec5, 0, sizeof(rec5));
    rec5.integer_field = 9872346;
    rec5.string = "ABCD";
    rec5.double_field = 3.14159265358797323;
    xfer_buffer = encode_IOcontext_buffer(src_context, later_ioformat, &rec5, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.string = "testing";
    rec3.double_field = 2.717;
    rec3.string2 = "jambalaya";
    rec3.char_field = 'A';
    rec3.enum_field = Pilsner;
    xfer_buffer = encode_IOcontext_buffer(src_context, third_rec_ioformat, &rec3, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    rec2.integer_field = 14;
    rec2.short_field = 27;
    rec2.long_field = 987234;
    rec2.string = "the end";
    rec2.double_field = 2.717;
    rec2.char_field = 'A';
    xfer_buffer = encode_IOcontext_buffer(src_context, second_rec_ioformat, &rec2, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    for (i = 0; i < 10; i++) {
	memset((char *) &array1[i], 0, sizeof(array1[i]));
	array1[i].integer_field = 2 * i * i;
	array1[i].double_field = 2.717 * (i * i);
	array1[i].char_field = 'D' + i;
    }
    later_ioformat = register_IOcontext_format("later format",
					      later_field_list2,
					      src_context);
/*    if (!write_array_IOfile(iofile, first_rec_ioformat, &array1[0],
			    10, sizeof(array1[0])))
	IOperror(iofile, "write failed\n");*/

    memset((char *) &rec4, 0, sizeof(rec4));
    for (i = 0; i < ARRAY_SIZE; i++) {
	rec4.int_array[i] = 297 + i;
    }
    rec4.double_array[0][0] = 1.0;
    rec4.double_array[0][1] = 2.0;
    rec4.double_array[1][0] = 3.0;
    rec4.double_array[1][1] = 4.0;
    rec4.ifield = -rec4.int_array[ARRAY_SIZE - 1];
    xfer_buffer = encode_IOcontext_buffer(src_context, fourth_rec_ioformat, &rec4, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    memset((char *) &rec6, 0, sizeof(rec6));
    rec6.integer_field = 23462346;
    rec6.string = "Efghij";
    rec6.double_field = 3.14159265358797323 * 2.0;
    xfer_buffer = encode_IOcontext_buffer(src_context, later_ioformat, &rec6, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);
    rec6.integer_field = 2346987;
    rec6.string = "Klmn";
    rec6.double_field = 3.14159265358797323 * 3.0;
    xfer_buffer = encode_IOcontext_buffer(src_context, later_ioformat, &rec6, &buf_size);
    test_all_receive(xfer_buffer, buf_size, 0);
    write_buffer(xfer_buffer, buf_size);

    for (i = 1; i < 20; i += 5) {
        memset((char *) &var_array, 0, sizeof(var_array));
	var_array.string = malloc(10);
	memset(var_array.string, 0, 10);
	sprintf(var_array.string, "variant%d", i);
	var_array.icount = 2 * i;
	var_array.var_int_array = malloc(sizeof(((sixth_rec_ptr) 0)->var_int_array[0]) * var_array.icount);
	var_array.var_double_array = malloc(sizeof(double) * var_array.icount);
	var_array.var_string_array = malloc(sizeof(second_rec) * var_array.icount);
        memset((char *) var_array.var_string_array, 0, 
	       sizeof(second_rec) * var_array.icount);
	for (j = 0; j < var_array.icount; j++) {
	    var_array.var_int_array[j] = 297 + j;
	    var_array.var_double_array[j] = 2.717 * j;
	    var_array.var_string_array[j].integer_field = 345 * j;
	    var_array.var_string_array[j].short_field = j;
	    var_array.var_string_array[j].long_field = 785 * j;
	    var_array.var_string_array[j].string = malloc(15);
	    memset(var_array.var_string_array[j].string, 0, 15);
	    sprintf(var_array.var_string_array[j].string,
		    "substring%d", j);
	    var_array.var_string_array[j].double_field = 3.1415 * j;
	    var_array.var_string_array[j].char_field = 'a' + 2 * j;
	}

	xfer_buffer = encode_IOcontext_buffer(src_context, sixth_rec_ioformat, 
					      &var_array, &buf_size);
	test_all_receive(xfer_buffer, buf_size, 0);
	write_buffer(xfer_buffer, buf_size);
	for (j = 0; j < var_array.icount; j++) {
	    free(var_array.var_string_array[j].string);
	}
	free(var_array.var_string_array);
	free(var_array.string);
	free(var_array.var_int_array);
	free(var_array.var_double_array);
    }
    register_IOcontext_format("EventVecElem", event_vec_elem_fields,
			      src_context);

    ninth_rec_ioformat = register_IOcontext_format("EventV",
						  field_list9,
						  src_context);
    string_array_ioformat = register_IOcontext_format("StringArray",
						      string_array_field_list,
						      src_context);
    for (i = 1; i < 10; i += 2) {
        memset((char *) &var_var, 0, sizeof(var_var));
	var_var.vec_length = i;
	var_var.eventv = malloc(sizeof(((ninth_rec_ptr) 0)->eventv[0]) * var_var.vec_length);

	str_array.array_len = i;
	str_array.array = malloc(sizeof(char*) * i);

	for (j = 0; j < var_var.vec_length; j++) {
	    int k;
	    var_var.eventv[j].iov_len = j + i;
	    var_var.eventv[j].iov_base = malloc(j + i);
	    str_array.array[j] = malloc(i + j + 2);
	    for (k=0; k<j+i; k++) {
		((char*)var_var.eventv[j].iov_base)[k] = 'A' + k + i/5;
		str_array.array[j][k] = 'a' + k + i;
	    }
	    str_array.array[j][k] = 0;
	}
	if ((i %4) == 1) {
	    str_array.base_string = NULL;
	} else {
	    str_array.base_string = strdup("Whoa there!");
	}
	xfer_buffer = encode_IOcontext_buffer(src_context, ninth_rec_ioformat, 
					      &var_var, &buf_size);
	test_all_receive(xfer_buffer, buf_size, 0);
	write_buffer(xfer_buffer, buf_size);

	xfer_buffer = encode_IOcontext_buffer(src_context, 
					      string_array_ioformat, 
					      &str_array, &buf_size);
	test_all_receive(xfer_buffer, buf_size, 0);
	write_buffer(xfer_buffer, buf_size);

	for (j = 0; j < var_var.vec_length; j++) {
	    free(var_var.eventv[j].iov_base);
	}
    }
    free_IOcontext(src_context);
    test_all_receive(NULL, 0, 1);
    write_buffer(NULL, 0);
    if (fail) exit(1);
    return 0;
}

/* NT needs O_BINARY, but it doesn't exist elsewhere */
#ifndef O_BINARY
#define O_BINARY 0
#endif

static char *
get_buffer(size_p)
int *size_p;
{
    static int file_fd = 0;
    static char *buffer = NULL;
    char *tmp_buffer;
    static int last_size = -1;
    unsigned short ssize;
    int to_read;
    int tmp_size;
    unsigned char csize;
    unsigned int beef = 0xdeadbeef;

    if (read_file == NULL) exit(1);

    if (file_fd == 0) {
	file_fd = open(read_file, O_RDONLY|O_BINARY, 0777);
	buffer = malloc(1);
    }
    if (last_size != -1) {
	if (memcmp(buffer+last_size, &beef, 4) != 0) {
	    printf("memory overwrite error\n");
	}
    }
    read(file_fd, &csize, 1);	/* low byte of 2-byte size */
    ssize = csize;
    read(file_fd, &csize, 1);	/* high byte of 2-byte size */
    ssize += ((csize << 8) & 0xff00);
    to_read = ssize;
    buffer = realloc(buffer, to_read+4);
    tmp_buffer = buffer;
    while((tmp_size = read(file_fd, tmp_buffer, to_read)) != to_read) {
	if (tmp_size == 0) {
	    free(buffer);
	    return NULL;
	} else if (tmp_size == -1) {
	    perror("Read failure");
	    free(buffer);
	    return NULL;
	}
	to_read -= tmp_size;
	tmp_buffer += tmp_size;
    } 
    last_size = ssize;
    memcpy(buffer+last_size, &beef, 4);
    if (ssize == 0) {
	free(buffer);
	close(file_fd);
	file_fd = 0;
	return NULL;
    } else {
	*size_p = ssize;
	return buffer;
    }
}

static void
read_test_only()
{
    char *input;
    int size;
    while ((input = get_buffer(&size)) != NULL) {
	test_all_receive(input, size, 0);
    }
    test_all_receive(NULL, 0, 1);
}

static IOFormat first_rec_ioformat, second_rec_ioformat, third_rec_ioformat;
static IOFormat fourth_rec_ioformat, later_rec_ioformat, nested_rec_ioformat;
static IOFormat embedded_rec_ioformat, fifth_rec_ioformat, sixth_rec_ioformat;
static IOFormat ninth_rec_ioformat, string_array_ioformat;

static void
set_conversion(context, formats)
IOContext context;
IOFormat *formats;
{
    int i;
    for (i = 0; formats[i] != NULL; i++) {
	IOFormat format = formats[i];
	char *format_name;
	format_name = name_of_IOformat(format);
	if (strcmp(format_name, "first format") == 0) {
	    first_rec_ioformat = format;
	    set_conversion_IOcontext(context, format, field_list,
				     sizeof(first_rec));
	} else if (strcmp(format_name, "string format") == 0) {
	    second_rec_ioformat = format;
	    set_conversion_IOcontext(context, format, field_list2,
				     sizeof(second_rec));
	} else if (strcmp(format_name, "two string format") == 0) {
	    third_rec_ioformat = format;
	    set_conversion_IOcontext(context, format, field_list3,
				     sizeof(third_rec));
	} else if (strcmp(format_name, "internal array format") == 0) {
	    fourth_rec_ioformat = format;
	    set_conversion_IOcontext(context, format, field_list4,
				     sizeof(fourth_rec));
	} else if (strcmp(format_name, "embedded") == 0) {
	    embedded_rec_ioformat = format;
	    set_conversion_IOcontext(context, format, embedded_field_list,
				     sizeof(embedded_rec));
	} else if (strcmp(format_name, "structured array format") == 0) {
	    fifth_rec_ioformat = format;
	    set_conversion_IOcontext(context, format, field_list5,
				     sizeof(fifth_rec));
	} else if (strcmp(format_name, "variant array format") == 0) {
	    sixth_rec_ioformat = format;
	    set_conversion_IOcontext(context, format, field_list6,
				     sizeof(sixth_rec));
	} else if (strcmp(format_name, "later format") == 0) {
	    later_rec_ioformat = format;
	    set_conversion_IOcontext(context, format, later_field_list, 
				     sizeof(later_rec));
	} else if (strcmp(format_name, "nested format") == 0) {
	    nested_rec_ioformat = format;
	    set_conversion_IOcontext(context, format, nested_field_list,
				     sizeof(nested_rec));
	} else if (strcmp(format_name, "EventVecElem") == 0) {
	    set_conversion_IOcontext(context, format, event_vec_elem_fields,
				     sizeof(struct _io_encode_vec));
	} else if (strcmp(format_name, "EventV") == 0) {
	    ninth_rec_ioformat = format;
	    set_conversion_IOcontext(context, format, field_list9,
				     sizeof(ninth_rec));
	} else if (strcmp(format_name, "StringArray") == 0) {
	    string_array_ioformat = format;
	    set_conversion_IOcontext(context, format, string_array_field_list,
				     sizeof(string_array_rec));
	} else {
	    printf("Got unexpected format %s\n", format_name);
	}
    }
}


int base_size_func(context, src, rec_len, native_struct_size)
IOContext context;
char *src;
int rec_len;
int native_struct_size;
{
    return native_struct_size;
}

int total_size_func(context, src, rec_len, native_struct_size)
IOContext context;
char *src;
int rec_len;
int native_struct_size;
{
    return this_IOrecord_length(context, src, rec_len);
}

static int 
decode_in_place(context, src, src_len, dest)
IOContext context;
char *src;
int src_len;
void *dest;
{
    if (decode_in_place_possible(get_format_IOcontext(context, src))) {
	int ret, header_len;
	char *real_dest;
	ret = decode_in_place_IOcontext(context, src, (void**)&real_dest);
	header_len = real_dest - src;
	memcpy(dest, real_dest, src_len - header_len);
	return ret;
    } else {
	return decode_to_buffer_IOcontext(context, src, dest);
    }
}

static int
decode_IOcontext_wrapper(context, src, src_len, dest)
IOContext context;
char *src;
int src_len;
void *dest;
{
    return decode_IOcontext(context, src, dest);
}

static int
decode_to_buffer_IOcontext_wrapper(context, src, src_len, dest)
IOContext context;
char *src;
int src_len;
void *dest;
{
    return decode_to_buffer_IOcontext(context, src, dest);
}

typedef int (*size_func_t) ARGS((IOContext context, char *src, int buf_size, 
				   int nativ_struct));

typedef int (*decode_func_t) ARGS((IOContext context, char *src, int src_len, 
				   void *dest));

size_func_t size_funcs[] = {base_size_func, total_size_func, total_size_func};
decode_func_t decode_funcs[] = {decode_IOcontext_wrapper, 
				decode_to_buffer_IOcontext_wrapper,
				decode_in_place};

#define NUM_TESTS 3

static void
test_all_receive(buffer, buf_size, finished)
char *buffer;
int buf_size;
int finished;
{
    int test_type = 0;
    char *tmp_buffer = malloc(buf_size);
    for ( test_type = 0; test_type < NUM_TESTS; test_type++) {
	memcpy(tmp_buffer, buffer, buf_size);
	test_receive(tmp_buffer, buf_size, finished, test_type);
    }
    free(tmp_buffer);
}
	
static void*
get_mem(size)
int size;
{
    char *buffer;
    unsigned int beef = 0xdeadbeef;

    buffer = malloc(size+4);
    memcpy(buffer+size, &beef, 4);
    return buffer;
}

static void
check_mem(size, buffer)
int size;
char *buffer;
{
    unsigned int beef = 0xdeadbeef;
    if (memcmp(buffer+size, &beef, 4) != 0) {
	printf("memory overwrite error\n");
    }
}

    
static void
test_receive(buffer, buf_size, finished, test_level)
char *buffer;
int buf_size;
int finished;
int test_level;
{
    static IOContext iocontext = NULL;
/*    static int comment_count[NUM_TESTS] = {0,0,0};*/
    static int first_rec_count[NUM_TESTS] = {0,0,0};
    static int second_rec_count[NUM_TESTS] = {0,0,0};
    static int third_rec_count[NUM_TESTS] = {0,0,0};
    static int fourth_rec_count[NUM_TESTS] = {0,0,0};
    static int fifth_rec_count[NUM_TESTS] = {0,0,0};
    static int sixth_rec_count[NUM_TESTS] = {0,0,0};
    static int nested_rec_count[NUM_TESTS] = {0,0,0};
    static int later_rec_count[NUM_TESTS] = {0,0,0};
    static int ninth_rec_count[NUM_TESTS] = {0,0,0};
    static int string_array_count[NUM_TESTS] = {0,0,0};

    static int unknown_rec_count[NUM_TESTS] = {0,0,0};
    size_func_t size_func = size_funcs[test_level];
    decode_func_t decode_func = decode_funcs[test_level];
    if (iocontext == NULL) {
	init_written_data();
	iocontext = create_IOcontext();
    }
    if (!finished) {
/*	char *comment;*/
	IOFormat buffer_format = get_format_IOcontext(iocontext, buffer);

	if (buffer_format == NULL) {
	    printf("No format!\n");
	    exit(1);
	}
	if (!has_conversion_IOformat(buffer_format)) {
	    IOFormat *buffer_formats;
	    buffer_formats = get_subformats_IOcontext(iocontext, buffer);
	    set_conversion(iocontext, buffer_formats);
	    free(buffer_formats);
	}
	if (buffer_format == first_rec_ioformat) {
	    first_rec read_data[10];
/*	    if (get_IOcontext_record_count(iocontext, buffer) == 1) {*/
		memset(&read_data[0], 0, sizeof(first_rec));
		if (!decode_func(iocontext, buffer, buf_size, &read_data[0]))
		    IOperror((IOFile)iocontext, "read first data");
		if (!first_rec_eq(&read_data[0], &rec1_array[first_rec_count[test_level]++])) {
		    printf("Rec1 failure\n");
		    fail++;
		}
/*	    } else {
		int count = next_IOrecord_count(iofile);
		if (count == 10) {
		    memset(&read_data[0], 0, sizeof(first_rec) * 10);
		    if (read_array_IOfile(iofile, &read_data[0], 10, sizeof(first_rec)) != 10)
			IOperror(iofile, "read first array");
		    if (memcmp(&read_data[0], &rec1_array[first_rec_count[test_level]],
			       sizeof(first_rec) * 10) != 0) {
			printf("Rec1 failure\n");
			fail++;
		    }
		    first_rec_count[test_level] += 10;
		} else {
		    printf("Rec1 failure\n");
		    fail++;
		}
	    }		*/
	} else if (buffer_format == second_rec_ioformat) {
	    int size = size_func(iocontext, buffer, buf_size, sizeof(second_rec));
	    second_rec *read_data = get_mem(size);
	    memset(read_data, 0, size);
	    if (!decode_func(iocontext, buffer, buf_size, read_data))
		IOperror((IOFile)iocontext, "read second data failed");
	    if (!second_rec_eq(read_data, &rec2_array[second_rec_count[test_level]++])) {
		printf("Rec2 failure\n");
		fail++;
	    }
	    check_mem(size, (char*)read_data);
	    free(read_data);
	} else if (buffer_format == third_rec_ioformat) {
	    int size = size_func(iocontext, buffer, buf_size, sizeof(third_rec));
	    third_rec *read_data = get_mem(size);
	    memset(read_data, 0, size);
	    if (!decode_func(iocontext, buffer, buf_size, read_data))
		IOperror((IOFile)iocontext, "read third data failed");
	    if (!third_rec_eq(read_data, &rec3_array[third_rec_count[test_level]++])) {
		printf("Rec3 failure\n");
		fail++;
	    }
	    check_mem(size, (char*)read_data);
	    free(read_data);
	} else if (buffer_format == fourth_rec_ioformat) {
	    int size = size_func(iocontext, buffer, buf_size, sizeof(fourth_rec));
	    fourth_rec *read_data = get_mem(size);
	    memset(read_data, 0, size);
	    if (!decode_func(iocontext, buffer, buf_size, read_data))
		IOperror((IOFile)iocontext, "read fourth data failed");
	    if (!fourth_rec_eq(read_data, &rec4)) {
		printf("Rec4 failure\n");
		fail++;
	    }
	    check_mem(size, (char*)read_data);
	    free(read_data);
	    fourth_rec_count[test_level]++;
	} else if (buffer_format == embedded_rec_ioformat) {
	    
	    printf("Emb Rec failure\n");
	    fail++;
	} else if (buffer_format == fifth_rec_ioformat) {
	    int size = size_func(iocontext, buffer, buf_size, sizeof(fifth_rec));
	    fifth_rec *read_data = get_mem(size);
	    memset(read_data, 0, size);
	    if (!decode_func(iocontext, buffer, buf_size, read_data))
		IOperror((IOFile)iocontext, "read fifth data failed");
	    if (!fifth_rec_eq(read_data, &rec5)) {
		printf("Rec5 failure\n");
		fail++;
	    }
	    check_mem(size, (char*)read_data);
	    free(read_data);
	    fifth_rec_count[test_level]++;
	} else if (buffer_format == sixth_rec_ioformat) {
	    int size = size_func(iocontext, buffer, buf_size, sizeof(sixth_rec));
	    sixth_rec *read_data = get_mem(size);
	    memset(read_data, 0, size);
	    if (!decode_func(iocontext, buffer, buf_size, read_data))
		IOperror((IOFile)iocontext, "read variant format");
	    if (!sixth_rec_eq(read_data, &rec6_array[sixth_rec_count[test_level]++])) {
		printf("Rec6 failure\n");
		fail++;
	    }
	    check_mem(size, (char*)read_data);
	    free(read_data);
	} else if (buffer_format == nested_rec_ioformat) {
	    int size = size_func(iocontext, buffer, buf_size, sizeof(nested_rec));
	    nested_rec *read_data = get_mem(size);
	    memset(read_data, 0, size);
	    if (!decode_func(iocontext, buffer, buf_size, read_data))
		IOperror((IOFile)iocontext, "read variant format");
	    if (!nested_rec_eq(read_data, &rec7_array[nested_rec_count[test_level]++])) {
		printf("Rec7 failure\n");
		fail++;
	    }
	    check_mem(size, (char*)read_data);
	    free(read_data);
	} else if (buffer_format == later_rec_ioformat) {
	    int size = size_func(iocontext, buffer, buf_size, sizeof(later_rec));
	    later_rec *read_data = get_mem(size);
	    memset(read_data, 0, size);
	    if (!decode_func(iocontext, buffer, buf_size, read_data))
		IOperror((IOFile)iocontext, "read variant format");
	    if (!later_rec_eq(read_data, &rec8_array[later_rec_count[test_level]++])) {
		printf("Rec8 failure\n");
		fail++;
	    }
	    check_mem(size, (char*)read_data);
	    free(read_data);
	} else if (buffer_format == ninth_rec_ioformat) {
	    int size = size_func(iocontext, buffer, buf_size, sizeof(ninth_rec));
	    ninth_rec *read_data = get_mem(size);
	    memset(read_data, 0, size);
	    if (!decode_func(iocontext, buffer, buf_size, read_data))
		IOperror((IOFile)iocontext, "read variant format");
	    if (!ninth_rec_eq(read_data, &rec9_array[ninth_rec_count[test_level]++])) {
		printf("Rec9 failure\n");
		fail++;
	    }
	    check_mem(size, (char*)read_data);
	    free(read_data);
	} else if (buffer_format == string_array_ioformat) {
	    int size = size_func(iocontext, buffer, buf_size, 
				 sizeof(string_array_rec));
	    string_array_rec *read_data = get_mem(size);
	    memset(read_data, 0, size);
	    if (!decode_func(iocontext, buffer, buf_size, read_data))
		IOperror((IOFile)iocontext, "read string array format");
	    if (!string_array_eq(read_data, 
				 &string_array_array[string_array_count[test_level]++])) {
		printf("string array failure\n");
		fail++;
	    }
	    check_mem(size, (char*)read_data);
	    free(read_data);
	} else {
	    printf("discarding a record\n");
	    unknown_rec_count[test_level]++;
	}
    } else {
	/* finished */
	if (test_level == 0) {
	    free_IOcontext(iocontext);
	}
/*	if (first_rec_count[test_level] != sizeof(rec1_array) / sizeof(rec1_array[0])) {*/
	if (first_rec_count[test_level] != 3) {
	    printf("Missed first\n");
	    fail++;
	}
	if (second_rec_count[test_level] != sizeof(rec2_array) / sizeof(rec2_array[0])) {
	    printf("Missed second\n");
	    fail++;
	}
	if (third_rec_count[test_level] != sizeof(rec3_array) / sizeof(rec3_array[0])) {
	    printf("Missed third\n");
	    fail++;
	}
	if (fourth_rec_count[test_level] != 1) {
	    printf("Missed fourth\n");
	    fail++;
	}
	if (fifth_rec_count[test_level] != 1) {
	    printf("Missed fifth\n");
	    fail++;
	}
	if (sixth_rec_count[test_level] != sizeof(rec6_array) / sizeof(rec6_array[0])) {
	    printf("Missed sixth\n");
	    fail++;
	}
	if (nested_rec_count[test_level] != sizeof(rec7_array) / sizeof(rec7_array[0])) {
	    printf("Missed nested\n");
	    fail++;
	}
	if (later_rec_count[test_level] != 3) {
	    printf("Missed later\n");
	    fail++;
	}
	if (unknown_rec_count[test_level] != 0) {
	    printf("Got unknown\n");
	    fail++;
	}
    }
}

static void
write_buffer(buf, size)
char *buf;
int size;
{
    static int file_fd = 0;
    unsigned short ssize;
    unsigned char csize;
    if (output_file == NULL) return;

    if (file_fd == 0) {
	file_fd = open(output_file, O_WRONLY|O_CREAT|O_TRUNC|O_BINARY, 0777);
    }
    ssize = size;
    csize = ssize & 0xff;
    write(file_fd, &csize, 1);	/* low byte of 2-byte size */
    csize = ((ssize >> 8) & 0xff);
    write(file_fd, &csize, 1);	/* high byte of 2-byte size */
    write(file_fd, buf, size);
}
