#include "io.h"
#include <stdio.h>



typedef struct _Subformat_list {
    char *format_name;
    IOFieldList field_list;
}SubFormatRec, *SubFormatList;

IOformat_order
do_compare(field_list1, subformat_list1, field_list2, subformat_list2)
IOFieldList field_list1;
SubFormatList subformat_list1;
IOFieldList field_list2;
SubFormatList subformat_list2;
{
    IOContext context1 = create_IOcontext();
    IOContext context2 = create_IOcontext();
    IOFormat format1, format2;
    IOformat_order result;
    
    if (subformat_list1 != NULL) {
	int i = 0;
	while (subformat_list1[i].format_name != NULL) {
	    IOFormat tmp;
	    tmp = register_IOcontext_format(subformat_list1[i].format_name,
					    subformat_list1[i].field_list,
					    context1);
	    if (tmp == NULL) {
		fprintf(stderr, "Format registration failed for subformat \"%s\" under format \"%s\"\n",
			subformat_list1[i].format_name, "format1");
		return Format_Incompatible;
	    }
	    i++;
	}
    }
    format1 = register_IOcontext_format("format1", field_list1,	context1);

    if (subformat_list2 != NULL) {
	int i = 0;
	while (subformat_list2[i].format_name != NULL) {
	    IOFormat tmp;
	    tmp = register_IOcontext_format(subformat_list2[i].format_name,
					    subformat_list2[i].field_list,
					    context2);
	    if (tmp == NULL) {
		fprintf(stderr, "Format registration failed for subformat \"%s\" under format \"%s\"\n",
			subformat_list2[i].format_name, "format2");
		return Format_Incompatible;
	    }
	    i++;
	}
    }
    format2 = register_IOcontext_format("format2", field_list2,	context2);
    result = IOformat_cmp(format1, format2);
    free_IOcontext(context1);
    free_IOcontext(context2);
    return result;
}

int
main()
{
    {
	IOField field_list1[] = {
	    {"integer field", "integer", 
	     sizeof(int), 0},
	    {"double field", "float",
	     sizeof(double), 10},
	    {"char field", "char",
	     sizeof(char), 20},
	    { NULL, NULL, 0, 0}
	};
	IOField field_list2[] = {
	    {"integer field", "integer", 
	     sizeof(int), 0},
	    {"double field", "float",
	     sizeof(double), 10},
	    {"char field", "char",
	     sizeof(char), 20},
	    { NULL, NULL, 0, 0}
	};
	IOField bigger_field_list[] = {
	    {"integer field", "integer", 
	     sizeof(int), 0},
	    {"double field", "float",
	     sizeof(double), 10},
	    {"double field2", "float",
	     sizeof(double), 20},
	    {"char field", "char",
	     sizeof(char), 30},
	    { NULL, NULL, 0, 0}
	};
	IOField bigger_field_list2[] = {
	    {"integer field", "integer", 
	     sizeof(int), 0},
	    {"double field", "float",
	     sizeof(double), 10},
	    {"zdouble field2", "float",
	     sizeof(double), 20},
	    {"char field", "char",
	     sizeof(char), 30},
	    { NULL, NULL, 0, 0}
	};
	IOField fabians_list1[] = {
	    {"astring", "string", 4, 0},
	    {"sum", "float", 8, 8},
	    { NULL, NULL, 0, 0}
	};

	IOField fabians_list2[] = {
	    {"astring", "string", 4, 0},
	    {"double_array", "float[icount]", 8, 8},
	    {"icount", "integer", 4, 4},
	    { NULL, NULL, 0, 0}
	};

	if (do_compare(field_list1, NULL, field_list2, NULL) !=
	    Format_Equal) {
	    printf("Equality failed\n");
	}
	if (do_compare(field_list1, NULL, bigger_field_list, NULL) !=
	    Format_Less) {
	    printf("Less failed\n");
	}
	if (do_compare(bigger_field_list, NULL, field_list2, NULL) !=
	    Format_Greater) {
	    printf("Greater failed\n");
	}
	if (do_compare(field_list1, NULL, bigger_field_list2, NULL) !=
	    Format_Less) {
	    printf("Less failed\n");
	}
	if (do_compare(bigger_field_list2, NULL, field_list2, NULL) !=
	    Format_Greater) {
	    printf("Greater failed\n");
	}
	if (do_compare(bigger_field_list2, NULL, bigger_field_list, NULL) !=
	    Format_Incompatible) {
	    printf("Incompatible failed\n");
	}
	if (do_compare(fabians_list1, NULL, fabians_list2, NULL) !=
	    Format_Incompatible) {
	    printf("Incompatible2 failed\n");
	}
    }
    /* try some where subformats differ */
    {
	IOField complex_field_list[] = {
	    {"ifield", "integer", sizeof(int), 0},
	    {"rfield", "integer", sizeof(int), 10},
	    { NULL, NULL, 0, 0}
	};
	IOField big_complex_field_list[] = {
	    {"ifield", "integer", sizeof(int), 0},
	    {"rfield", "integer", sizeof(int), 10},
	    {"extra", "integer", sizeof(int), 20},
	    { NULL, NULL, 0, 0}
	};
	IOField different_complex_field_list[] = {
	    {"jfield", "integer", sizeof(int), 0},
	    {"rfield", "integer", sizeof(int), 10},
	    {"extra", "integer", sizeof(int), 20},
	    { NULL, NULL, 0, 0}
	};
	IOField field_list1[] = {
	    {"integer field", "integer", 
	     sizeof(int), 0},
	    {"double field", "float",
	     sizeof(double), 10},
	    {"char field", "char",
	     sizeof(char), 20},
	    {"complex field", "complex",
	     sizeof(char), 40},
	    { NULL, NULL, 0, 0}
	};
	IOField field_list2[] = {
	    {"integer field", "integer", 
	     sizeof(int), 0},
	    {"double field", "float",
	     sizeof(double), 10},
	    {"char field", "char",
	     sizeof(char), 20},
	    {"complex field", "complex",
	     sizeof(char), 40},
	    { NULL, NULL, 0, 0}
	};
	IOField bigger_field_list[] = {
	    {"integer field", "integer", 
	     sizeof(int), 0},
	    {"double field", "float",
	     sizeof(double), 10},
	    {"double field2", "float",
	     sizeof(double), 20},
	    {"char field", "char",
	     sizeof(char), 30},
	    {"complex field", "complex",
	     sizeof(char), 40},
	    { NULL, NULL, 0, 0}
	};
	IOField bigger_field_list2[] = {
	    {"integer field", "integer", 
	     sizeof(int), 0},
	    {"double field", "float",
	     sizeof(double), 10},
	    {"zdouble field2", "float",
	     sizeof(double), 20},
	    {"char field", "char",
	     sizeof(char), 30},
	    {"complex field", "complex",
	     sizeof(char), 40},
	    { NULL, NULL, 0, 0}
	};
	SubFormatRec complex_list[] = {
	    {"complex", NULL},
	    {NULL, NULL}};
	SubFormatRec big_complex_list[] = {
	    {"complex", NULL},
	    {NULL, NULL}};
	SubFormatRec different_complex_list[] = {
	    {"complex", NULL},
	    {NULL, NULL}};
	complex_list[0].field_list = &complex_field_list[0];
	big_complex_list[0].field_list = &big_complex_field_list[0];
	different_complex_list[0].field_list = &different_complex_field_list[0];
	
	/* subformats always equal for this group */
	if (do_compare(field_list1, complex_list, field_list2, complex_list) !=
	    Format_Equal) {
	    printf("Equality failed\n");
	}
	if (do_compare(field_list1, complex_list, bigger_field_list, complex_list) !=
	    Format_Less) {
	    printf("Less failed\n");
	}
	if (do_compare(bigger_field_list, complex_list, field_list2, complex_list) !=
	    Format_Greater) {
	    printf("Greater failed\n");
	}
	if (do_compare(bigger_field_list2, complex_list, bigger_field_list, complex_list) !=
	    Format_Incompatible) {
	    printf("Incompatible failed\n");
	}

	/* where subformats affect results */
	if (do_compare(field_list1, complex_list, field_list2, big_complex_list) !=
	    Format_Less) {
	    printf("Sub Less1 failed\n");
	}
	if (do_compare(field_list1, big_complex_list, field_list2, complex_list) !=
	    Format_Greater) {
	    printf("Sub Greater1 failed\n");
	}
	if (do_compare(field_list1, different_complex_list, field_list2, complex_list) !=
	    Format_Incompatible) {
	    printf("Sub Incompat1 failed\n");
	}
	if (do_compare(field_list1, complex_list, field_list2, different_complex_list) !=
	    Format_Incompatible) {
	    printf("Sub Incompat2 failed\n");
	}

	/* field list 2 bigger in these 4 */
	if (do_compare(field_list1, complex_list, bigger_field_list, complex_list) !=
	    Format_Less) {
	    printf("Less failed\n");
	}
	if (do_compare(field_list1, complex_list, bigger_field_list, big_complex_list) !=
	    Format_Less) {
	    printf("Sub Less2 failed\n");
	}
	if (do_compare(field_list1, different_complex_list, bigger_field_list, big_complex_list) !=
	    Format_Incompatible) {
	    printf("Sub Incompat failed\n");
	}
	if (do_compare(field_list1, big_complex_list, bigger_field_list, complex_list) !=
	    Format_Incompatible) {
	    printf("Sub Incompat failed\n");
	}

	/* field list 1 bigger in these 4 */
	if (do_compare(bigger_field_list, complex_list, field_list2, complex_list) !=
	    Format_Greater) {
	    printf("Greater failed\n");
	}
	if (do_compare(bigger_field_list, big_complex_list, field_list2, complex_list) !=
	    Format_Greater) {
	    printf("Greater failed\n");
	}
	if (do_compare(bigger_field_list, big_complex_list, field_list2, different_complex_list) !=
	    Format_Incompatible) {
	    printf("Incompat failed\n");
	}
	if (do_compare(bigger_field_list, complex_list, field_list2, big_complex_list) !=
	    Format_Incompatible) {
	    printf("SUb Incompat failed\n");
	}

    }
}
