
/* sort binary file */

#include <stdio.h>
#include <fcntl.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#ifdef HAVE_SYS_UIO_H
#include <sys/uio.h>
#endif
#include "io.h"
#include "io_interface.h"
#include "io_internal.h"
#include "unix_defs.h"

IOFieldPtr *iofields = NULL;
IOConversionPtr *ioconvs = NULL;
IOFormat *out_formats = NULL;
static int max_format = 0;

extern void
new_format_processing(format, format_num, file_out, file_in, format_name)
IOFormat format;
IOFile file_out, file_in;
char *format_name;
{
    IOFieldList field_list = copy_field_list(field_list_of_IOformat(format));
    int index = index_of_IOformat(format);
    if (format_num > max_format) {
	max_format = format_num;
    }
    iofields = (IOFieldPtr *) realloc(iofields,
				      sizeof(IOFieldPtr) * (1+ max_format));
    ioconvs = (IOConversionPtr *) 
	realloc(ioconvs, sizeof(IOConversionPtr) * (1+max_format));

    if (version_of_IOfile(file_in) < 3) {
	int field;
	for (field = 0; field < format->field_count; field++) {
	    int dimen1, dimen2;
	    IOdata_type  base_type = 
		array_str_to_data_type(field_list[field].field_type,
				       &dimen1, &dimen2);
	    if ((base_type != unknown_type) &&
		(field_list[field].field_size > 16)) {
		field_list[field].field_size /= (dimen1 * dimen2);
	    }
	}
    }

    out_formats = (IOFormat *) realloc(out_formats,
				       sizeof(IOFormat) * (1+max_format));
    set_IOconversion(file_in, format_name,
		     field_list,
		     struct_size_IOfield(file_in, field_list));
    set_notify_of_format_change(file_in, format_name, 1);

    out_formats[index] =
	register_IOrecord_format(format_name,
				 field_list,
				 file_out);
}

IOFormat vec_ioformat = NULL;

extern int
cp_iofile(file_in_name, file_out_name)
char *file_in_name, *file_out_name;
{
    IOFile file_in, file_out;
    int i;
    int format_count;
    int finished = FALSE;
    IOFormat next_format;

    if (!(file_in = open_IOfile(file_in_name, "r"))) {
	fprintf(stderr, "cannot open file %s\n", file_in_name);
	return -1;
    }
    if (!(file_out = open_IOfile(file_out_name, "w"))) {
	fprintf(stderr, "cannot open file %s\n", file_out_name);
	return -1;
    }
    
    iofields = (IOFieldPtr *) malloc(sizeof(IOFieldPtr) * 10);
    ioconvs = (IOConversionPtr *) malloc(sizeof(IOConversionPtr) * 10);
    out_formats = (IOFormat *) malloc(sizeof(IOFormat) * 10);

    format_count = 0;

    for(i = 0; i < file_in->reg_format_count; i++) {
	IOFormat ioformat = file_in->format_list[i];
	int j;
	for (j=0; j < ioformat->field_count; j++) {
	    if (strcmp(ioformat->field_list[j].field_type, 
		       "R3vector") == 0) {
		int k;
		for (k=i; k < file_in->reg_format_count; k++) {
		    /* find R3vector in list*/
		    if (strcmp(file_in->format_list[k]->format_name, 
		       "R3vector") == 0) {
			new_format_processing(file_in->format_list[k], k, 
					      file_out, file_in, 
					      "R3vector"); 
		    }			
		}
	    }
	}
	new_format_processing(ioformat, i, file_out, file_in, 
			      name_of_IOformat(ioformat));
    }

/*** read all records in the input file ***/
    while (!finished) {
	IOFormat format;
	char *format_name;
	char *comment;
	int index, data_size;

	switch (next_IOrecord_type(file_in)) {
	case IOcomment:
	    /* no sorting of comments, just write out */
	    comment = read_comment_IOfile(file_in);
	    if (comment)
		write_comment_IOfile(file_out, comment);
	    break;
	case IOformat:
	    format = read_format_IOfile(file_in);
	    format_name = name_of_IOformat(format);
	    index = index_of_IOformat(format);
	    new_format_processing(format, ++format_count, file_out,
				  file_in, format_name);
	    break;
	case IOdata:
	{
	    void *data;
	    int in_index;
	    next_format = next_IOrecord_format(file_in);
	    in_index = index_of_IOformat(next_format);
	    data_size = next_IOrecord_length(file_in);
	    data = (char *) malloc(data_size);

	    read_IOfile(file_in, data);
	    write_IOfile(file_out, out_formats[in_index], data);
	    break;
	}
	case IOerror:
	case IOend:
	    finished++;
	    break;
	}

    }

    close_IOfile(file_in);
    close_IOfile(file_out);
    return 0;
}


static char *usage =
"Usage:  IOcp <input file> <out file>\n";

void
main(argc, argv)
int argc;
char *argv[];
{
    char *infile, *outfile;

    if (argc == 3) {
	infile = argv[1];
	outfile = argv[2];
    } else {
	fprintf(stderr, usage);
	exit(1);
    }

    cp_iofile(infile, outfile);
}
