#ifndef OTL_THREAD_H
#define OTL_THREAD_H

#ifdef USE_CTHREADS
#include <cthread.h>
#endif
#ifdef USE_PTHREADS
#include <pthread.h>
#define cthread_start(n) 
#define cthread_fork(func,arg,dest) pthread_fork_wrap(func, arg)
#define cthread_set_in_schedule_func(n) pthread_schedule_io_thread(n)
#define cthread_detach(thrd) 
#define mutex_alloc(mutex, loc) pthread_mutex_init(mutex, NULL)
#define mutex_free(mutex) pthread_mutex_destroy(&mutex)
#define mutex_lock(mutex) pthread_mutex_lock(&mutex)
#define mutex_unlock(mutex) pthread_mutex_unlock(&mutex)
#define condition_alloc(cond, loc) pthread_cond_init(cond, NULL)
#define condition_free(cond) pthread_cond_destroy(&cond)
#define condition_wait(cond, mutex) pthread_cond_wait(&cond, &mutex)
#define condition_signal(cond) pthread_cond_signal(&cond)
#define condition_t pthread_cond_t
#define cthread_parse_args(argc,argv) argc
#define mutex_t pthread_mutex_t
#define cthread_t pthread_t
#define any_t void*
#define T_SUCCEED 0

static pthread_t
pthread_fork_wrap(func, arg)
void *(func)(void*);
void *arg;
{
    pthread_t new_thread = NULL;
    if (pthread_create(&new_thread, NULL, func, arg) != 0) {
	return NULL;
    } else {
	return new_thread;
    }
}
#endif

extern void fork_io_handler();
#endif
