typedef struct _handle_struct {
    attr_list cache;
    DEPort dep;
    void (*dispatch_addr) ();
    void *self;
    void *msg_block;  /* DE message buffer to return later */
    void *free_block;  /* block to free when call completes */
    void *pblock;
    int  plen;
    void *local_pb;
    int  local_pb_size;
    IOEncodeVector pvector;
    int  pveclen;
    int  wait_count;
    int  terminated;
    attr_value orig_handle;
    attr_list this_invoke_attrs;
    thr_mutex_t handle_lock;
    thr_condition_t wait_condition;
    int  de_condition;
    int ref_count;
    CORBA_Environment ev;
    void *return_block;
    int return_block_len;
    void *stack_internal_return;
    IOEncodeVector rvector;
    int rvector_len;
    void (*termination_handler)(otl_handle, void*);
    void *termination_data;
} otl_handle_structure;

extern otl_handle get_otl_handle();

extern void
fill_xmit_obj ARGS((xmit_object_ref xmit, attr_list object));

extern void
free_xmit_obj ARGS((xmit_object_ref xmit));

extern attr_list
attr_list_from_xmit ARGS((xmit_object_ref xmit));

extern void
otl_get_attr ARGS((atom_t attr, attr_value_type typ, 
		   attr_value *value_p, attr_list list,
		   attr_value (*set_function)(), attr_list cache_list));

extern void
add_to_attr_list_from_xmit_obj ARGS((attr_list list, xmit_object_ref
				     xmit_obj));

extern void
otl_handle_invocation ARGS((attr_list this_invoke_attrs, otl_handle handle));

extern void
do_call_termination ARGS((otl_handle handle));

#define OUR_IIOP_VERSION 1
