
#include "io.h"
#include "atom.h"
#include "attr.h"
#include "otl_formats.h"

IOField COBS_connect_msg_flds[] =
{
    {"server name", "string",
     sizeof(char *), IOOffset(connect_msg_p, server_name)},
    {"host name", "string",
     sizeof(char *), IOOffset(connect_msg_p, hostname)},
    {"port number", "integer",
     sizeof(int), IOOffset(connect_msg_p, port)},
    {NULL, NULL, 0, 0}
};

IOField COBS_xmit_attr_flds[] =
{
    {"attr name", "integer",
     sizeof(atom_t), IOOffset(xmit_attr_ref, attr_name)},
    {"attr type", "integer",
     sizeof(attr_value_type), IOOffset(xmit_attr_ref, attr_type)},
    {"attr atom value", "integer",
     sizeof(atom_t), IOOffset(xmit_attr_ref, attr_atom_val)},
    {"opaque_len", "integer",
     sizeof(int), IOOffset(xmit_attr_ref, opaque_len)},
    {"opaque_buffer", "char[opaque_len]",
     1, IOOffset(xmit_attr_ref, opaque_buffer)},
    {NULL, NULL, 0, 0}
};

IOField COBS_xmit_obj_flds[] =
{
    {"attr count", "integer",
     sizeof(int), IOOffset(xmit_object_ref, attr_count)},
    {"attr array", "xmit_attr[attr count]",
     sizeof(xmit_attr), IOOffset(xmit_object_ref, attrs)},
    {NULL, NULL, 0, 0}
};

IOField COBS_init_msg_flds[] =
{
    {"initial_obj", "xmit_obj",
     sizeof(xmit_object), IOOffset(init_msg_p, initial_object)},
    {"first message flag", "integer",
     sizeof(int), IOOffset(init_msg_p, first_msg_flag)},
    {"condition", "integer",
     sizeof(int), IOOffset(init_msg_p, condition)},
    {"star connect", "integer",
     sizeof(int), IOOffset(init_msg_p, star_connect)},
    {"chan id", "string",
     sizeof(char *), IOOffset(init_msg_p, chan_id)},
    {NULL, NULL, 0, 0}
};

IOField COBS_param_vec_elem_flds[] =
{
    {"len", "integer", sizeof(((IOEncodeVector)0)[0].iov_len), 
     IOOffset(IOEncodeVector, iov_len)},
    {"elem", "char[len]", sizeof(char), IOOffset(IOEncodeVector,iov_base)},
    {(char *) 0, (char *) 0, 0, 0}
};

IOField COBS_invoke_msg_flds[] =
{
    {"target_obj", "xmit_obj",
     sizeof(xmit_object), IOOffset(invoke_msg_p, target)},
    {"target_method", "xmit_obj",
     sizeof(xmit_object), IOOffset(invoke_msg_p, method)},
    {"pveclen", "integer",
       sizeof(int), IOOffset(invoke_msg_p, pveclen)},
    {"parameter vector", "vec_elem[pveclen]",
       sizeof(struct _io_encode_vec), IOOffset(invoke_msg_p, pvector)},
    {"handle", "integer",
       sizeof(attr_value), IOOffset(invoke_msg_p, handle)},
    {NULL, NULL, 0, 0}
};

IOField COBS_invoke_return_msg_flds[] =
{
    {"handle", "integer",
     sizeof(attr_value), IOOffset(invoke_return_msg_p, handle)},
    {"cache", "xmit_obj",
       sizeof(xmit_object), IOOffset(invoke_return_msg_p, cache)},
    {"rveclen", "integer",
       sizeof(int), IOOffset(invoke_return_msg_p, rveclen)},
    {"return vector", "vec_elem[rveclen]",
       sizeof(struct _io_encode_vec), IOOffset(invoke_return_msg_p, rvector)},
    {NULL, NULL, 0, 0}
};
