
#ifndef OTL_H
#define OTL_H
#ifdef	__cplusplus
extern "C" {
#endif
#include "atom.h"
#include "attr.h"
#include "io.h"

#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus)
#ifndef ARGS
#define ARGS(args) args
#endif
#ifndef	NULL
#define NULL	((void *) 0)
#endif
#else
#ifndef ARGS
#define ARGS(args) (/*args*/)
#endif
#ifndef	NULL
#define NULL	0
#endif
#endif

typedef struct _object_ref {
    /* attributes which name object globally */
  attr_list obj_name;
    /* caches meaning of name in local context */
  attr_list name_trans_cache;
    /* method specific attribute cache */
  attr_list method_specific_cache;
} object_ref_struct, *object_ref;

typedef object_ref (*init_obj_func)();

extern object_ref
init_cobs ARGS(( char *in_app_name, init_obj_func init_func));

#ifdef __DATAEXCHANGE__H__
extern object_ref
init_cobs_DE ARGS(( char *in_app_name, init_obj_func init_func, DExchange de));
#endif

extern void set_cobs_group_duration ARGS(( int seconds));

extern object_ref
contact_cobs_group ARGS((char *in_app_name));

extern void shutdown_cobs();

extern void cobs_poll();

extern void cobs_blocking_poll();

/* opaque type for completion handle */
typedef struct _handle_struct *otl_handle;

/* perform an rpc, sync or async, simple or return */
extern otl_handle otl_invoke ARGS((attr_list object, attr_list name_cache,
				   attr_list method_cache, char *pblock, 
				   int plen));


typedef struct obj_info_s *otl_class_info;

extern otl_handle otl_invokev ARGS((attr_list object, attr_list name_cache,
				    attr_list method_cache, otl_class_info obj_info, 
				    IOEncodeVector pvector,
				    void *local_pb, int pb_size));


extern void otl_do_call_termination ARGS((otl_handle handle));

extern void otl_copy_local_pb ARGS((void **p, otl_handle handle));

/* return true if object is local */
extern int otl_is_local_object ARGS((attr_list obj_name,
				     attr_list name_cache));

extern int
otl_direct_call ARGS((attr_list obj_name, attr_list method_cache));

extern object_ref otl_local_obj_ref();

extern void otl_wait ARGS((otl_handle handle));

extern void otl_free_handle ARGS((otl_handle handle));

extern void otl_free_obj_ref ARGS((object_ref obj));

extern attr_list otl_get_cache ARGS((otl_handle handle));

extern attr_list otl_get_name ARGS((otl_handle handle));

extern void
otl_get_return_block ARGS((otl_handle handle, void** block_p, int
			   *block_len_p));

extern void
otl_set_return_vector ARGS((otl_handle handle, void *internal_stack_return,
			    IOEncodeVector rvector, void *free_block));

extern char *
obj_ref_to_string ARGS((object_ref obj));

extern char *
obj_ref_to_iiop ARGS((object_ref obj));

extern char *
obj_ref_to_ior ARGS((object_ref obj));

extern object_ref
obj_ref_from_string ARGS((char *str));

extern object_ref new_object_ref();

extern object_ref copy_object_ref(object_ref);

#ifdef __I_O__
typedef struct _format_list {
    char *format_name;
    IOFieldList field_list;
} otl_list_of_formats;

extern void
otl_set_pbio_type ARGS((IOFormat *format, char *type_string,
			IOFieldList fields));

extern void
otl_set_pbio_types ARGS((void *encoded_buffer,
			 otl_list_of_formats *format_list));

extern void*
otl_pbio_type_encode ARGS((IOFormat format, void *data, int *len_return));

extern IOEncodeVector
otl_pbio_type_encodev ARGS((IOFormat format, void *data, void **free_block));

extern void*
otl_pbio_type_encode_to_buffer ARGS((IOFormat format, void *data,
				     void **buffer, int *len_return));

extern void*
otl_pbio_type_decode ARGS((void *data, int len_return));

extern void
otl_pbio_decode ARGS((void *data, int data_len, void *dest));

extern int otl_check_conversion ARGS((void *encoded_block));
#endif

typedef object_ref CORBA_Object;

typedef attr_list CORBA_Context;

typedef enum {
    CORBA_NO_EXCEPTION, CORBA_USER_EXCEPTION, CORBA_SYSTEM_EXCEPTION
} CORBA_exception_type;

typedef struct {
  attr_list op_attr_list;     /* so far the environment is only 
				 attributes that the user may pass to
				 the operation. If this change, it is
				 very likely that the part of the pb
				 generation for remote invocations
				 (code_for_remote_operations.c) will
				 have to incorporate this changes */
    CORBA_exception_type _major;
    char *_minor;
    void *exception_data;
    void *instanceData;
    void **instanceDataSaveAddr;
} CORBA_Environment;

extern void
otl_get_exception ARGS((otl_handle handle, CORBA_Environment *ev));

extern void
CORBA_exception_set(CORBA_Environment *ev, CORBA_exception_type major,
		    char *except_repos_id, void *param);

extern char *CORBA_exception_id(CORBA_Environment *ev);
extern void *CORBA_Exception_value(CORBA_Environment *ev);
extern void CORBA_Exception_free(CORBA_Environment *ev);
    
#define CORBA_alloc     COBS_alloc
#define CORBA_realloc   COBS_realloc
#define CORBA_free      COBS_free

extern CORBA_Environment *otl_ev_handle ARGS((otl_handle handle));

extern void *COBS_alloc ARGS((int size));
extern void *COBS_realloc ARGS((void* ptr, int size));
extern void COBS_free ARGS((void* mem));

/* The following structure is *VERY* dependent on the structure
   generated for sequences  in IDLtoC. IT HAS TO MIMIM the same order of
   fields. I will do this clearner one of these days, ie, interface 
   description should incorporate this order too.
   */
typedef struct {
  unsigned long  _maximum;
  unsigned long  _length;
  void      *_buffer;
} COBS_sequence, COBS_generic_sequence_struct;

char *COBS_return_string ARGS((char *st, int st_maximum));

void COBS_assign_string ARGS((char **stto, char *stfrom, int st_maximum));

void COBS_assign_sequence ARGS((COBS_sequence *left_side,
				COBS_sequence *right_side,
				int basetypesize));


void COBS_init_sequence ARGS((COBS_sequence *seq, 
			      long maximum, int basetypesize));


void _COBS_support_for_IDL_context ARGS((CORBA_Context op_context,
					 CORBA_Context ob_context,
					 char *name_in_context));

/* make COBS_create_IDL_context a macro, since it is just an alias
   for OTL support for attribute lists */
#define COBS_create_IDL_context create_attr_list

extern void COBS_create_Environment_object ARGS((CORBA_Environment **ev));

extern void COBS_init_Environment_object ARGS((CORBA_Environment *ev));

extern void COBS_free_Environment_object ARGS((CORBA_Environment *ev));

char _COBS_is_this_obj_local ARGS((CORBA_Object o));

int otl_protocol_invoke ARGS((attr_list obj_name));

typedef struct array_info_s {
    int  type_code;
    char *name;
    int  static_flag;
    long tc_base_type;
    long array_size;
} array_info, *array_info_p;

typedef struct type_info_s {
    char *name;
    IOField *field_list;
    long *iiop_info;
} *type_info_p;

typedef struct method_info_s {
    char *name;
    IOField	*input_fields;
    long *iiop_info;
    IOField	*return_fields;
    long *iiop_return_info;
} method_info;

typedef struct obj_info_s {
    void (**vf_table)();
    type_info_p type_info_table;
    attr_list base_reference;
    method_info *methods;
} otl_obj_info;

typedef struct _CORBA_any { 
    void *_type;/* really CORBA_TypeCode */
    void *_value;
    int _length;
} CORBA_any;

#ifdef __DATAEXCHANGE__H__
void MOSS_Init ARGS((char *group_name, DExchange de));
#endif
void MOSS_add_class ARGS((char *obj_class, void* create_func, 
			  void* update_func));
extern void otl_mon_register_object ARGS((char *obj_class, char *obj_ref,
					  char *chan_id));

#ifdef	__cplusplus
	   }
#endif
#endif

