
#include "config.h"

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <assert.h>
#include <memory.h>

#include "gen_thread.h"
#include "io.h"
#include "DE.h"
#include "otl.h"
#include "comm_group.h"
#include "otl_formats.h"
#include "otl_obj.h"

#include "unix_defs.h"

static int connect_format_id = -1;
static int init_format_id = -1;

DExchange otl_private_de;
int otl_private_shutdown_flag = 0;
thr_mutex_t otl_private_type_lock;
IOContext otl_private_type_context;
int OTL_verbose = 0;
int iiop_verbose = 0;
int otl_debug = 0;
extern void init_type_context();

typedef struct server_struct {
    char *host_name;
    int port;
    char *in_app_name;
    int connection_fd;
    DEPort dep;
    object_ref COBS_init_object;
} server_s, *server_p;


static server_p server_list = NULL;
static thr_mutex_t server_list_lock;
object_ref COBS_init_object = NULL;
static char *master_chan_id = NULL;
ECSourceHandle master_handle = NULL;
extern void otl_mon_subscribe_handler(int subscribe, int subscribe_count,
				      void *client_data);

static
int
add_server_to_list(dep, host_name, port)
DEPort dep;
char *host_name;
int port;
{
    int server_count = 0;
    while ((server_list[server_count].host_name != NULL) &&
	   ((strcmp(server_list[server_count].host_name, host_name) != 0)
	       || (port != server_list[server_count].port))) {
	server_count++;
    }

    if (server_list[server_count].host_name == NULL) {
	/* reached the end of the list */
	server_list = (server_p) realloc(server_list,
					 sizeof(server_s) * (server_count +2));
	server_list[server_count + 1].host_name = NULL;
	server_list[server_count + 1].port = 0;
	server_list[server_count + 1].in_app_name = NULL;
	server_list[server_count + 1].connection_fd = -1;
	server_list[server_count + 1].dep = NULL;
	server_list[server_count + 1].COBS_init_object = NULL;
    }
    if (server_list[server_count].host_name == NULL) {
	server_list[server_count].host_name = strdup(host_name);
	server_list[server_count].port = port;
	server_list[server_count + 1].COBS_init_object = NULL;
    }
    if (dep != NULL) {
	server_list[server_count].connection_fd =
	    file_id_IOfile(DEport_from_port(dep));
    }
    server_list[server_count].dep = dep;
    return server_count;
}

static
 server_p
create_initial_server_list(in_app_name, de)
char *in_app_name;
DExchange de;
{
    server_p list = (server_p) malloc(sizeof(server_s) * 2);

    server_list_lock = thr_mutex_alloc();
	    
    list[0].host_name = strdup(DExchange_host_name(de));
    list[0].port = DExchange_inet_port(de);
    list[0].in_app_name = (in_app_name == NULL) ? NULL : strdup(in_app_name);
    list[0].connection_fd = -1;
    list[0].dep = NULL;
    list[0].COBS_init_object = NULL;
    list[1].host_name = NULL;
    list[1].port = 0;
    list[1].in_app_name = NULL;
    list[1].connection_fd = 0;
    list[1].dep = NULL;
    list[1].COBS_init_object = NULL;
    return list;
}

static
int
handle_init_msg(de, dep, format_id, data, record_len, client_data)
DExchange de;
DEPort dep;
int format_id;
void *data;
int record_len;
void *client_data;
{
    int i = 0;
    connect_msg conn;
    init_msg contact_msg;
    init_msg tmp_msg = *((init_msg_p)data);
    init_msg_p incoming_msg = &tmp_msg;
    static atom_t otl_dep = 0;
    int server_id = -1;
    char *host_name = DEport_host_name(dep);

    if (incoming_msg->chan_id) {
	incoming_msg->chan_id = strdup(incoming_msg->chan_id);
    }
    if (otl_debug) {
	printf("Got an initmsg from %s, port %d\n", DEport_host_name(dep),
	    DEport_port_number(dep));
    }
    if (otl_dep == 0) {
	otl_dep = attr_atom_from_string("OTL:DEP");
    }
    i = 0;
    thr_mutex_lock(server_list_lock);
    while (server_list[i].host_name != NULL) {
	if ((strcmp(host_name, server_list[i].host_name) == 0) && 
	    (DEport_port_number(dep) == server_list[i].port)) {
	    if (otl_debug) {
		printf("Whoa, got a duplicate connection! %s, %d\n", 
		       host_name, DEport_port_number(dep));
	    }
	    server_id = i;
	}
	i++;
    }
    if (server_id == -1) {
	server_id = add_server_to_list(dep, host_name, 
				       DEport_port_number(dep));
    }
    thr_mutex_unlock(server_list_lock);

    if (COBS_init_object == NULL) {
	COBS_init_object = new_object_ref();
	COBS_init_object->obj_name = attr_list_from_xmit(&incoming_msg->initial_object);
	COBS_init_object->name_trans_cache = create_attr_list();
	COBS_init_object->method_specific_cache = create_attr_list();
	if (incoming_msg->chan_id) {
	    master_chan_id = strdup(incoming_msg->chan_id);
	}
    } else {
	if (server_list[server_id].COBS_init_object == NULL) {
	    server_list[server_id].COBS_init_object = new_object_ref();
	    server_list[server_id].COBS_init_object->obj_name = 
		attr_list_from_xmit(&incoming_msg->initial_object);
	    server_list[server_id].COBS_init_object->name_trans_cache = 
		create_attr_list();
	    server_list[server_id].COBS_init_object->method_specific_cache = 
		create_attr_list();
	}
    }

    if (incoming_msg->first_msg_flag == 1) {
	if (COBS_init_object != NULL) {
	    fill_xmit_obj(&contact_msg.initial_object, COBS_init_object->obj_name);
	} else {
	    fill_xmit_obj(&contact_msg.initial_object, NULL);
	}
	/* just return the condition, don't do anything here */
	contact_msg.first_msg_flag = 0;
	contact_msg.condition = incoming_msg->condition;
	contact_msg.star_connect = 0;
	contact_msg.chan_id = master_chan_id;
	DEport_write_data(dep, init_format_id, &contact_msg);
	free_xmit_obj(&contact_msg.initial_object);
    } else {
	DECondition_signal(otl_private_de, incoming_msg->condition);
    }
    if (incoming_msg->star_connect) {
	/* tell everyone to connect to this guy too... */
	conn.hostname = DEport_host_name(dep);
	conn.port = DEport_port_number(dep);
	/* skip the lock as this might be called as a 
	   callback in our own initiate connection */
	DExchange_forward_data(otl_private_de, NULL, connect_format_id, &conn);

    }
    if (otl_debug) {
	printf("Server list is now :");
	i = 0;
	while (server_list[i].host_name != NULL) {
	    printf("%s - %d, ", server_list[i].host_name, server_list[i].port);
	    i++;
	}
	printf("\n");
    }
    if (incoming_msg->chan_id) free(incoming_msg->chan_id);
    return 0;
}

static
int
handle_invoke_msg(de, dep, format_id, data, record_len, client_data)
DExchange de;
DEPort dep;
int format_id;
void *data;
int record_len;
void *client_data;
{
    attr_list obj_name;
    invoke_msg_p msg = (invoke_msg_p) data;
    otl_handle handle;

    if (otl_debug) {
	printf("Got an invoke message from %s\n", DEport_name(dep));
    }
    obj_name = attr_list_from_xmit(&msg->target);
    handle = get_otl_handle();
    handle->cache = attr_list_from_xmit(&msg->method);

    handle->dep = dep;
    handle->wait_count = 0;
    handle->orig_handle = msg->handle;

    /* msg data buffer will be returned when call completes */
    DEtake_buffer(otl_private_de, msg);
    handle->msg_block = msg;

    if (msg->pvector != NULL) {
	int i = 0, plen = 0;
	/* param vector made contiguous by function of PBIO send */
	handle->pblock = msg->pvector[0].iov_base;
	for (i=0; i<msg->pveclen; i++) {
	    plen += msg->pvector[i].iov_len;
	}
	handle->plen = plen;
    } else {
	handle->pblock = NULL;
	handle->plen = 0;
    }
    handle->ref_count = 1;
    otl_handle_invocation(obj_name, handle);
    free_attr_list(obj_name);
    return 0;
}

static
int
handle_invoke_return_msg(de, dep, format_id, data, record_len, client_data)
DExchange de;
DEPort dep;
int format_id;
void *data;
int record_len;
void *client_data;
{
    invoke_return_msg_p msg = (invoke_return_msg_p) data;
    otl_handle handle = msg->handle;

    if (handle->cache != NULL ) {
	add_to_attr_list_from_xmit_obj(handle->cache, &(msg->cache));
    }
    if ((msg->rvector != NULL) && (handle->cache != NULL)) {
	int i = 0, rlen = 0;
	/* param vector made contiguous by function of PBIO send */
	for (i=0; i<msg->rveclen; i++) {
	    rlen += msg->rvector[i].iov_len;
	}
	handle->return_block = msg->rvector[0].iov_base;
	handle->return_block_len = rlen;

	/* msg data buffer will be returned when handle is freed */
	handle->msg_block = msg;
	DEtake_buffer(otl_private_de, msg);
    }
    if (otl_debug) {
	printf("Got an invoke return message from %s, handle %lx\n",
	       DEport_name(dep), (long)handle);
    }
    otl_do_call_termination(handle);
    return 0;
}


static void
handle_end_connection(de, dep)
DExchange de;
DEPort dep;
{
    int i = 0;

    i = 0;
    while (server_list[i].host_name != NULL) {
	if (server_list[i].dep == dep) {
	    break;
	}
	i++;
    }
/* printf("Killing connection from %s\n", server_list[i].host_name); */
    if (server_list[i].host_name) 
	free(server_list[i].host_name);
    if (server_list[i].in_app_name) 
	free(server_list[i].in_app_name);
    if (server_list[i].COBS_init_object) 
	otl_free_obj_ref(server_list[i].COBS_init_object);
    server_list[i].host_name = NULL;
    server_list[i].in_app_name = NULL;
    server_list[i].COBS_init_object = NULL;

    while (server_list[i].host_name != NULL) {
	server_list[i] = server_list[i + 1];
	i++;
    }
/* printf("Server list is now :"); i = 0; while (
 * server_list[i].host_name != NULL) { printf("%s, ",
 * server_list[i++].host_name); } printf("\n"); */
}

extern void
cobs_poll()
{
    if (OTL_verbose) printf("Doing poll\n");
    DExchange_poll_and_handle(otl_private_de, 0);

}

extern void
cobs_blocking_poll()
{
    if (OTL_verbose) printf("Doing poll\n");
    DExchange_poll_and_handle(otl_private_de, 1);

}

static void
poll_forever_DExchange()
{
    while(!otl_private_shutdown_flag) {
	if (DExchange_poll_and_handle_timeout(otl_private_de, 1, 0) == -1) {
	    exit(1);
	}
	thr_thread_yield();
    }
}

extern void
fork_io_handler()
{
    thr_thread_t io_handler;
    io_handler = thr_fork((int (*)())poll_forever_DExchange, 0);
    thr_thread_detach(io_handler);
}

extern object_ref
init_cobs(in_app_name, init_func)
char *in_app_name;
init_obj_func init_func;
{
    DExchange de = DExchange_create();
    if (gen_thr_initialized() && !gen_null_initialized()) {
        thr_thread_start();
	DEControlList_set_control_style(DExchange_get_control_list(de),
					DEDedicatedServerThread);
    }

    return init_cobs_DE(in_app_name, init_func, de);
}

static void
do_init_obj_exchange(de, dep)
DExchange de;
DEPort dep;
{
    init_msg contact_msg;
    int condition = DECondition_get(de, dep);

    if (COBS_init_object != NULL) {
	fill_xmit_obj(&contact_msg.initial_object, COBS_init_object->obj_name);
    } else {
	fill_xmit_obj(&contact_msg.initial_object, NULL);
    }
    contact_msg.first_msg_flag = 1;
    contact_msg.condition = condition;
    contact_msg.star_connect = 0;
    contact_msg.chan_id = master_chan_id;
    DEport_write_data(dep, init_format_id, &contact_msg);
    free_xmit_obj(&contact_msg.initial_object);
    DECondition_wait(de, condition);
}

static int group_duration = 3600;   /* seconds until cobs group expires */

extern void
set_cobs_group_duration(seconds)
int seconds;
{
    group_duration = seconds;
}


extern void
otl_setup_iiop_listen(DExchange otl_private_de);

extern object_ref
init_cobs_DE(in_app_name, init_func, de)
char *in_app_name;
init_obj_func init_func;
DExchange de;
{
    char *group_name = NULL;
    DEPort dep = NULL;
 
    if (otl_private_de != NULL) {
	fprintf(stderr, "Cannot initialize COBS more than once!\n");
	return NULL;
    }
    iiop_verbose = otl_debug = (getenv("OTL_DEBUG") != NULL);
    OTL_verbose = (getenv("OTL_VERBOSE") != NULL);

    if (!gen_thr_initialized()) {
	fprintf(stderr, "Must initialize some thread system before init_cobs()\n");
	return NULL;
    }

    thr_thread_start();

    otl_private_de = de;
    otl_private_type_context = create_IOcontext();
    init_type_context();
    otl_private_type_lock = thr_mutex_alloc();

    DExchange_set_forward(otl_private_de, DENever_Forward);

    if (DExchange_listen(otl_private_de, 0) != 0) {
	fprintf(stderr, "DExchange listen failed\n");
	exit(1);
    }
    if (in_app_name && (strrchr(in_app_name, '/') != NULL)) {
	in_app_name = strrchr(in_app_name, '/') + 1;
    }
    server_list = create_initial_server_list(in_app_name, otl_private_de);

    DExchange_register_close_handler(otl_private_de, handle_end_connection);

    DExchange_register_format(otl_private_de, "COBS Connect", COBS_connect_msg_flds);
    connect_format_id = DEget_format_id(otl_private_de, "COBS Connect");

    DExchange_register_format(otl_private_de, "xmit_attr", COBS_xmit_attr_flds);
    DExchange_register_format(otl_private_de, "xmit_obj", COBS_xmit_obj_flds);

    DExchange_register_format(otl_private_de, "vec_elem", COBS_param_vec_elem_flds);
    DExchange_register_format(otl_private_de, "invoke message", COBS_invoke_msg_flds);
    DExchange_register_function(otl_private_de, "invoke message",
				handle_invoke_msg, NULL);

    DExchange_register_format(otl_private_de, "invoke return message", COBS_invoke_return_msg_flds);
    DExchange_register_function(otl_private_de, "invoke return message",
				handle_invoke_return_msg, NULL);

    DExchange_register_format(otl_private_de, "COBS initial message", COBS_init_msg_flds);
    init_format_id = DEget_format_id(otl_private_de, "COBS initial message");
    DExchange_register_function(otl_private_de, "COBS initial message",
				handle_init_msg, NULL);

    if (DEControlList_get_control_style(DExchange_get_control_list(otl_private_de)) != DESingleThreaded) {
	fork_io_handler();
    }
    otl_setup_iiop_listen(otl_private_de);
    while ((group_name == NULL) && (dep == NULL)) {
	comm_group_return groups;
	int i;
	groups = matching_comm_groups(in_app_name, "cobs");
	dep = DExchange_initiate_first(otl_private_de, groups, 1);
	if (dep != NULL) {
	    for (i = 0; i< groups->count; i++) {
		if ((DEport_port_number(dep) == groups->list[i].port) &&
		    (strcmp(DEport_host_name(dep), groups->list[i].host) ==0)){
		    printf("Joined group : %s, %s, %s, %s, %s, %d\n", 
			   groups->list[i].user_name, 
			   groups->list[i].application_name,
			   groups->list[i].group_type,groups->list[i].group_id,
			   groups->list[i].host, groups->list[i].port);
		}
	    }
	}
	free(groups);
	if (dep == NULL) {
	    EChannel obj_exist_chan;
	    group_name = setup_comm_group(NULL, in_app_name, "cobs", 
					  group_duration,
					  DExchange_host_name(otl_private_de),
					  DExchange_inet_port(otl_private_de));
	    if (group_name != NULL) {
		obj_exist_chan = EChannel_create(de);
		master_chan_id = ECglobal_id(obj_exist_chan);
		printf("Created channel %s\n", master_chan_id);
		master_handle = ECsource_subscribe(obj_exist_chan);
		EChannel_subscribe_handler(obj_exist_chan, 
					   otl_mon_subscribe_handler, NULL);
		assoc_group_info(group_name, master_chan_id, 
				 strlen(master_chan_id) + 1);
	    }
	} else {
	    do_init_obj_exchange(otl_private_de, dep);
	    if ((master_chan_id != NULL) && (master_handle == NULL)) {
		EChannel obj_exist_chan;
		obj_exist_chan = EChannel_open(otl_private_de, master_chan_id);
		if (obj_exist_chan != NULL) {
		    master_handle = ECsource_subscribe(obj_exist_chan);
		    EChannel_subscribe_handler(obj_exist_chan, 
					       otl_mon_subscribe_handler,NULL);
		} else {
		    if (master_chan_id) free(master_chan_id);
		    master_chan_id = NULL;
		}
	    }
	}
    }
    if (group_name != NULL) {
	printf("No other members of group found.\n");
	/* we started the group, create the initial object */
	if (init_func != NULL) {
	    COBS_init_object = (init_func) ();
	} else {
	    COBS_init_object = otl_local_obj_ref();
	}

	/* we shouldn't be talking to anyone else right now, so just
	 * return */
	free(group_name);
    } else {
	/* filled in during init conn */
	assert(COBS_init_object != NULL);
    }
    return COBS_init_object;
}

extern object_ref
contact_cobs_group(in_app_name)
char *in_app_name;
{
    comm_group_return groups;
    DEPort dep = NULL;
    int i, j;

    groups = matching_comm_groups(in_app_name, "cobs");
    for (i = 0; i< groups->count; i++) {
	printf("Matching group : %s, %s, %s, %s, %s, %d\n", 
	       groups->list[i].user_name, groups->list[i].application_name,
	       groups->list[i].group_type, groups->list[i].group_id,
	       groups->list[i].host, groups->list[i].port);
    }
    dep = DExchange_initiate_first(otl_private_de, groups, 1);
    free(groups);
    if (dep == NULL) {
	return NULL;
    }
    do_init_obj_exchange(otl_private_de, dep);

    /* filled in during init conn */
    j = 0;
    while (server_list[j].host_name != NULL) {
	if (server_list[j].dep == dep) {
	    return server_list[j].COBS_init_object;
	}
	j++;
    }
    return NULL;
}

extern void
shutdown_cobs()
{
    otl_private_shutdown_flag = 1;
    DExchange_close(otl_private_de);
    /* leave locked */
}


extern
object_ref
copy_object_ref(o)
object_ref o;
{
    object_ref tmp;
    if (o == NULL) return NULL;
    tmp = (object_ref) malloc(sizeof(object_ref_struct));
    tmp->obj_name = o->obj_name;
    if (o->obj_name) add_ref_attr_list(o->obj_name);
    tmp->name_trans_cache = o->name_trans_cache;
    if (o->name_trans_cache) add_ref_attr_list(o->name_trans_cache);
    tmp->method_specific_cache = o->method_specific_cache;
    if (o->name_trans_cache) add_ref_attr_list(o->name_trans_cache);
    return tmp;
}

extern
object_ref
new_object_ref()
{
    object_ref tmp = (object_ref) malloc(sizeof(object_ref_struct));
    tmp->obj_name = tmp->name_trans_cache = tmp->method_specific_cache = NULL;
    return tmp;
}

extern int otl_private_iiop_port;

static int use_IIOP = -1;
extern void
otl_add_local_attrs(attr_list list)
{
    static atom_t home_host_atom = 0;
    static atom_t home_port_atom = 0;
    static atom_t iiop_port_atom = 0;
    static atom_t iiop_version_atom = 0;
    static atom_t otl_protocol_atom = 0;
    static atom_t otl_protocol = 0;
    static atom_t iiop_protocol = 0;
    int iiop_port = otl_private_iiop_port;
    int otl_port = server_list[0].port;
    if (server_list == NULL) {
	fprintf(stderr, "COBS not yet initialized.  Object creation failed.\n");
	return;
    }
    if (use_IIOP == -1) {
	use_IIOP = (getenv("OTL_USE_IIOP") != NULL);
    }
    if (home_host_atom == 0) {
	home_host_atom = attr_atom_from_string("OTL:HOME_HOST");
	home_port_atom = attr_atom_from_string("OTL:HOME_PORT");
	iiop_port_atom = attr_atom_from_string("OTL:IIOP_PORT");
	iiop_version_atom = attr_atom_from_string("OTL:IIOP_VERSION");
	otl_protocol_atom = attr_atom_from_string("OTL:PROTOCOL_TAG");
	otl_protocol = attr_atom_from_string("OTL:OTL_PROTOCOL");
	iiop_protocol = attr_atom_from_string("OTL:IIOP_PROTOCOL");
    }

    add_attr(list, home_host_atom, Attr_String, 
	     (attr_value) strdup(server_list[0].host_name));
    add_attr(list, home_port_atom, Attr_Int4, (attr_value) otl_port);
    add_attr(list, iiop_port_atom, Attr_Int4, (attr_value) iiop_port);
    add_attr(list, iiop_version_atom, Attr_Int4, 
	     (attr_value) OUR_IIOP_VERSION);
    if (use_IIOP) {
	add_attr(list, otl_protocol_atom, Attr_Atom, 
		 (attr_value) iiop_protocol);
    } else {
	add_attr(list, otl_protocol_atom, Attr_Atom, 
		 (attr_value) otl_protocol);
    }
}

extern object_ref
otl_local_obj_ref()
{
    object_ref tmp = (object_ref) malloc(sizeof(object_ref_struct));
    tmp->obj_name = create_attr_list();
    tmp->name_trans_cache = create_attr_list();
    tmp->method_specific_cache = create_attr_list();
    otl_add_local_attrs(tmp->obj_name);
    return tmp;
}

DEPort
otl_get_dep(name, port)
char *name;
int port;
{
    int i;
    DEPort tmp_dep;

    for (i=0; server_list[i].host_name != NULL; i++) {
	if ((strcmp(server_list[i].host_name, name) == 0) &&
	    (server_list[i].port == port)) {
	    return server_list[i].dep;
	}
    }
    thr_mutex_lock(server_list_lock);
    /* check again, after locking */
    for (i=0; server_list[i].host_name != NULL; i++) {
	if ((strcmp(server_list[i].host_name, name) == 0) &&
	    (server_list[i].port == port)) {
	    thr_mutex_unlock(server_list_lock);
	    return server_list[i].dep;
	}
    }
    if (otl_debug) {
	printf("Initiating connection with %s, not in list\n", name);
    }

    tmp_dep = DExchange_get_conn(otl_private_de, name, port, 01);

    for (i=0; server_list[i].host_name != NULL; i++) {
	if ((strcmp(server_list[i].host_name, name) == 0) &&
	    (server_list[i].port == port)) {
	    thr_mutex_unlock(server_list_lock);
	    return server_list[i].dep;
	}
    }
    thr_mutex_unlock(server_list_lock);
    if (tmp_dep != NULL) {
	do_init_obj_exchange(otl_private_de, tmp_dep);
    }

    return tmp_dep;
}

