// @(#)tc_const.cpp	1.3 95/09/12
// Copyright 1994-1995 by Sun Microsystems Inc.
// All Rights Reserved
//
// ORB:		All the CORBA-specified typecode constants.
//
// NOTE:  IFR TypeCode constants aren't here; they're left for an IDL
// compiler to generate from the appropriate IDL source.
//
// NOTE:  it'd be nice to have these not use init sections.  Most can easily
// be in readonly data (e.g. text segment, ROM) rather than writable data;
// that speeds program startup and page sharing in shared libraries.
//
// THREADING NOTE:  no issues, these are immutable constants
//

#include	<assert.h>
#include	<limits.h>
#include	<string.h>
#include	"../otl.h"
#include	<orb.hh>
//
// typecode for objref is complex, has two string parameters
//
// NOTE:  Must be four-byte aligned
//
static unsigned char oc_objref [] = {
    0, 0, 0, 0,			// big endian encoding (+ padding)
    0, 0, 0, 29,		// 29 char string + 3 pad bytes
    'I', 'D', 'L', ':',
    'o', 'm', 'g', '.',
    'o', 'r', 'g', '/',
    'C', 'O', 'R', 'B',
    'A', '/', 'O', 'b',
    'j', 'e', 'c', 't',
    ':', '1', '.', '0',
    '\0', 0, 0, 0,
    0, 0, 0, 7,			// 7 chars "Object" + 1 pad byte
    'O', 'b', 'j', 'e',
    'c', 't', '\0', 0,
};

//
// Null and void
//
void
init_const_typecodes()
{
    _tc_CORBA_Null = new(1) CORBA_TypeCode (tk_null);

    _tc_CORBA_Void = new(1) CORBA_TypeCode (tk_void);

    _tc_CORBA_Short = new(1) CORBA_TypeCode (tk_short);

    _tc_CORBA_Long = new(1) CORBA_TypeCode (tk_long);

    _tc_CORBA_LongLong = new(1) CORBA_TypeCode (tk_longlong);

    _tc_CORBA_UShort = new(1) CORBA_TypeCode (tk_ushort);

    _tc_CORBA_ULong = new(1) CORBA_TypeCode (tk_ulong);

    _tc_CORBA_ULongLong = new(1) CORBA_TypeCode (tk_ulonglong);

    _tc_CORBA_Float = new(1) CORBA_TypeCode (tk_float);

    _tc_CORBA_Double = new(1) CORBA_TypeCode (tk_double);

    _tc_CORBA_LongDouble = new(1) CORBA_TypeCode (tk_longdouble);

    _tc_CORBA_Boolean = new(1) CORBA_TypeCode (tk_boolean);

    _tc_CORBA_Octet = new(1) CORBA_TypeCode (tk_octet);

    _tc_CORBA_Char = new(1) CORBA_TypeCode (tk_char);

    _tc_CORBA_WChar = new(1) CORBA_TypeCode (tk_wchar);

    _tc_CORBA_String = new(1) CORBA_TypeCode (tk_string);

    _tc_CORBA_WString = new(1) CORBA_TypeCode (tk_wstring);

    _tc_CORBA_Any = new(1) CORBA_TypeCode (tk_any);

    _tc_CORBA_TypeCode = new(1) CORBA_TypeCode (tk_TypeCode);

    _tc_CORBA_Principal = new(1) CORBA_TypeCode (tk_Principal);

    _tc_CORBA_Object = new(1) CORBA_TypeCode(tk_objref, sizeof oc_objref,
					  (unsigned char *)&oc_objref, 
					  CORBA_B_FALSE);
}

//static CORBA_TypeCode tc_null (tk_null);
CORBA_TypeCode_ptr _tc_CORBA_Null;// = (CORBA_TypeCode_ptr) &tc_null;

CORBA_TypeCode_ptr
CORBA_TypeCode::_nil ()
{
    return _tc_CORBA_Null;
}

//static CORBA_TypeCode tc_void (tk_void);
CORBA_TypeCode_ptr _tc_CORBA_Void;// = &tc_void;

//
// Basic numeric types:  short, long, longlong, and unsigned variants
//
//static CORBA_TypeCode tc_short (tk_short);
CORBA_TypeCode_ptr _tc_CORBA_Short;// = &tc_short;

//static CORBA_TypeCode tc_long (tk_long);
CORBA_TypeCode_ptr _tc_CORBA_Long;// = &tc_long;

//static CORBA_TypeCode tc_longlong (tk_longlong);
CORBA_TypeCode_ptr _tc_CORBA_LongLong;// = &tc_longlong;

//static CORBA_TypeCode tc_ushort (tk_ushort);
CORBA_TypeCode_ptr _tc_CORBA_UShort;// = &tc_ushort;

//static CORBA_TypeCode tc_ulong (tk_ulong);
CORBA_TypeCode_ptr _tc_CORBA_ULong;// = &tc_ulong;

//static CORBA_TypeCode tc_ulonglong (tk_ulonglong);
CORBA_TypeCode_ptr _tc_CORBA_ULongLong;// = &tc_ulonglong;

//
// Floating point types:  single, double, quad precision
//
//static CORBA_TypeCode tc_float (tk_float);
CORBA_TypeCode_ptr _tc_CORBA_Float;// = &tc_float;

//static CORBA_TypeCode tc_double (tk_double);
CORBA_TypeCode_ptr _tc_CORBA_Double;// = &tc_double;

//static CORBA_TypeCode tc_longdouble (tk_longdouble);
CORBA_TypeCode_ptr _tc_CORBA_LongDouble;// = &tc_longdouble;

//
// Various simple quantities
//
//static CORBA_TypeCode tc_boolean (tk_boolean);
CORBA_TypeCode_ptr _tc_CORBA_Boolean;// = &tc_boolean;

//static CORBA_TypeCode tc_octet (tk_octet);
CORBA_TypeCode_ptr _tc_CORBA_Octet;// = &tc_octet;

//
// Internationalization-related data types:  ISO Latin/1 and "wide"
// characters, and strings of each.  "wchar" is probably Unicode 1.1,
// "wstring" being null-terminated sets thereof.
//
//static CORBA_TypeCode tc_char (tk_char);
CORBA_TypeCode_ptr _tc_CORBA_Char;// = &tc_char;

//static CORBA_TypeCode tc_wchar (tk_wchar);
CORBA_TypeCode_ptr _tc_CORBA_WChar;// = &tc_wchar;

//static CORBA_TypeCode tc_string (tk_string);
CORBA_TypeCode_ptr _tc_CORBA_String;// = &tc_string;

//static CORBA_TypeCode tc_wstring (tk_wstring);
CORBA_TypeCode_ptr _tc_CORBA_WString;// = &tc_wstring;

//
// Various things that can be passed as "general" parameters:
// Any, TypeCode_ptr, Principal_ptr, Object_ptr
//
//static CORBA_TypeCode tc_any (tk_any);
CORBA_TypeCode_ptr _tc_CORBA_Any;// = &tc_any;

//static CORBA_TypeCode tc_typecode (tk_TypeCode);
CORBA_TypeCode_ptr _tc_CORBA_TypeCode;// = &tc_typecode;

//static CORBA_TypeCode tc_principal (tk_Principal);
CORBA_TypeCode_ptr _tc_CORBA_Principal;// = &tc_principal;

//static CORBA_TypeCode
//    tc_objref (tk_objref, sizeof oc_objref,
//	    (unsigned char *)&oc_objref, CORBA_B_FALSE);
CORBA_TypeCode_ptr _tc_CORBA_Object;// = &tc_objref;

