// @(#)corbacom.hh	1.2 95/10/02
// Copyright 1995 by Sun Microsystems, Inc.
// All Rights Reserved
//
// CORBA C/C++/COM mapping for Win32
//

//#include <objbase.h>		// Win32 name for "compobj.h"
typedef unsigned long ULONG;

#if	SIZEOF_BOOL != 0
typedef bool			CORBA_Boolean;
#define CORBA_B_FALSE false
#define CORBA_B_TRUE true

#else	// "bool" not builtin to this compiler
typedef int			CORBA_Boolean;
enum { CORBA_B_FALSE = 0, CORBA_B_TRUE = 1 };
#endif	// "bool" not builtin

typedef unsigned char		CORBA_Octet;

typedef short			CORBA_Short;
typedef unsigned short		CORBA_UShort;

//
// CORBA "Long" (and its unsigned cousin) are 32 bits, just like
// on almost all C/C++ compilers.
//
#if	SIZEOF_LONG == 4
typedef long			CORBA_Long;
typedef unsigned long		CORBA_ULong;
#else
// just assume "int" is 4 bytes long ...
typedef int			CORBA_Long;
typedef unsigned		CORBA_ULong;
#endif	// SIZEOF_LONG != 4

//
// 94-9-32 Appendix A, also the OMG C++ mapping, stipulate that
// 64 bit integers are "LongLong".
//
// NOTE:  those are IDL extensions, not yet standard.
//
#if	SIZEOF_LONG_LONG == 8
typedef long long		CORBA_LongLong;
typedef unsigned long long	CORBA_ULongLong;
#elif	SIZEOF_LONG == 8
typedef long			CORBA_LongLong;
typedef unsigned long		CORBA_ULongLong;
#elif	defined (_MSC_VER) && _MSC_VER >= 900
typedef __int64			CORBA_LongLong;
typedef unsigned __int64	CORBA_ULongLong;
#else
//
// If "long long" isn't native, programs can't use these
// data types in normal arithmetic expressions.  If any
// particular application can cope with the loss of range
// it can define conversion operators itself.
//
#   define	NONNATIVE_LONGLONG
#if	defined (WORDS_BIGENDIAN)
struct CORBA_LongLong { CORBA_Long h, l; };
struct CORBA_ULongLong { CORBA_ULong h, l; };
#else
struct CORBA_LongLong { CORBA_Long l, h; };
struct CORBA_ULongLong { CORBA_ULong l, h; };
#endif	// !WORDS_BIGENDIAN
#endif	// no native 64 bit integer type

typedef float		CORBA_Float;
typedef double		CORBA_Double;

//
// 94-9-32 Appendix A defines a 128 bit floating point "long
// double" data type, with greatly extended precision and
// four more bits of exponent (compared to "double").
//
// NOTE:  that is an IDL extension, not yet standard.
//
#if	SIZEOF_LONG_DOUBLE == 16
typedef long double	CORBA_LongDouble;
#else
#define	NONNATIVE_LONGDOUBLE
struct CORBA_LongDouble {
    char	ld [16];
};
#endif	// SIZEOF_LONG_DOUBLE != 16

typedef char 		CORBA_Char;
typedef CORBA_Char	*CORBA_String;

CORBA_String		CORBA_string_alloc (CORBA_ULong len);
CORBA_String		CORBA_string_copy (const CORBA_Char *const);
void			CORBA_string_free (CORBA_Char *const);

//
// 94-9-32 Appendix A defines 16-bit UNICODE characters as
// "WChar", and null-terminated strings of them as "WString".
//
// NOTE:  those are IDL extensions, not yet standard.
//
typedef wchar_t		CORBA_WChar;
typedef CORBA_WChar	*CORBA_WString;

CORBA_WString		CORBA_wstring_alloc (CORBA_ULong len);
CORBA_WString		CORBA_wstring_copy (const CORBA_WChar *const);
void			CORBA_wstring_free (CORBA_WChar *const);

