/***** Includes *****/
#include "config.h"
#include <sys/types.h>

#ifdef HAVE_WINDOWS_H
#include <windows.h>
#include <winsock.h>
#define getpid()	_getpid()
#else
#include <sys/time.h>
#include <sys/socket.h>
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#endif
#include <stdio.h>
#include <fcntl.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <errno.h>
#include <signal.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>

extern "C" {
#include <malloc.h>
#if !defined(BIND_DEFINED) & !defined(HAVE_WINDOWS_H)
extern int bind (int s, struct sockaddr * name, int namelen);
#endif
#if !defined(ACCEPT_DEFINED) & !defined(HAVE_WINDOWS_H)
extern int accept (int s, struct sockaddr * addr, int *addrlen);
#endif
#if !defined(CONNECT_DEFINED) & !defined(HAVE_WINDOWS_H)
extern int connect (int s, struct sockaddr * name, int namelen);
#endif
#if !defined(SETSOCKOPT_DEFINED) & !defined(HAVE_WINDOWS_H)
extern int setsockopt (int s, int level, int optname, const char *optval, int optlen);
#endif
#if !defined(GETSOCKNAME_DEFINED) & !defined(HAVE_WINDOWS_H)
extern int getsockname (int s, struct sockaddr * name, int *namelen);
#endif
#if defined(HAVE_GETDOMAINNAME) && !defined(GETDOMAINNAME_DEFINED)
extern int getdomainname (char *name, int namelen);
#endif
#if !defined(LISTEN_DEFINED) & !defined(HAVE_WINDOWS_H)
extern int listen (int s, int backlog);
#endif
#ifndef HAVE_WINDOWS_H
extern int socket (int domain, int type, int protocol);
#endif
#if !defined(GETHOSTNAME_DEFINED) & !defined(HAVE_WINDOWS_H)
extern int gethostname (char *name, int namelen);
#endif
#if !defined(SEND_DEFINED) & !defined(HAVE_WINDOWS_H)
extern int send(int, const void *, int, int);
#endif
	   }
#include	"otl.h"
extern "C" {
#include "io.h"
#include "io_interface.h"
#include "gen_thread.h"
#include "DE.h"
#include "otl_formats.h"
#include "otl_obj.h"
}

#include	"cdr.hh"

#ifdef WORDS_BIGENDIAN
#define  OUR_BYTE_ORDER 0
#else
#define  OUR_BYTE_ORDER 1
#endif


#ifndef SOCKET_ERROR
#define SOCKET_ERROR -1
#endif

extern "C" { 
int otl_private_iiop_port;
extern int iiop_verbose;
extern DExchange otl_private_de;
}

static int get_long (char *where, int byte_order);

enum MsgType {
    Request = 0,
    Reply = 1,
    CancelRequest = 2,
    LocateRequest = 3,
    LocateReply = 4,
    CloseConnection = 5,
    MessageError = 6
};

static const char *msg_names [] = {
    "Request", "Reply", "CancelRequest",
    "LocateRequest", "LocateReply",
    "CloseConnection", "MessageError"
};

enum ReplyStatusType {
    NO_EXCEPTION,
    USER_EXCEPTION,
    SYSTEM_EXCEPTION,
    LOCATION_FORWARD
};

#define	GIOP_HDR_LEN	12		// defined by GIOP 1.0 protocol

    typedef CORBA_ULong 	ServiceID;
    typedef CORBA_SEQUENCE <CORBA_Octet> opaque;
    struct ServiceContext {
	ServiceID		context_id;
	opaque			context_data;
    };
    typedef CORBA_SEQUENCE <ServiceContext>	ServiceContextList;

    void			*operator new (size_t s, int nothrow) 
				{ return malloc(s);}

    struct RequestHeader {
//	ServiceContextList	service_info;
	CORBA_ULong		request_id;
	CORBA_Boolean		response_expected;
//	opaque			object_key;
	CORBA_String		operation;
	CORBA_Principal_ptr	requesting_principal;

    void			*operator new (size_t s, int nothrow) 
				{ return malloc(s);}
    };

static const CORBA_Long _oc_opaque [] = {	// CDR typecode octets
    1,				// native endian + padding; "tricky"
    10,				// ... (sequence of) octets
    0				// ... unbounded
};

static const CORBA_Long _oc_svc_ctx_list [] = {
	// START bytes of encapsulation 0
    1,				// native endian + padding; "tricky"

    //
    // FIRST sequence param:  typecode for struct is complex,
    // and so uses a nested encapsulation.
    //
    tk_struct,
    72,				// length of encapsulation 1 

	// START bytes of encapsulation 1 (struct params)
    1,				// native endian + padding; "tricky"
    1, 0,			// type ID omitted:  null string
    1, 0,			// name omitted "ServiceContext"

    2,				// two struct elements

    //
    // First structure element:  name, typecode for ULong
    //
    // NOTE:  to be more strictly correct this could be a tk_alias
    // typecode ...
    //
    1, 0,			// name omitted:  "context_id"
    tk_long,

    //
    // Second structure element:  name, typecode for sequence of octet;
    // the typecode for sequence of octet is complex, there's a second
    // level of nested encapuslation here.
    //
    1, 0,			// name omitted:  "context_data"
    tk_sequence,	// sequence typecode
    16,				// length of encapsulation 2

	// START bytes of encapsulation 2 (sequence params)
    1,				// native endian + padding; "tricky"
    1, 0,			// type ID omitted:  null string
    tk_octet,		// (sequence of) octet
    0,				// ... unbounded length
	// END bytes of encapsulation 2 (sequence params)

	// END bytes of encapsulation 1 (struct params)

    //
    // SECOND sequence param:  bound of sequence (none)
    // 
    0				// unbounded seq of ServiceContext
	// END bytes of encapsulation 0 (sequence params)
};

static CORBA_TypeCode_ptr TC_ServiceContextList;
CORBA_TypeCode_ptr TC_opaque_p;

extern void init_const_typecodes();
extern void init_tc_consts();
extern void __TC_init_table ();


static void
handle_request (RequestHeader *req, opaque  *object_key, CDR *req_body, 
		CDR *reply, int fd, CORBA_Environment &env);

static void
init_typecode()
{
  TC_ServiceContextList = new (1)CORBA_TypeCode(tk_sequence,
					     sizeof _oc_svc_ctx_list, 
					     (unsigned char *) &_oc_svc_ctx_list,
					     CORBA_B_FALSE);
  TC_opaque_p = new (1) CORBA_TypeCode (tk_sequence,
					sizeof _oc_opaque, 
					(unsigned char *) &_oc_opaque,
					CORBA_B_FALSE);
}

typedef struct {
    CORBA_Environment *env_p;
    unsigned long reply_status;
    otl_class_info obj_info;
    int method_id;
    CDR *return_stream;
    otl_handle handle;
} *iiop_call_info;

static inline CORBA_Boolean
start_message (
    int type,
    CDR			&msg,
    int version
)
{
    msg.next = msg.buffer;		// for reused streams
    msg.remaining = msg.length;

    if (msg.bytes_remaining () < GIOP_HDR_LEN)
	return CORBA_B_FALSE;

    msg.next [0] = 'G';
    msg.next [1] = 'I';
    msg.next [2] = 'O';
    msg.next [3] = 'P';

    msg.next [4] = 1;
    if (version > OUR_IIOP_VERSION) {
	version = OUR_IIOP_VERSION;
    }
    msg.next [5] = version;
    msg.next [6] = OUR_BYTE_ORDER;
    msg.next [7] = (unsigned char) type;

    msg.skip_bytes (GIOP_HDR_LEN);
    return CORBA_B_TRUE;
}

extern "C" {
void (*iiop_write_hook)() = (void(*)()) NULL;
void (*iiop_read_hook)() = (void(*)()) NULL;
}

CORBA_Boolean
send_message (
    CDR			&stream,
    int			&connection
)
{
    char	*buf = (char *) stream.buffer;
    size_t	buflen = stream.next - stream.buffer;
    int		writelen;

    if (iiop_write_hook != NULL) iiop_write_hook();
    assert (buflen == (stream.length - stream.remaining));

    //
    // Patch the message length in the GIOP header; it's always at the
    // same eight byte offset into the message.
    //
    // NOTE:  Here would also be a fine place to calculate a digital
    // signature for the message and place it into a preallocated
    // slot in the "ServiceContext".  Similarly, this is a good spot
    // to encrypt messages (or just the message bodies) if that's
    // needed in this particular environment and that isn't handled
    // by the networking infrastructure (e.g. IPSEC).
    //
    *(CORBA_Long *)(stream.buffer + 8) =
	    (CORBA_Long) (buflen - GIOP_HDR_LEN);

    if (iiop_verbose) {
	printf("Sending %d bytes in IIOP message\n", (int)buflen);
    }
    //
    // Strictly speaking, should not need to loop here because the
    // socket never gets set to a nonblocking mode ... some Linux
    // versions seem to need it though.  Leaving it costs little. 
    //
    while (buflen > 0) {
	writelen = send (connection, (char *) buf, buflen, 0);

	assert ((writelen >= 0 &&
		((size_t)writelen) <= buflen) || writelen == -1);

	//
	// On error or EOF, report the fault, close the connection, and
	// mark it as unusable/defunct.
	//
	// XXX on client side write errors, we may hit the case that
	// the server did a clean shutdown but we've not yet read the
	// GIOP::CloseConnection message.  If we get an error, we need
	// to see if there is such a message waiting for us, and if so
	// we should cause (full) rebinding to take place.
	//
/*	if (writelen == -1) {
	    closesocket (connection);
	    connection = -1;
	    return CORBA_B_FALSE;
	} else if (writelen == 0) {
	    dmsg1 ("OutgoingMessage::writebuf() ... EOF, closing conn %d",
		    connection);
	    closesocket (connection);
	    connection = -1;
	    return CORBA_B_FALSE;
	}
*/
	if ((buflen -= writelen) != 0)
	    buf += writelen;

	//
	// NOTE:  this should never be seen.  However, on Linux
	// it's been seen with UNIX domain sockets.
	//
	if (buflen && iiop_verbose) {
	    printf("%u more bytes to write...\n", (int)buflen);
	}

    }
    return CORBA_B_TRUE;
}

static void
iiop_init()
{
    static int init = 1;
    if (init == 1) {
	init_const_typecodes();
	init_typecode();
	init_tc_consts();
	__TC_init_table ();
	init = 0;
    }
}

static void
close_iiop_conn(int sock, DExchange de)
{
    if (iiop_verbose) {
	printf("Closing incoming iiop connection %d\n", sock);
    }
    DExchange_remove_select(de, sock);
}


extern "C" void
iiop_message_handler(long sock, void *void_de)
{
    char header_buffer[12];
    int version, message_type;
    unsigned int message_size,i;
    DExchange de = (DExchange) void_de;
    int byte_order;
    unsigned char	buffer [CDR::DEFAULT_BUFSIZE];
    char *bufptr;
    CDR			*msg;

    if (recv(sock, &header_buffer[0], sizeof(header_buffer), 0) != sizeof(header_buffer)) {
	close_iiop_conn(sock, de);
	return;
    }
    if (strncmp(header_buffer, "GIOP", 4) != 0) {
	printf("Unknown incoming message, FD = %d, bytes %2x %2x %2x %2x\n",
	       (int)sock, header_buffer[0], header_buffer[1], header_buffer[2],
	       header_buffer[3]);
	close_iiop_conn(sock, de);
	return;
    }
    assert(header_buffer[4] == 1);
    version = header_buffer[5];
    byte_order = header_buffer[6];
    message_type = header_buffer[7];
    message_size = get_long(&header_buffer[8], byte_order);
    if (iiop_verbose) {
	printf("Incoming GIOP message, version 1.%d, type %d <%s>, length %d\n",
	       version, message_type, msg_names[message_type], message_size);
    }
    if (message_size == 0) return;
    msg = new CDR(&buffer [0], sizeof buffer, byte_order);
    if ((GIOP_HDR_LEN + message_size) > msg->length)
	msg->grow ((size_t) (GIOP_HDR_LEN + message_size));

/*    msg = new CDR(&buffer [0], sizeof buffer);*/
    msg->remaining = (size_t) message_size;
    bufptr = (char *) & msg->buffer [GIOP_HDR_LEN];
    msg->next = (unsigned char *)bufptr;

    
    int received = 0, remaining = message_size;
    while(remaining !=0) {
	received = recv(sock, bufptr, remaining, 0);
	if (received == -1) {
	    close_iiop_conn(sock, de);
	    return;
	}
	remaining -= received;
	bufptr += received;
    }
    if (iiop_read_hook != NULL) iiop_read_hook();
    switch(message_type) {
    case Request:
	{
	    iiop_init();
	    opaque *object_key = new (1) opaque;
	    ServiceContextList	*service_info = new(1) ServiceContextList;
	    RequestHeader	*req = new (1) RequestHeader;
	    CORBA_Boolean	hdr_status;
	    CORBA_Environment *env_p = new (1) CORBA_Environment;
	    //
	    // Tear out the service context ... we currently ignore it,
	    // but it should probably be passed to each ORB service as
	    // appropriate (e.g. transactions, security).
	    //
	    // NOTE:  As security support kicks in, this is a good place
	    // to verify a digital signature, if that is required in this
	    // security environment.  It may be required even when using
	    // IPSEC security infrastructure.
	    //
	    CORBA_ULong num_contexts = 0;
	    hdr_status = msg->get_ulong(num_contexts);

	    while (num_contexts-- != 0) {
		CORBA_ULong context_id = 0;
		hdr_status = hdr_status && msg->get_ulong(context_id);
		hdr_status = hdr_status && CDR::decoder (TC_opaque_p, object_key,
							 0, msg, *env_p);
	    }		
//	    hdr_status = CDR::decoder (TC_ServiceContextList,
//		    service_info, 0, msg, *env_p);

	    free(service_info);
	    //
	    // Get the rest of the request header ...
	    //
	    hdr_status = hdr_status && msg->get_ulong (req->request_id);
	    hdr_status = hdr_status && msg->get_boolean (req->response_expected);
	    if (version > 0) {
		unsigned char reserved;
		hdr_status = hdr_status && msg->get_octet(reserved);
		hdr_status = hdr_status && msg->get_octet(reserved);
		hdr_status = hdr_status && msg->get_octet(reserved);
	    }
	    hdr_status = hdr_status && CDR::decoder (TC_opaque_p, object_key,
		    0, msg, *env_p);
	    hdr_status = hdr_status && CDR::decoder (_tc_CORBA_String, &(req->operation),
		    0, msg, *env_p);
	    hdr_status = hdr_status && CDR::decoder (_tc_CORBA_Principal,
		    &(req->requesting_principal), 0, msg, *env_p);

	    if (iiop_verbose) {
		printf("Received Request.  ID is %d, exp_resp is %d, operation \"%s\"\n", req->request_id, req->response_expected, 
		       (req->operation == NULL) ? "":req->operation);
		printf("	Object key is <");
		for(i=0; i<object_key->length; i++) {
		    printf(" %2x", object_key->buffer[i]);
		}
		printf("> \"");
		for(i=0; i<object_key->length; i++) {
		    printf("%c", object_key->buffer[i]);
		}
		printf("\"\n");
	    }
	    if (req->response_expected) {
		ServiceContextList	*resp_ctx = new(1)ServiceContextList;
		unsigned char		buf2 [CDR::DEFAULT_BUFSIZE];
		CDR 			*response =
		    new CDR(&buf2 [0], sizeof buf2);

		start_message (Reply, *response, version);
		resp_ctx->length = 0;
		CDR::encoder (TC_ServiceContextList, resp_ctx,
			0, response, *env_p);
		delete resp_ctx;
		response->put_ulong (req->request_id);

		handle_request (req, object_key, msg, response, sock, 
				*env_p);

		//
		// "handle_request" routine puts ReplyStatusType then
		// parameters.
		//
	    } else {
		handle_request (req, object_key, msg, 0, sock, *env_p);
	    }
	    free(object_key->buffer);
	    free (req->operation);

	}
	break;
    case Reply:
	ServiceContextList	*reply_ctx = new(1) ServiceContextList;
	CORBA_Environment *env_p = new (1) CORBA_Environment;
	CORBA_ULong	request_id;
	CORBA_ULong	reply_status;		// GIOP::ReplyStatusType
	opaque *context = new (1) opaque;
	int hdr_status;

	CORBA_ULong num_contexts = 0;
	hdr_status = msg->get_ulong(num_contexts);

	while (num_contexts-- != 0) {
	    CORBA_ULong context_id = 0;
	    hdr_status = hdr_status && msg->get_ulong(context_id);
	    hdr_status = hdr_status && CDR::decoder (TC_opaque_p, context,
						     0, msg, *env_p);
	}
//	if (CDR::decoder (TC_ServiceContextList, reply_ctx, 0, msg, *env_p)
//	    != CORBA_TypeCode::TRAVERSE_CONTINUE) {
//	    send_error (endpoint->fd);
//	    return;
//	}
	free(reply_ctx);
    
	if (!msg->get_ulong (request_id)
//	    || request_id != my_request_id
	    || !msg->get_ulong (reply_status)
	    || reply_status > LOCATION_FORWARD) {
//	send_error (endpoint->fd);
//	env.exception (new CORBA_COMM_FAILURE (COMPLETED_MAYBE));
	    printf ("bad Response header\n");
	    return;
	}
	
	switch (reply_status) {
	case NO_EXCEPTION: {
	    if (iiop_verbose)
		printf("No Exception\n");
	    iiop_call_info this_call_info;
	    this_call_info = (iiop_call_info) 
		DECondition_get_client_data(otl_private_de, 
					    request_id);
	    this_call_info->reply_status = reply_status;
	    this_call_info->return_stream = msg;
	    otl_do_call_termination(this_call_info->handle);
	    break;
	}
	case USER_EXCEPTION:
	case SYSTEM_EXCEPTION:
        {
	    CORBA_String		exception_id;
	    
	    //
	    // Pull the exception ID out of the marshaling buffer.
	    //
	    {
		CORBA_ULong		len;

		//
		// Read "length" field of string, so "next" points
		// right at the null-terminated ID.  Then get the ID.
		//
		if (msg->get_ulong (len) != CORBA_B_TRUE
			|| len > msg->remaining) {
//		    send_error (endpoint->fd);
//		    env.exception (new CORBA_MARSHAL (COMPLETED_YES));
//		    return SYSTEM_EXCEPTION;
		    return;
		}
		exception_id = (CORBA_String) msg->next;
		msg->skip_bytes (len);
	    }

	    printf("Exception was %s\n", exception_id);
	    //
	    // User and system exceptions differ only in what table of
	    // exception typecodes is searched.
	    //
// 	    CORBA_ExceptionList		*xlist;

// 	    if (reply_status == USER_EXCEPTION)
// 		xlist = &exceptions;
// 	    else
// 		xlist = &__system_exceptions;

// 	    //
// 	    // Find it in the operation description and then use that to get
// 	    // the typecode.  Use it to unmarshal the exception's value; if
// 	    // that exception is not allowed by this operation, fail (next). 
// 	    //
// 	    unsigned			i;
// 	    CORBA_TypeCode_ptr		*tcp;

// 	    for (i = 0, tcp = xlist->buffer;
// 		    i < xlist->length;
// 		    i++, tcp++) {
// 		CORBA_String		xid;

// 		xid = (*tcp)->id (env);
// 		if (env.exception () != 0) {
// 		    dexc (env, "invoke(), get exception ID");
// 		    send_error (endpoint->fd);
// 		    return SYSTEM_EXCEPTION;
// 		}

// 		if (strcmp ((char *)exception_id, (char *)xid) == 0) {
// 		    size_t			size;
// 		    CORBA_Exception		*exception;

// 		    size = (*tcp)->size (env);
// 		    if (env.exception () != 0) {
// 			dexc (env, "invoke(), get exception size");
// 			send_error (endpoint->fd);
// 			return SYSTEM_EXCEPTION;
// 		    }

// 		    //
// 		    // Create the exception, fill in the generic parts
// 		    // such as vtable, typecode ptr, refcount ... we
// 		    // need to clean them all up together, in case of
// 		    // errors unmarshaling.
// 		    //
// 		    exception = new (new char [size]) CORBA_Exception (*tcp);

// 		    if (CDR::decoder (*tcp, exception, 0, &stream, env)
// 			    != CORBA_TypeCode::TRAVERSE_CONTINUE) {
// 			delete exception;
// 			dmsg2 ("invoke, unmarshal %s exception %s",
// 				(reply_status == USER_EXCEPTION)
// 				    ? "user" : "system",
// 				exception_id);
// 			send_error (endpoint->fd);
// 			return SYSTEM_EXCEPTION;
// 		    }
// 		    env.exception (exception);
// 		    return (GIOP::ReplyStatusType) reply_status;
// 		}
// 	    }

// 	    //
// 	    // If we couldn't find this exception's typecode, report it as
// 	    // an OA error since the skeleton passed an exception that was
// 	    // not allowed by the operation's IDL definition.  In the case
// 	    // of a dynamic skeleton it's actually an implementation bug.
// 	    //
// 	    // It's known to be _very_ misleading to try reporting this as
// 	    // any kind of marshaling error (unless minor codes are made
// 	    // to be _very_ useful) ... folk try to find/fix ORB bugs that
// 	    // don't exist, not bugs in/near the implementation code.
// 	    //
// 	    if (reply_status == USER_EXCEPTION)
// 		env.exception (new CORBA_OBJ_ADAPTER (COMPLETED_YES));
// 	    else
// 		env.exception (new CORBA_INTERNAL (COMPLETED_MAYBE));
	    iiop_call_info this_call_info;
	    this_call_info = (iiop_call_info) 
		DECondition_get_client_data(otl_private_de, 
					    request_id);
	    this_call_info->return_stream = msg;
	    this_call_info->reply_status = reply_status;
	    otl_do_call_termination(this_call_info->handle);
	}
	return;
	// NOTREACHED

      case LOCATION_FORWARD:
	{
	    printf("UNHANDLED Location forward reply\n");
// 	    CORBA_Object_ptr	obj;
// 	    IIOP_Object		*obj2;

// 	    //
// 	    // Unmarshal the object we _should_ be calling.  We know
// 	    // that one of the facets of this object will be an IIOP
// 	    // invocation profile.
// 	    //
// 	    if (CDR::decoder (_tc_CORBA_Object, &obj, 0, &stream, env)
// 			!= CORBA_TypeCode::TRAVERSE_CONTINUE
// 		    || obj->QueryInterface (IID_IIOP_Object, (void **)&obj2)
// 			!= NOERROR
// 		    ) {
// 		dexc (env, "invoke, location forward");
// 		send_error (endpoint->fd);
// 		return SYSTEM_EXCEPTION;
// 	    }
// 	    CORBA_release (obj);

// 	    //
// 	    // Make a copy of the IIOP profile in the forwarded objref,
// 	    // reusing memory where practical.  Then delete the forwarded
// 	    // objref, retaining only its profile.
// 	    //
// 	    // XXX add and use a "forward count", to prevent loss of data
// 	    // in forwarding chains during concurrent calls -- only a
// 	    // forward that's a response to the current fwd_profile should
// 	    // be recorded here.  (This is just an optimization, and is
// 	    // not related to correctness.)
// 	    //
// #ifdef	_POSIX_THREADS
// 	    Critical	section (&fwd_info_lock);
// #endif	// _POSIX_THREADS

// 	    delete _data->fwd_profile;
// 	    _data->fwd_profile = new IIOP::ProfileBody (obj2->profile);

// 	    obj2->Release ();

// 	    env.clear ();

// 	    //
// 	    // Make sure a new connection is used next time.
// 	    //
// 	    endpoint = 0;
	}
	break;
    }

    //
    // All standard exceptions from here on in the call path know for certain
    // that the call "completed" ... except in the case of system exceptions
    // which say otherwise, and for LOCATION_FORWARD responses.
    //
    return;
    /* NOTREACHED */
    break;
    }
    // ... error if unconsumed data remains; is this the spot to test that?
}

static void
marshal(IOFieldList field_list, long *iiop_info, const void *data,
	CDR *stream, type_info_p type_info_table, CORBA_Environment &env);

extern "C" 
void send_request_msg(opaque *key, int method_id, otl_class_info obj_info,
		      void *param_struct, int fd, int my_request_id,
		      int do_rsvp, int version, otl_handle handle)
{
    iiop_init();
    CORBA_Environment *env_p = new (1) CORBA_Environment;
    unsigned char		buf [CDR::DEFAULT_BUFSIZE];
    CDR *stream = new CDR(&buf [0], sizeof buf);
    if (start_message (Request, *stream, version) != CORBA_B_TRUE) {
//	env.exception (new CORBA_MARSHAL (COMPLETED_NO));
	return;
    }
    iiop_call_info this_call_info = (iiop_call_info) 
	malloc(sizeof(*this_call_info));

    static CORBA_Principal_ptr	anybody = 0;
    COBS_sequence	svc_ctx;
    svc_ctx._length = svc_ctx._maximum = 0;
    svc_ctx._buffer = NULL;
    if (CDR::encoder (TC_ServiceContextList, 0, &svc_ctx, stream, *env_p)
		!= CORBA_TypeCode::TRAVERSE_CONTINUE)
	return;

    if (!stream->put_ulong (my_request_id) || !stream->put_boolean (do_rsvp)) {
//	env.exception (new CORBA_MARSHAL (COMPLETED_NO));
	return;
    }

    if (CDR::encoder (TC_opaque_p, key, 0, stream, *env_p)
		!= CORBA_TypeCode::TRAVERSE_CONTINUE
	    || CDR::encoder (_tc_CORBA_String, 
			     &obj_info->methods[method_id].name, 0, stream, 
			     *env_p)
		!= CORBA_TypeCode::TRAVERSE_CONTINUE
	    || CDR::encoder (_tc_CORBA_Principal, &anybody, 0, stream, *env_p)
	!= CORBA_TypeCode::TRAVERSE_CONTINUE) {
	return;		// right after fault
    }

    // in and in/out parameters
    if (obj_info->methods[method_id].input_fields != NULL) {
	if (iiop_verbose) {
	    printf("Marshalling in and in/out parameters\n");
	}
	marshal(obj_info->methods[method_id].input_fields, 
		obj_info->methods[method_id].iiop_info,
		param_struct, stream, obj_info->type_info_table,
		*env_p);
    } else {
	if (iiop_verbose) {
	    printf("No in or in/out parameters for marshalling\n");
	}
    }
    this_call_info->env_p =env_p;
    this_call_info->obj_info = obj_info;
    this_call_info->method_id = method_id;
    this_call_info->return_stream = NULL;
    this_call_info->handle = handle;
    handle->termination_data = this_call_info;
    DECondition_set_client_data(otl_private_de, my_request_id, 
				(void *)this_call_info);
    (void) send_message(*stream, fd);
    if (stream->do_free) free(stream->real_buffer);
    free(stream);
}

extern "C" {
extern void get_obj_iiop_info(void *obj, char **host, short *port,
			      void **opaque, int *version_p);
}


typedef struct iiop_call_struct {
    CDR	*stream;
    method_info *method_info_p;
    type_info_p type_info_table;
    int fd;
    void *params;
} *iiop_call_p;

static void
unmarshal(IOFieldList field_list, long *iiop_info, const void *data,
	  CDR *stream, type_info_p type_info_table, CORBA_Environment &env);

extern "C" void
remote_iiop_call_terminating(otl_handle handle, void *void_param)
{
    iiop_call_info iiop_data = (iiop_call_info) void_param;
    method_info *this_method_info;
    this_method_info = &iiop_data->obj_info->methods[iiop_data->method_id];
    if ((iiop_data->reply_status == NO_EXCEPTION) && 
	(this_method_info->return_fields != NULL)) {
	void *return_block;
	int return_block_len =
	    struct_size_field_list(this_method_info->return_fields,
				   sizeof(char*));
	return_block = malloc(return_block_len);
	unmarshal(this_method_info->return_fields,
		  this_method_info->iiop_return_info, return_block, 
		  iiop_data->return_stream,
		  iiop_data->obj_info->type_info_table, *iiop_data->env_p);
	handle->return_block = return_block;
	handle->return_block_len = -1;/* flag for not encoded return */
    }
}

extern "C" void
write_iiop_termination(otl_handle handle, void *void_param)
{
    iiop_call_p iiop_data = (iiop_call_p) void_param;
    CORBA_Environment *env_p = new (1) CORBA_Environment;
    void *return_struct = handle->stack_internal_return;
    // exception stuff
    
    // if no exception
    iiop_data->stream->put_ulong (0);  // GIOP::NO_EXCEPTION

    // return value, out and in/out parameters
    if (iiop_data->method_info_p->return_fields != NULL) {
	marshal(iiop_data->method_info_p->return_fields, 
		iiop_data->method_info_p->iiop_return_info,
		return_struct, iiop_data->stream, iiop_data->type_info_table,
		*env_p);
    }
    (void) send_message(*iiop_data->stream, iiop_data->fd);
    free(iiop_data->stream);
    free(iiop_data);
    if (iiop_verbose)
	printf("Done with IIOP invocation\n");
}

typedef struct {
    otl_obj_info *object_info;
    attr_list base_reference;
} *base_obj;

static void
handle_request (RequestHeader *req, opaque  *object_key, CDR *req_body, 
		CDR *reply, int fd, CORBA_Environment &env)
{
    base_obj obj;
    void * data;

    if (strcmp(req->operation, "_is_a") == 0) {
	reply->put_ulong (0 /* GIOP::NO_EXCEPTION */);
	reply->put_boolean (1);
	send(fd, (char *)reply->buffer, reply->next - reply->buffer, 0);
	free(reply);
	return;
    }

    sscanf((const char *)object_key->buffer, "%16lx", (unsigned long *)&obj);
    int method = 0;
    while(strcmp(obj->object_info->methods[method].name, req->operation) != 0) {
	method++;
    }
    if (iiop_verbose)
	printf("method \"%s\" is %d\n", req->operation, method);
    if (obj->object_info->methods[method].input_fields != NULL) {
	data = malloc(struct_size_field_list(obj->object_info->methods[method].input_fields, sizeof(char*)));
    } else {
	data = NULL;
    }
    unmarshal(obj->object_info->methods[method].input_fields,
	      obj->object_info->methods[method].iiop_info, data, req_body,
	      obj->object_info->type_info_table, env);

    iiop_call_p iiop_data = 
	(iiop_call_p)malloc(sizeof(struct iiop_call_struct));
    iiop_data->fd = fd;
    iiop_data->stream = reply;
    iiop_data->method_info_p = &(obj->object_info->methods[method]);
    iiop_data->params = data;
    iiop_data->type_info_table = obj->object_info->type_info_table;
    {
	otl_handle  handle = get_otl_handle();
	attr_list this_invoke_attrs = create_attr_list(), base_ref;
	static atom_t otl_dispatch_addr = 0;
	static atom_t otl_is_threaded = 0;
	if (otl_dispatch_addr == 0) {
	    otl_is_threaded = attr_atom_from_string("OTL:IS_THREADED");
	    otl_dispatch_addr = attr_atom_from_string("OTL:DISPATCH_ADDRESS");
	}
	add_attr(this_invoke_attrs, otl_dispatch_addr, Attr_Int4,
		 (attr_value) (long) obj->object_info->vf_table[method]);
	add_attr(this_invoke_attrs, otl_is_threaded, Attr_Int4,
		 (attr_value) 1);
	
	handle->local_pb = data;
	handle->plen = 0;
	handle->pblock = NULL;
	handle->pvector = NULL;
	handle->ref_count = 1;
	handle->termination_handler = write_iiop_termination;
	handle->termination_data = iiop_data;
	base_ref = attr_join_lists(obj->base_reference, 
				   this_invoke_attrs);
	free_attr_list(this_invoke_attrs);
	otl_handle_invocation(base_ref, handle);
	free_attr_list(base_ref);
    }
}





/* 
 * Accept socket connection from other data exchs.
 */

extern void
iiop_accept_conn_sock(DExchange de, int conn_sock)
{
    int sock;

    struct linger linger_val;

    linger_val.l_onoff = 1;
    linger_val.l_linger = 60;
    if (de == NULL)
	return;
    if ((sock = accept(conn_sock, (struct sockaddr *) 0, (socklen_t *) 0)) == SOCKET_ERROR) {
	fprintf(stderr, "Cannot accept socket connection\n");
	return;
    }
    if (setsockopt(sock, SOL_SOCKET, SO_LINGER, (char *) &linger_val,
		   sizeof(struct linger)) != 0) {
	perror("set SO_LINGER");
	return;
    }
#ifdef TCP_NODELAY
    {
	/* added by Arno Schoedl schoedl@usa.net */
	int delay_value = 1;
	setsockopt(sock, IPPROTO_TCP, TCP_NODELAY, (char *) &delay_value,
		   sizeof(delay_value));
    }
#endif

    DExchange_add_select(de, sock, (GenericHandlerFunc) iiop_message_handler,
			 (void*)sock, de);
}

extern "C" void
otl_setup_iiop_listen(DExchange de)
{
#if defined(HAVE_GETSOCKNAME_WITH_SIZE_T) && !defined(HAVE_WINDOWS_H)
    size_t length;
#else
    int length;
#endif
    struct sockaddr_in sock_addr;
    int sock_opt_val = 1;
    int conn_sock;
    u_short port_num = 0;

    conn_sock = socket(AF_INET, SOCK_STREAM, 0);
    if (conn_sock == SOCKET_ERROR) {
	fprintf(stderr, "Cannot open INET socket\n");
	return;
    }
    sock_addr.sin_family = AF_INET;
    sock_addr.sin_addr.s_addr = INADDR_ANY;
    sock_addr.sin_port = htons(port_num);
    if (setsockopt(conn_sock, SOL_SOCKET, SO_REUSEADDR, (char *) &sock_opt_val,
		   sizeof(sock_opt_val)) != 0) {
	fprintf(stderr, "Failed to set 1REUSEADDR on INET socket\n");
	return;
    }
    if (bind(conn_sock, (struct sockaddr *) &sock_addr,
	     sizeof sock_addr) == SOCKET_ERROR) {
	fprintf(stderr, "Cannot bind INET socket\n");
	return;
    }
    sock_opt_val = 1;
    if (setsockopt(conn_sock, SOL_SOCKET, SO_REUSEADDR, (char *) &sock_opt_val,
		   sizeof(sock_opt_val)) != 0) {
	perror("Failed to set 2REUSEADDR on INET socket");
	return;
    }
    length = sizeof sock_addr;
    if (getsockname(conn_sock, (struct sockaddr *) &sock_addr, &length) < 0) {
	fprintf(stderr, "Cannot get socket name\n");
	return;
    }
    /* begin listening for conns and set the backlog */
    if (listen(conn_sock, FD_SETSIZE)) {
	fprintf(stderr, "listen failed\n");
	return;
    }
    otl_private_iiop_port = ntohs(sock_addr.sin_port);

    /* No general PBIO handling, just call our handler if read possible */
    DExchange_add_select(de, conn_sock,
			 (GenericHandlerFunc) iiop_accept_conn_sock,
			 (void *) de, (void *) conn_sock);

    /* in the event the DE is shut down, close the socket */
    /* 
     *  -- Don't do this...  Close() seems to hang on sockets after 
     *  listen() for some reason.  I haven't found anywhere that defines 
     *  this behavior, but it seems relatively uniform. 
     */
    /* DExchange_add_close(de, close_socket_fd, (void*)conn_sock, NULL); */

    return;
}

static int
get_long(char *where, int byte_order)
{
    if (byte_order == OUR_BYTE_ORDER) {
	return *((int*)where);
    } else {
	int ret;
	char *retp = (char*)&ret;
	retp[0] = where[3];
	retp[1] = where[2];
	retp[2] = where[1];
	retp[3] = where[0];
	return ret;
    }
}

typedef struct {
   unsigned long _maximum;
   unsigned long _length;
   void *_buffer;
} *CORBA_sequence_p;


type_info_p
get_subtype(char *name, type_info_p type_info_table)
{
    while (strcmp(type_info_table->name, name) != 0) {
	type_info_table++;
    }
    return type_info_table;
}

static void
unmarshal_field(IOFieldList field, long *typecode_p,
		const void *data, CDR *stream, 
		type_info_p type_info_table, CORBA_Environment &env)
{
    int continue_decoding = CORBA_B_TRUE;

    switch (*typecode_p) {
    case tk_sequence: {

        CORBA_ULong length;
	unsigned int i, subsize;
	char *subdata;
	type_info_p subtype_info;
	char *element_name = (char*) malloc(strlen(field->field_type) - 13);
	
	if (continue_decoding)
	  continue_decoding = stream->get_ulong(length);
	strcpy(element_name, field->field_type + 15);
	element_name[strlen(element_name) -2] = 0; /* truncate _0 */
	subtype_info = get_subtype(element_name, type_info_table);
	subsize = struct_size_field_list(subtype_info->field_list, 
					 sizeof(char*));
	subdata = (char*)malloc(subsize * length);
	((CORBA_sequence_p)data)->_maximum = length;
	((CORBA_sequence_p)data)->_length = length;
	((CORBA_sequence_p)data)->_buffer = subdata;
	
	for (i=0; i< length; i++) {
	    unmarshal(subtype_info->field_list, subtype_info->iiop_info,
subdata + i*subsize, stream,
		      type_info_table, env);
	}
	break;
    } 
    case tk_string: {
	char *string;
	CDR::decoder (_tc_CORBA_String, &string, 0, stream, env);
	*((char**) data) = string;
	break;
    }
    case tk_objref: {
	CDR::decoder(_tc_CORBA_Object, data, 0, stream, env);
	{ 
	    char *tmp;
	    tmp = obj_ref_to_string(*(object_ref*)data);
	    *((char**)data) = tmp;
	}

// 	char *hint;
// 	printf("Doing object ref\n");
// 	CDR::decoder (_tc_CORBA_String, &hint, 0, stream, env);

// 	unsigned long profiles;
// 	continue_decoding = stream->get_ulong(profiles);
// 	printf("Getting %d profiles\n", profiles);
// 	if (profiles == 0) {
// 	    *((void **)data) = NULL;
// 	    return;
// 	}
// 	while (profiles-- != 0) {
// 	    unsigned long tmp;
// 	    stream->get_ulong(tmp);
// 	    if (tmp != 0) {   //  0 is iiop
// 		continue_decoding = stream->skip_string ();
// 		continue;
// 	    }
// 	    unsigned long len;
// 	    stream->get_ulong(len);
// 	    printf("Length is %d\n", len);
// 	    unsigned char iiop_major_version, iiop_minor_version;
// 	    stream->get_octet(iiop_major_version);
// 	    stream->get_octet(iiop_minor_version);
// 	    printf("major = %d, minor = %d\n", iiop_major_version,
// 		   iiop_minor_version);
// 	    unsigned long host_len;
// 	    char host[256];
// 	    int i;
// 	    for(i=0; i< host_len; i++) {
// 		continue_decoding = stream->get_char (host[i]);
// 	    }
// 	    host[i] = 0;
// 	    printf("Host is %s\n", host);
// 	    unsigned short port;
// 	    stream->get_ushort (port);
// 	    printf("port is %d\n", port);
// 	}
	break;
    } 
    case tk_null:
    case tk_void:
	// nothing to decode!
	break;
	
    case tk_char:
    case tk_octet:
	if (continue_decoding)
	  continue_decoding = stream->get_char (*(CORBA_Char *)data);
 	break;

    case tk_short:
    case tk_ushort:
	if (continue_decoding)
	  continue_decoding = stream->get_short (*(short *)data);
 	break;

    case tk_long:
    case tk_ulong:
    case tk_float:
	if (continue_decoding)
	  continue_decoding = stream->get_long (*(CORBA_Long *)data);
 	break;

    case tk_longlong:
    case tk_ulonglong:
    case tk_double:
	if (continue_decoding)
	  continue_decoding = stream->get_longlong (*(CORBA_LongLong *)data);
 	break;

    case tk_boolean:
	int b;
	if (continue_decoding)
	  continue_decoding = stream->get_boolean (b);
	*(char*)data = b;
 	break;
	
    case tk_enum:
    {
	CORBA_ULong	val;
	//
	// NOTE assumption that this is in-range.
	//
	// XXX should check this, it's rather hard to recover
	// from such errors since they "do not occur" and are
	// essentially never tested for.
	//
	if (continue_decoding)
	  continue_decoding = stream->get_ulong (val);
	*(unsigned *)data = (unsigned) val;
    }
    break;
    case tk_struct:
    {
	type_info_p subtype_info;
	subtype_info = get_subtype((char*)field->field_type, type_info_table);
	unmarshal(subtype_info->field_list, subtype_info->iiop_info,
		  data, stream, type_info_table, env);
	break;
    }
    default:
	printf("unhandled case in unmarshall, %s\n", field->field_type);
    }
}

void
unmarshal (
    IOFieldList field_list,
    long *iiop_info,
    const void		*data,
    CDR			*stream,
    type_info_p		type_info_table,
    CORBA_Environment &env
){
    
    int i = 0;
    char *tmp_data;
    if (field_list == NULL) return;
    while (field_list[i].field_name != NULL) {
	tmp_data = ((char*)data) + field_list[i].field_offset;
	if (iiop_info[i] == tk_array) {
	    array_info_p array_info;
	    int j;

	    i++;
	    array_info = (array_info_p) iiop_info[i];
	    tmp_data = ((char*)data) + field_list[i].field_offset;
	    *((void**)tmp_data) = 
		malloc(array_info->array_size * field_list[i].field_size);
	    tmp_data = *((char**)tmp_data);
	    for (j=0; j< array_info->array_size; j++) {
		unmarshal_field(&field_list[i], &array_info->tc_base_type,
			      tmp_data, stream, type_info_table, env);
		tmp_data += field_list[i].field_size;
	    }
	} else if ((iiop_info[i] >= tk_null) && 
		   (iiop_info[i] <= TC_KIND_COUNT)) {
	    unmarshal_field(&field_list[i], &iiop_info[i],
			    tmp_data, stream, type_info_table, env);
	} else {
	    /* must be pointer in that spot */
	    if (*((int*)iiop_info[i]) == tk_array) {
		array_info_p array_info;
		int element_size;
		int j;

		/* this only happens for static arrays */
		array_info = (array_info_p) iiop_info[i];
		element_size = field_list[i].field_size / 
		  array_info->array_size;

		for (j=0; j< array_info->array_size; j++) {
		    unmarshal_field(&field_list[i], 
				    &array_info->tc_base_type,
				    tmp_data, stream, type_info_table, env);
		    tmp_data += element_size;
		}
	    } else {
		fprintf(stderr, "Unknown typecode in pointer %d\n",
			*((int*)iiop_info[i]));
	    }
	}
	i++;
    }
}

static void
marshal_field(IOFieldList field, long *typecode_p,
	      const void *data, CDR *stream, 
	      type_info_p type_info_table, CORBA_Environment &env)
{
    int continue_decoding = CORBA_B_TRUE;

    switch(*typecode_p) {
    case tk_sequence: {

	unsigned int i, subsize;
	CORBA_ULong length = ((CORBA_sequence_p)data)->_length;
	char *subdata;
	type_info_p subtype_info;
	char *element_name = (char*) malloc(strlen(field->field_type) - 13);
	
	if (continue_decoding)
	  continue_decoding = stream->put_ulong(length);
	strcpy(element_name, field->field_type + 15);
	element_name[strlen(element_name) -2] = 0; /* truncate _0 */
	subtype_info = get_subtype(element_name, type_info_table);
	subsize = struct_size_field_list(subtype_info->field_list, 
					 sizeof(char*));
	subdata = (char*)((CORBA_sequence_p)data)->_buffer;
	for (i=0; i< length; i++) {
	    marshal(subtype_info->field_list, subtype_info->iiop_info,
		    subdata + i*subsize, stream,
		      type_info_table, env);
	}
	break;
    } 
    case tk_string: {
	CDR::encoder (_tc_CORBA_String, data, 0, stream, env);
	break;
    } 
    case tk_objref: {
	CDR::encoder(_tc_CORBA_Object, data, 0, stream, env);
	break;
    } 
    case tk_null: case tk_void:
	// nothing to encode
	break;
    case tk_char:
    case tk_octet:
	stream->put_char(*(char*)data);
	break;
    case tk_short:
    case tk_ushort:
	stream->put_short (*(short *)data);
	break;

    case tk_long:
    case tk_ulong:
    case tk_float:
	stream->put_long (*(long *)data);
	break;

    case tk_double:
    case tk_longlong:
    case tk_ulonglong:
        stream->put_longlong (*(double *)data);
	break;

    case tk_boolean: {
	int b = *(char*)data;
	stream->put_boolean (b);
	break;
    }
    case tk_enum:
    {
	//
	// NOTE assumption that this is in-range.
	//
	// XXX should check this, it's a hard-to-recover error
	// for the other side
	//
	unsigned	value = *(unsigned *)data;
	stream->put_ulong (value);
    }
    break;
    
    case tk_struct:
    {
	type_info_p subtype_info;
	subtype_info = get_subtype((char*)field->field_type, type_info_table);
	marshal(subtype_info->field_list, subtype_info->iiop_info,
		  data, stream, type_info_table, env);
	break;
    }
    default:
	printf("Unhandled case in marshal %s\n", field->field_type);
    }
    (void)continue_decoding;
}

void
marshal (
    IOFieldList field_list,
    long *iiop_info,
    const void		*data,
    CDR			*stream,
    type_info_p		type_info_table,
    CORBA_Environment &env
){
    
    int i = 0;
    char *tmp_data;
    if (field_list == NULL) return;
    while (field_list[i].field_name != NULL) {
	tmp_data = ((char*)data) + field_list[i].field_offset;
	if (iiop_info[i] == tk_array) {
	    array_info_p array_info;
	    int array_size = *((int*)tmp_data);
	    int j;

	    i++;
	    array_info = (array_info_p) iiop_info[i];
	    tmp_data = ((char*)data) + field_list[i].field_offset;
	    tmp_data = *((char**) tmp_data);
	    for (j=0; j< array_size; j++) {
		marshal_field(&field_list[i], &array_info->tc_base_type,
			      tmp_data, stream, type_info_table, env);
		tmp_data += field_list[i].field_size;
	    }
	} else if ((iiop_info[i] >= tk_null) && 
		   (iiop_info[i] <= TC_KIND_COUNT)) {
	    marshal_field(&field_list[i], &iiop_info[i],
			  tmp_data, stream, type_info_table, env);
	} else {
	    /* must be pointer in that iiop_info spot */
	    if (*((int*)iiop_info[i]) == tk_array) {
		array_info_p array_info;
		int element_size;
		int j;

		/* this only happens for static arrays */
		array_info = (array_info_p) iiop_info[i];
		element_size = field_list[i].field_size / 
		  array_info->array_size;
		for (j=0; j< array_info->array_size; j++) {
		    marshal_field(&field_list[i], 
				  &array_info->tc_base_type,
				  tmp_data, stream, type_info_table, env);
		    tmp_data += element_size;
		}
	    } else {
		fprintf(stderr, "Unknown typecode in pointer %d\n",
			*((int*)iiop_info[i]));
	    }
	}
	i++;
    }
}

static inline
unsigned char
hex2byte (char c)
{
    if (isdigit (c))
	return (unsigned char) (c - '0');
    else if (islower (c))
	return (unsigned char) (10 + c - 'a');
    else
	return (unsigned char) (10 + c - 'A');
}

static const char xchars [] = "0123456789abcdef";
#define nibble2hex(val) (xchars[val & 0x0f])

static char*
ior_object_to_string(
    char *cobs_obj_ref,
    CORBA_Environment &env)
{
    char *return_str;
    int i;
    size_t buflen;
    CDR			*stream = new CDR;

    CDR::encoder (_tc_CORBA_Object, &cobs_obj_ref, 0, stream, env);

    buflen = stream->next - stream->buffer;
    return_str = (char*)malloc(buflen*2 + strlen("IOR:") + 2);
    strcpy(return_str, "IOR:");
    char *encoded_str = return_str + strlen(return_str);
    for (i=0; i<buflen; i++) {
	encoded_str[2*i] = nibble2hex(stream->buffer[i] >> 4);
	encoded_str[2*i + 1] = nibble2hex(stream->buffer[i]);
    }
    encoded_str[2*i] = 0;

    if (stream->do_free) free(stream->real_buffer);
    free(stream);
    return return_str;
}
    
extern "C" char *
obj_ref_to_ior(object_ref obj)
{
    CORBA_Environment *env_p = new (1) CORBA_Environment;
    char *str = NULL, *ior_str;

    iiop_init();
    str = obj_ref_to_string(obj);
    ior_str = ior_object_to_string(str, *env_p);
    free(env_p);
    free(str);
    return ior_str;
}


static object_ref
ior_string_to_object (
    char *	str,
    CORBA_Environment	&env
)
{
    //
    // Unhex the bytes, and make a CDR deencapsulation stream
    // from the resulting data.
    //
    unsigned char	*buffer = (unsigned char*)malloc(1 + strlen ((char *) str) / 2);
    char		*tmp = (char *)str;
    size_t		len = 0;
    
    while (tmp [0] && tmp [1]) {
	unsigned char	byte;

	if (!(isxdigit (tmp [0]) && isxdigit (tmp [1])))
	    break;

	byte = (unsigned char) (hex2byte (tmp [0]) << 4);
	byte |= hex2byte (tmp [1]);

	buffer [len++] = byte;
	tmp += 2;
    }
    if (tmp [0] && !isspace (tmp [0])) {
	free( buffer);
//	env.exception (new CORBA_BAD_PARAM (COMPLETED_NO));
	return 0;
    }

    //
    // Create deencapsulation stream ... then unmarshal objref
    // from that stream.
    //
    CDR			*stream = new CDR;
    object_ref	objref;
    
    stream->setup_encapsulation (buffer, len);
    if (CDR::decoder (_tc_CORBA_Object, &objref, 0, stream, env)
	    != CORBA_TypeCode::TRAVERSE_CONTINUE) {
	objref = 0;
    }

    free( stream);
    free( buffer);
    return objref;
}

extern "C" {
extern object_ref
COBS_string_to_object(char *name)
{
    CORBA_Environment *env_p = new (1) CORBA_Environment;
    iiop_init();
    name += 4;  /* skip IOR */
    return ior_string_to_object(name, *env_p);
}

#define HAS_STRUCT_HOSTENT
static int
check_host(char *hostname, void *sin_addr)
{
#ifdef HAS_STRUCT_HOSTENT
    struct hostent *host_addr;
    host_addr = gethostbyname(hostname);
    if (host_addr == NULL) return 0;
    memcpy(sin_addr, host_addr->h_addr, host_addr->h_length);
    return 1;
#else
    /* VxWorks ? */
    *((int *)sin_addr) = hostGetByName(hostname);
    return (*(int*)sin_addr) != -1;
#endif
}

typedef struct {
    char *host;
    int port;
    int fd;
} port_entry;

static int port_count = 0;
static port_entry *port_list = NULL;

static
int find_existing_conn(char *host, int port)
{
    int i;
    for (i=0; i < port_count; i++) {
	if ((strcmp(port_list[i].host, host) == 0) && 
	    (port_list[i].port == port)) return port_list[i].fd;
    }
    return -1;
}

static
void add_conn(char *host, int port, int fd)
{
    if (port_count == 0) {
	port_list = (port_entry*)malloc(sizeof(port_entry));
    } else {
	port_list = (port_entry*)realloc(port_list,
					 (port_count+1)*sizeof(port_entry));
    }
    port_list[port_count].host = strdup(host);
    port_list[port_count].port = port;
    port_list[port_count].fd = fd;
    port_count++;
}

extern 
int get_iiop_connection(DExchange de, char *host, int port)
{
    int sock;
    struct linger linger_val;
    int sock_opt_val = 1;
    u_short port_num = port;

    if ((sock = find_existing_conn(host, port)) != -1) return sock;

    linger_val.l_onoff = 1;
    linger_val.l_linger = 60;
    
    /* INET socket connection, name_str is the machine name */
    struct sockaddr_in sock_addr;
    if ((sock = socket(AF_INET, SOCK_STREAM, 0)) == SOCKET_ERROR) {
	return 0;
    }
    sock_addr.sin_family = AF_INET;
    if (check_host(host, (void*)&sock_addr.sin_addr) == 0) {
	return 0;
    }
    sock_addr.sin_port = htons(port_num);
    if (connect(sock, (struct sockaddr *) &sock_addr,
		sizeof sock_addr) == SOCKET_ERROR) {
#ifdef WSAEWOULDBLOCK
	int err = WSAGetLastError();
	if (err != WSAEWOULDBLOCK || err != WSAEINPROGRESS)
#endif
	return 0;
    }
    sock_opt_val = 1;
    setsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, (char *) &sock_opt_val,
	       sizeof(sock_opt_val));
    setsockopt(sock, SOL_SOCKET, SO_LINGER, (char *) &linger_val,
	       sizeof(struct linger));

#ifdef TCP_NODELAY
    {
	/* added by Arno Schoedl schoedl@usa.net */
	int delay_value = 1;

	setsockopt(sock, IPPROTO_TCP, TCP_NODELAY, (char *) &delay_value,
		   sizeof(delay_value));
    }
#endif
    DExchange_add_select(de, sock, (GenericHandlerFunc) iiop_message_handler,
			 (void*)sock, de);
    add_conn(host, port, sock);
    return sock;
}
}
