/*
 * IDLtoC.c
 */

#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <assert.h>

#include "io.h"
#include "DE.h"
#include "otl.h"
#include "./unix_defs.h"

void * COBS_alloc(size)
int size;
{
    char *tmp = malloc(size);
    if (tmp == NULL) fprintf(stderr, "Out of memory\n");
    return tmp;
}

void * COBS_realloc(ptr, size)
void *ptr;
int size;
{
    char *tmp = realloc(ptr, size);
    if (tmp == NULL) fprintf(stderr, "Out of memory\n");
    return tmp;
}

void COBS_free(ptr)
void* ptr;
{
  free((char *) ptr);
}


void error(msg)
char *msg;
{
  printf("Error: %s\n", msg);
  exit(1);
}

char *COBS_return_string(st, st_maximum)
char *st;
int st_maximum;
{
  char *newst;
  int   max;

  /* This is not as simple as it seems. The amount "st_maximum" is not
     really  the maximum possible size for the string, since the
     declaration may just have let it out. So we have to check for real
     size of the string being returned */
  if (st == NULL)
    return(NULL);
  else
    if ((max = strlen(st)) < st_maximum)
      max = st_maximum;

  newst = COBS_alloc((max+1)*sizeof(char));

  strcpy(newst, st);   /* st is not NULL, neither is newst */
  return(newst);
}

void COBS_assign_string(stto, stfrom, stfrom_maximum)
char **stto;
char *stfrom;
int stfrom_maximum;
{
  /* A big mess can occur if this is called with a "crazy" stto pointer,
     i.e., if the attribute structure  is not initialized before this
     function being called
     */
  int max;
  
  if (stfrom == NULL) {
    *stto = NULL;
    return;
  }
  else
    if ( (max = strlen(stfrom)) < stfrom_maximum)
      max = stfrom_maximum;

  if (*stto == NULL) {
      *stto = COBS_alloc((max+1)*sizeof(char));
  } else {
      *stto = COBS_realloc((void*)*stto, (max+1)*sizeof(char));
  }
  strcpy(*stto, stfrom);
}


void COBS_assign_sequence(left_side, right_side, basetypesize)
COBS_sequence *left_side;
COBS_sequence *right_side;
int basetypesize;
{
  /* I am going to assume that the sequence being assigned was
     initialized. I will provide the routine COBS_init_sequence so the
     user has a better way to deal with sequences ... But the user still
     has to set up the lenght accordingly.
     */
  if (left_side->_buffer == NULL) {
      /* not checking to see if maximum is zero */
      left_side->_buffer = COBS_alloc(basetypesize*right_side->_maximum);
  } else {
      left_side->_buffer = COBS_realloc((void*)left_side->_buffer, 
					basetypesize*right_side->_maximum);
  }
  /* again, not checking if the buffers are NULL, since the user should
     have initialized the sequence before using it!*/
  memcpy(  (char *) left_side->_buffer, 
	   (char *) right_side->_buffer,right_side->_length*basetypesize);
  left_side->_maximum = right_side->_maximum;
  left_side->_length  = right_side->_length;
}

void COBS_init_sequence(seq, maximum, basetypesize)
COBS_sequence *seq;
long maximum;
int basetypesize;
{
  seq->_maximum = maximum;
  seq->_length  = 0;
  /* allocate buffer */
  seq->_buffer = CORBA_alloc(maximum*basetypesize);
}

void _COBS_support_for_IDL_context(op_context, ob_context, name_in_context)
CORBA_Context op_context;
CORBA_Context ob_context;
char *name_in_context;
{
  int r;
  atom_t attr_id;
  attr_value_type value_type;
  attr_value value;
  
  attr_id = attr_atom_from_string(name_in_context);
  /* we have to search for context information about "name_in_context"
     and pass it to op_context 
     */
  switch ((r = query_attr(ob_context, attr_id, &value_type, &value))) {
  case 1: 
    /* object context does have value for this context item */
    add_attr(op_context, attr_id, value_type, value);
    break;
  case 0:
    /* object context does not have information regarding this context
       element. We do nothing about it. */
    break;
  default:
    printf("ERROR: in _COBS_support_for_IDL_context(argument %s) \n",
	   name_in_context);
    printf("       value returned from query_attr (%d) inexpected.\n",
	   r);
  }
}


/*
 * COBS_create_Environment_object
 *   returns (in the argument) pointer to a newly created
 *       CORBA_Environment object  
 * returns a cobs_result
 */
extern DExchange otl_private_de;

void COBS_init_Environment_object(ev)
CORBA_Environment *ev;
{
    if (otl_private_de == NULL) {
	fprintf(stderr, "Must initialize COBS before initializing CORBA_Environment!\n");
	return;
    }
    ev->op_attr_list = create_attr_list();
    ev->instanceData = NULL;
    ev->instanceDataSaveAddr = NULL;
    ev->_major = CORBA_NO_EXCEPTION;
    ev->_minor = NULL;
    ev->exception_data = NULL;
}

/*
 * COBS_create_Environment_object
 *   returns (in the argument) pointer to a newly created
 *       CORBA_Environment object  
 * returns a cobs_result
 */
void COBS_create_Environment_object(ev)
CORBA_Environment **ev;
{
  *ev = COBS_alloc(sizeof(CORBA_Environment));
  COBS_init_Environment_object(*ev);
}

void COBS_free_Environment_object(ev)
CORBA_Environment *ev;
{
    free_attr_list(ev->op_attr_list);
}

extern void
CORBA_exception_set(ev, major, except_repos_id, param)
CORBA_Environment *ev;
CORBA_exception_type major;
char *except_repos_id;
void *param;
{
    ev->_major = major;
    ev->_minor = except_repos_id;
    ev->exception_data = param;
}

extern char *CORBA_exception_id(CORBA_Environment *ev)
{
    return ev->_minor;
}

extern void *CORBA_Exception_value(CORBA_Environment *ev)
{
    return NULL;
}

extern void CORBA_Exception_free(CORBA_Environment *ev)
{
    free(ev->exception_data);
}
