
#include "config.h"
#include <malloc.h>
#include <gen_thread.h>
#include "io.h"
#include "DE.h"
#ifdef USE_CTHREADS
#include "cthread.h"
#endif
#include <stdlib.h>
#include <stdio.h>

#include "otl.h"
#include "unix_defs.h"
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#define sleep(x) Sleep(1000)
#else
extern int sleep();
#endif

static int we_initialized = 0;
static void method ARGS((void *self, void *pblock, int plen, otl_handle handle));
static void method2 ARGS((void *self, void *pblock, int plen, void**pvector, otl_handle handle));


object_ref
init_func()
{
    /* THIS CODE HAS NOT BEEN KEPT UP TO DATE WITH CHANGES IN THE 
       COMPILER AND OTL.  IT IS UNLIKELY TO FUNCTION CORRECTLY. */


    /*
     *  This is the initial function for cobs_test.  It is only called once
     *  for every group of OTL processes.  That is, if you run cobs_test
     *  multiple times, this function will only be called by the process that
     *  *creates* the group.  (For a discussion of groups, see the document
     *  dataexchange/doc/group_services.3.)  The initial function *must*
     *  create an object and return a reference to it.  The object reference
     *  thus created is returned by init_cobs() in *every* process.  This is
     *  how a set of OTL processes get themselves bootstrapped.  Normally
     *  this first object would probably be a name server or some other kind
     *  of object that will facilitate further communication.  However, in
     *  cobs_test the object is simple.  In fact, the object itself isn't much
     *  more than a reference.  (Which is all that OTL cares about.  It pays
     *  attention to a few attributes and leaves the rest to other layers.)
     *  The details of the attributes which are used to create the reference
     *  to the initial object are beyond the scope of this comment, but for
     *  the moment, just assume that we're constructing an object reference in
     *  the variable "tmp" and returning it.
     */

    object_ref tmp;
    atom_t otl_dispatch_style_atom = 0;
    atom_t otl_vf_table_style_atom;
    atom_t otl_vf_table_atom;
    atom_t otl_method_id_atom;
    atom_t otl_is_threaded;

    char *name_str = malloc(24);
    void (**vf_table) ();

    sprintf(name_str, "initial object %lx", (long) getpid());

    tmp = otl_local_obj_ref();
    add_attr(tmp->obj_name, attr_atom_from_string("Object Name"), Attr_String,
	     name_str);
#ifdef DIRECT_DISPATCH
    otl_dispatch_addr = attr_atom_from_string("OTL:DISPATCH_ADDRESS");
    add_attr(tmp->obj_name, otl_dispatch_addr, Attr_Int4,
	     (attr_value) method);
#else
    vf_table = malloc(sizeof(vf_table[0]) * 20);

    vf_table[0] = method;
    otl_dispatch_style_atom = attr_atom_from_string("OTL:DISPATCH_STYLE");
    otl_vf_table_style_atom = 
      attr_atom_from_string("OTL:DISPATCH_BY_VIRTUAL_FUNCTION");
    otl_vf_table_atom =
      attr_atom_from_string("OTL:VIRTUAL_FUNCTION_TABLE_BASE");
    otl_method_id_atom =
      attr_atom_from_string("OTL:METHOD_ID");
    otl_is_threaded = attr_atom_from_string("OTL:IS_THREADED");

    add_attr(tmp->obj_name, otl_method_id_atom, Attr_Int4,
	     (attr_value) 0);
    add_attr(tmp->obj_name, otl_dispatch_style_atom, Attr_Atom,
	     (attr_value) otl_vf_table_style_atom);
    add_attr(tmp->obj_name, otl_vf_table_atom, Attr_Int4,
	     (attr_value) vf_table);
    add_attr(tmp->obj_name, otl_is_threaded, Attr_Int4,
	     (attr_value) 1);
#endif
    we_initialized = 1;
    return tmp;
}

object_ref
create_local_obj()
{
    /*  
     *  This function is used below to create a simple object.  The object has
     *  a name and two methods.  Method dispatch is through a virtual function
     *  table and the methods are threaded.  (To keep the code small, use the
     *  same function for both methods, we only call the second.)
     */
    object_ref tmp;
    atom_t otl_dispatch_style_atom = 0;
    atom_t otl_vf_table_style_atom;
    atom_t otl_vf_table_atom;
    atom_t otl_method_id_atom;
    atom_t otl_is_threaded;

    char *name_str = malloc(24);
    void (**vf_table) ();

    sprintf(name_str, "local object %lx", (long) getpid());

    tmp = otl_local_obj_ref();
    add_attr(tmp->obj_name, attr_atom_from_string("Object Name"), Attr_String,
	     name_str);
    vf_table = malloc(sizeof(vf_table[0]) * 20);

    vf_table[0] = method2;
    vf_table[1] = method2;
    otl_dispatch_style_atom = attr_atom_from_string("OTL:DISPATCH_STYLE");
    otl_vf_table_style_atom = 
      attr_atom_from_string("OTL:DISPATCH_BY_VIRTUAL_FUNCTION");
    otl_vf_table_atom =
      attr_atom_from_string("OTL:VIRTUAL_FUNCTION_TABLE_BASE");
    otl_method_id_atom =
      attr_atom_from_string("OTL:METHOD_ID");
    otl_is_threaded = attr_atom_from_string("OTL:IS_THREADED");

    add_attr(tmp->obj_name, otl_method_id_atom, Attr_Int4,
	     (attr_value) 0);
    add_attr(tmp->obj_name, otl_dispatch_style_atom, Attr_Atom,
	     (attr_value) otl_vf_table_style_atom);
    add_attr(tmp->obj_name, otl_vf_table_atom, Attr_Int4,
	     (attr_value) vf_table);
    add_attr(tmp->obj_name, otl_is_threaded, Attr_Int4,
	     (attr_value) 1);
    return tmp;
}

static int first = 1;

void
method(self, pblock, plen, handle)
void *self;
void *pblock;
int plen;
otl_handle handle;
{
    /*  
     *  This is the method of the initial object.  It doesn't really do much
     *  except print some stuff.  However, the very first time it gets invoked
     *  it grabs the string in its parameter block, converts it into an object
     *  reference (with obj_ref_from_string()) and tries to invoke it.  This
     *  demonstrates some parameter passing as well as bi-directional
     *  invocation.  It also should result in more printouts on the invoking
     *  host.   Also, the method invoked (method2() below) returns a value.
     *  If all goes well, we should print out "Returning from invoke method 2,
     *  value is 47". 
     */
    object_ref ref;
    otl_handle tmp_handle;
    attr_list method_attrs;
    atom_t otl_method_id_atom =
      attr_atom_from_string("OTL:METHOD_ID");
    int *return_block;
    int return_len;

    printf("I'm the method \n");
    printf("pblock is %lx, plen is %d\n", (long)pblock, plen);
    printf("string is %s\n", (char *)pblock);
    if (first) {
	first = 0;
	method_attrs = create_attr_list();
	ref = obj_ref_from_string((char*)pblock);
	add_attr(method_attrs, otl_method_id_atom, Attr_Int4, (attr_value)1);
	tmp_handle = otl_invoke(ref->obj_name, NULL, method_attrs, 0, 0);
	
	otl_wait(tmp_handle);
	printf("OTL wait returned\n");
	free_attr_list(method_attrs);
	dump_attr_list(otl_get_cache(tmp_handle));
	if (query_attr(otl_get_cache(tmp_handle), 
		       attr_atom_from_string("OTL:RETURN_BLOCK"),
		       NULL, (void**)&return_block)) {
	    printf("Returning from invoke method 2, value is %d\n", *return_block);
	}
	if (query_attr(otl_get_cache(tmp_handle), 
		       attr_atom_from_string("OTL:RETURN_LENGTH"),
		       NULL, (void**)&return_len)) {
	    printf("Returning from invoke method 2, len is %d\n", return_len);
	}
	/* return block is ours to free */
	free(return_block);
	otl_free_obj_ref(ref);
	otl_free_handle(tmp_handle);
    }
}

void
method2(self, pblock, plen, pvector, handle)
void *self;
void *pblock;
int plen;
void **pvector;
otl_handle handle;
{
    /*  
     *  This is the method for "local" objects that are created below.  It
     *  just prints out something and tries to return a value.
     */
    int *tmp = (int*) malloc(sizeof(int) + sizeof(IOEncodeVector*) * 2);
    IOEncodeVector return_vector = (IOEncodeVector)((char*)tmp) + sizeof(int);
    *tmp = 47;

    printf("I'm the second method \n");

    /*  
     *  Try to return a value from this method.  The value is 47 and it's held
     *  in a malloc block of its own.
     */
    return_vector[0].iov_base = tmp;
    return_vector[0].iov_len = sizeof(int);
    return_vector[1].iov_base = NULL;
    return_vector[1].iov_len = 0;
    add_attr(otl_get_cache(handle), 
	     attr_atom_from_string("OTL:RETURN_VECTOR"), Attr_Int4,
	     return_vector);
    add_attr(otl_get_cache(handle), 
	     attr_atom_from_string("OTL:FREE_BLOCK"), Attr_Int4,
	     (void*)tmp);
    
    sleep(5);
}

extern int de_data_debug_flag;

int
main(argc, argv)
int argc;
char **argv;
{
    /*  
     * the main function for cobs_test.  We'll follow through the flow.
     */
    DExchange de;
    int i;
    object_ref init_obj;
    char *str;
    object_ref new_obj;

#ifdef USE_CTHREADS
    /*  
     * if we're using Cthreads, this is a good idea.
     */
    argc = cthread_parse_args(argc, argv);
#endif
    if (argc > 1) {
	/* 
	 *  to help debugging, turn on the de_data_debug_flag if cobs_test is
         *  invoked with any arguments.
	 */
	de_data_debug_flag = 1;
    }
    /* use a null threads package.  I.E. forks are proc calls. */
    gen_null_init();

    /* setup a singlethreaded DataExchange */
    de = DExchange_create();
    DEControlList_set_control_style(DExchange_get_control_list(de),
				    DESingleThreaded);

    /*  
     *   Initialize.  argv[0] serves as the "application name" for the group.
     *   As described above, init_func only gets called in the process that
     *  creates the group.  But in *every* process the return value of
     *  init_cobs() is the reference that was created in that one call to
     *  init_func...
     */
    init_obj = init_cobs_DE(argv[0], init_func, de);

    /*  
     * print out the initial object reference for visual examination.
     */
    printf("initial object name is ");
    dump_attr_list(init_obj->obj_name);

    /* 
     * for kicks, convert it to a string and then convert it back again.
     */
    str = obj_ref_to_string(init_obj);
    printf("dumped object is %s\n", str);

    new_obj = obj_ref_from_string(str);
    printf("Re-created object is \n");
    /*  
     *  Dump the object reference again so we can see if it has survived the
     *  ref->string->ref process
     */
    dump_attr_list(new_obj->obj_name);

    /*  
     * Don't need these any more
     */
    free(str);
    otl_free_obj_ref(new_obj);
    
    printf(" object cache is ");
    dump_attr_list(init_obj->name_trans_cache);

    /* 
     *  just for testing, we write this oddly.  If we're the first guy, the
     *  guy who `owns' the initial object, we just want to hang around to let
     *  people invoke it.  If we're some other instance of cobs_test, we want
     *  to invoke the initial object.  Just how many times each of these occur
     *  depends both upon timing and whether or not we're using Cthreads or
     *  Pthreads.
     *    Under Cthreads, the server process only checks the network at a
     *  scheduling point, which is provided by the cthread_yield().  The
     *  sleep(1) keeps us around for at least 60 seconds, or 60 checks of the
     *  network.  Each check of the network may handle more than one
     *  invocation, but just how many it handles depends upon how many clients
     *  there are, etc.
     *    Under Pthreads, the network handler is a separate thread, so no
     *  yield is necessary and events are handled asynchronously.  But the
     *  sleep(1) in the for loop still keeps the server around for 60 seconds.
     *    Note:  Nobody necessarily terminates cleanly under this test.  It's
     *  not meant for clean termination.  It's written like this so we can fork
     *  dozens of these simultaneously and see if they all do something
     *  reasonable. 
     */
    for (i = 0; i < 60; i++) {
	if (! we_initialized) {
	    /*  
	     *  If we're not the first guy, invoke the initial object.  But
	     *  first, create an object and pass a reference to it as a
	     *  parameter to the initial object.  The initial object may
	     *  invoke it back (see above).
	     */
	    otl_handle handle;
	    object_ref local_obj = create_local_obj();
	    char *str = obj_ref_to_string(local_obj);
	    handle = otl_invoke(init_obj->obj_name, init_obj->name_trans_cache,
				(attr_list) 0, (void *) str, 
				strlen(str)+1);
	    printf(" object cache is ");
	    dump_attr_list(init_obj->name_trans_cache);
	    otl_wait(handle);
	    otl_free_obj_ref(local_obj);
	    otl_free_handle(handle);
	}else {
	    sleep(1);
	    cobs_poll();
	}
#ifdef USE_CTHREADS
	cthread_yield();
#endif
    }
    otl_free_obj_ref(init_obj);
    shutdown_cobs();
    return 0;
}
