/*
 * yield.c
 * Modification history:
 *
 * 1.0	3-May-88	Initial release.
 * 1.1	1-Nov-88	Add a delay statement which is condition compiled with
 *			the -DDELAYED. This is to avoid contention when there
 *			is no thread in the queue.
 *			Added support for the terminate field in local_info.
 * 1.2	1-Dec-88	The "#ifdef FAST" statements were added for supporting 
 *					_setjmp() calls.
 * 1.3	19-Apr-89	(Ahmed Gheith) Added cthread_sleep.
 * 1.4	21-Apr-89	(Ahmed Gheith) avoid spin locking on an empty queue
 *				in schedule_next
 * 1.5	27-May-89	(Ahmed Gheith) Added thread migration:
 *				- cthread_goto(node)
 *				- cthread_gohome()
 * 1.6   Bodhi Mukherjee	Added Implementation for Sun3/50.
 * 1.7   Bodhi Mukherjee	Added Implementation for Sun3/86.
 * 1.8   Bodhi Mukherjee	Added Implementation for Sparcs.
 * 1.9   Bodhi Mukherjee	Added Implementation for Sequent.
 *
 */

#include	"general.h"
#include	"lock.h"
#include	"queue.h"
#include	"sync.h"
#include	"internal.h"
#include	"hwlib.h"
#include	"arch_init.h"

extern  shared	struct  local_info  *processor;
extern  cthread_t           current_thread_array[MAX_PROC];
extern 		int 	            next_thread_type;

extern private sched_info_t   local_scheduler[MAX_PROC];

static void queue_and_schedule();

void
internal_cthread_yield()
{
    swap_context_with_func(queue_and_schedule, NULL);
}

static void
queue_and_schedule()
{
    int proc = virtual_processor();
    DBG1("yielding in node = %d\n", proc);
    (local_scheduler[proc]->sched_put_thread)(proc, current_thread_array[proc]);
    (local_scheduler[proc]->schedule)();
}
