/*
** this test just checks to see if the values of limits.h have changed.
** If they have, YOU MUST UPDATE THE MAN PAGE cthread_parse_args(3) 
** **** AND **** this file..
** Don't just update this file.  That would be stupid.  You don't want to 
** be stupid. 
*/
#include <stdio.h>
#include "../config.h"
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#ifndef PRINTF_DEFINED
#if defined(FUNCPROTO) || __STDC__ || defined(__cplusplus) || defined(c_plusplus)
extern int printf(const char *, ...);
#else
extern int printf();
#endif
#endif
#ifndef FPRINTF_DEFINED
#if defined(FUNCPROTO) || __STDC__ || defined(__cplusplus) || defined(c_plusplus)
extern int fprintf(FILE *, const char *, ...);
#else
extern int fprintf();
#endif
#endif
#ifndef SSCANF_DEFINED
#if defined(FUNCPROTO) || __STDC__ || defined(__cplusplus) || defined(c_plusplus)
extern int sscanf(const char *, const char *, ...);
#else
extern int sscanf();
#endif
#endif
#ifndef FSCANF_DEFINED
#if defined(FUNCPROTO) || __STDC__ || defined(__cplusplus) || defined(c_plusplus)
extern int fscanf(FILE *, const char *, ...);
#else
extern int fscanf();
#endif
#endif
static void read_limits();

int
main()
{

    char line[256];
    FILE *limits = fopen("../limits.h", "r");
    char *line_ptr;
    
    while ((line_ptr = fgets(line, 256, limits)) != NULL) {

	if (strncmp(line, "#ifdef", 6) == 0) {
	    char name[40];
	    if (sscanf(&line_ptr[7], "%s", name) != 1) {
		printf("couldn't get target name\n");
		continue;
	    }
	    if (strcmp(name, "__ksr__") == 0) {
		printf("reading KSR limits\n");
		read_limits(limits, 64, 20, 10240, -1);
	    } else if (strcmp(name, "__sgi") == 0) {
		printf("reading SGI limits\n");
		read_limits(limits, 64, 10, 10240, -1);
	    } else if (strcmp(name, "BUTTERFLY") == 0) {
		printf("reading Butterfly limits\n");
		read_limits(limits, 256, 20, 10240, 21);
	    } else if (strcmp(name, "sparc") == 0) {
		printf("reading SUN limits\n");
		read_limits(limits, 32, 10, 20480, 10);
	    } else if (strcmp(name, "_AIX") == 0) {
		printf("reading AIX limits\n");
		read_limits(limits, 32, 10, 10240, 10);
	    } else if (strcmp(name, "linux") == 0) {
		printf("reading Linux limits\n");
		read_limits(limits, 32, 10, 10240, 10);
	    } else if (strcmp(name, "HAVE_WINDOWS_H") == 0) {
		printf("reading NT limits\n");
		read_limits(limits, 32, 10, 10240, 10);
	    } else {
		printf("Unknown target in limits.h! >%s<\n", name);
	    }
	}
    }
    return 0;
}

static void
read_limits(limits, max_procs, threads, stack, memory_exp)
FILE *limits;
int max_procs;
int threads;
int stack;
int memory_exp;
{
    int value;
    char name[80];
    if (fscanf(limits, "#define %s %d \n", name, &value) != 2) {
	printf("read failed for MAX_PROC\n");
    } else {
	if ((strcmp(name, "MAX_PROC") != 0) ||
	    (value != max_procs)) {
	    printf("MAX_PROC doesn't match!\n");
	}
    }
    if (fscanf(limits, "#define %s %d \n", name, &value) != 2) {
	printf("read failed for THREADS_PER_PROCESSOR\n");
    } else {
	if ((strcmp(name, "THREADS_PER_PROCESSOR") != 0) ||
	    (value != threads)) {
	    printf("THREADS_PER_PROCESSOR doesn't match!\n");
	}
    }
    if (fscanf(limits, "#define %s %d \n", name, &value) != 2) {
	printf("read failed for STACKSIZE\n");
    } else {
	if ((strcmp(name, "STACKSIZE") != 0) || (value != stack)) {
	    printf("STACKSIZE doesn't match!\n");
	}
    }
    if (memory_exp != -1) {
	if (fscanf(limits, "#define %s %d \n", name, &value) != 2) {
	    printf("read failed for MEMORY_EXPONENT\n");
	} else {
	    if ((strcmp(name, "MEMORY_EXPONENT") != 0) || 
		(value != memory_exp)) {
		printf("MEMORY_EXPONENT doesn't match!\n");
	    }
	}
    }
}
