#include	"../config.h"
#ifdef HAVE_WINDOWS_H
#include	<windows.h>
#endif
#include        <stdio.h>
#include        <sys/types.h>
#include        "cthread.h"

/*
#define TEST_SEGERROR
*/
#define  NO_OF_PROCS    	3
#define  MEM_ALL_ZEROES 	0x0000
#define  MEM_ALL_ONES   	0xffff
#define  MEM_ALTERNATES   	0x5555

#define  LOCAL_PROC   	        0
#define  REMOTE_PROC1  	        1
#define  REMOTE_PROC2  	        2

FILE *tfile;

unsigned int  stat_mem0;
unsigned int  stat_mem1;
unsigned int  stat_memA;
unsigned char *dyn_mem;

mutex_t lock;
condition_t cond;

#ifndef PRINTF_DEFINED
#if defined(FUNCPROTO) || __STDC__ || defined(__cplusplus) || defined(c_plusplus)
extern int printf(const char *, ...), fprintf(FILE *, const char *, ...);
extern int	fclose(FILE *);
#else
extern int printf(), fprintf();
extern int	fclose();
#endif
#endif
void
nullfn()
{
   cthread_exit((any_t)0);
}
void
nullfn2()
{
   while(1);
   cthread_exit((any_t)0);
}


void
test_mem()
{
    cthread_exit(dyn_mem);
}

void
ret_zeroes()
{
    cthread_exit(MEM_ALL_ZEROES);
}

void
ret_ones()
{
    cthread_exit((any_t)MEM_ALL_ONES);
}

void
ret_alternates()
{
    cthread_exit((any_t)MEM_ALTERNATES);
}
#ifdef HAVE_WINDOWS_H
/*For NT, the stall thread will hang the system.
 *we have to timeout so program can exit, yet
 *we can still have assureance that it worked OK
 */
BOOL didStall=FALSE;

INT CALLBACK DoTimeOut()
{
    didStall=TRUE;
    mutex_unlock(lock);
    return 0;
}
#endif

void
thread_should_stall()
{
#ifdef TEST_SEGERROR
    unsigned long *p = NULL;
    *p = 0;
#endif

    mutex_lock(lock);
#ifdef HAVE_WINDOWS_H
    SetTimer (NULL,0,100,DoTimeOut);
#endif
    mutex_lock(lock);
#ifdef HAVE_WINDOWS_H
    if (!didStall)
#endif
	printf("Thread didn't stall!!!\n");	 
}

static void
init()
{
    unsigned char *ret_val1, *ret_val2;
    cthread_t thrd;

    fprintf( tfile, "PASSED: cthread_init OK\n");
    printf("PASSED: cthread_init OK\n");


/* Start confidence 0 level test: fork null functions
to all the processors 
*/
            
    fprintf( tfile, "BEGIN-TEST: Confidence Level 0\n");
    printf("BEGIN-TEST: Confidence Level 0\n");

    thrd = cthread_fork((any_t(*)())nullfn, 0, LOCAL_PROC);
    if( thrd == NULL) {
	fprintf( stderr, "\tALERT!! Problem in cthread_fork \n"); 
	cthread_exit((any_t)1);
    }
    fprintf( tfile, "\tPASSED: Fork null function to proc %d\n", LOCAL_PROC);
    thrd = cthread_fork((any_t(*)())nullfn, 0, REMOTE_PROC1);
    if( thrd == NULL) {
	fprintf( stderr, "\tALERT!! Problem in cthread_fork \n"); 
	cthread_exit((any_t)1);
    }
    fprintf( tfile, "\tPASSED: Fork null function to proc %d\n", REMOTE_PROC1);
    thrd = cthread_fork((any_t(*)())nullfn, 0, REMOTE_PROC2);
    if( thrd == NULL) {
	fprintf( stderr, "\tALERT!! Problem in cthread_fork \n"); 
	cthread_exit((any_t)1);
    }
    fprintf( tfile, "\tPASSED: Fork null function to proc %d\n", REMOTE_PROC2);
    cthread_yield();
    fprintf( tfile, "\tPASSED: cthread_yield in proc %d\n", current_processor());
 
        
    thrd = cthread_fork((any_t(*)())ret_zeroes, 0, REMOTE_PROC1);
    if( thrd == NULL) {
	fprintf( stderr, "\tALERT!! Problem in (1st) cthread_fork \n"); 
	cthread_exit((any_t)1);
    }
    cthread_join(thrd, (any_t *)&ret_val1);
    if (ret_val1 != MEM_ALL_ZEROES) {
	fprintf( tfile, "\tALERT!! Problem in cthread_join\n"); 
	cthread_exit((any_t)1);
    } else {
        thrd = cthread_fork((any_t(*)())ret_ones,0, REMOTE_PROC1);
        if( thrd == NULL) {
	    fprintf( stderr, "\tALERT!! Problem in (2nd) cthread_fork \n"); 
	    cthread_exit((any_t)1);
	  }       
	cthread_join( thrd, (any_t *)&ret_val1);
	if (ret_val1 != (unsigned char *)MEM_ALL_ONES) {
	    fprintf( tfile, "\tALERT!! Problem in cthread_join\n"); 
	    cthread_exit((any_t)1);
	} else {
            thrd = cthread_fork((any_t(*)())ret_alternates, 0, REMOTE_PROC1);
            if( thrd == NULL) {
	        fprintf( stderr, "\tALERT!! Problem in (3rd) cthread_fork \n"); 
               	cthread_exit((any_t)1);
	      }

	    cthread_join(thrd, (any_t *)&ret_val1);
	    if (ret_val1 != (unsigned char *)MEM_ALTERNATES) {
		fprintf( tfile, "\tALERT!! Problem in cthread_join\n"); 
		cthread_exit((any_t)1);
	    } else {
		fprintf( tfile, "\tPASSED: cthread_join OK\n");
	    }
	}
    }
    fprintf( tfile, "END-TEST: Confidence Level 0\n");
    printf("END-TEST: Confidence Level 0\n");

/* Start confidence 1 level test: fork threads in all processors
and return known values 
*/

    fprintf( tfile, "BEGIN-TEST: Confidence Level 1\n");
    printf("BEGIN-TEST: Confidence Level 1\n");

    memory_alloc((memory_t *)&dyn_mem, sizeof(unsigned int), LOCAL_PROC);
    thrd = cthread_fork((any_t(*)())test_mem, 0, REMOTE_PROC1);
    if( thrd == NULL) {
	fprintf( stderr, "\tALERT!! Problem in cthread_fork \n"); 
	cthread_exit((any_t)1);
    }

    cthread_join(thrd,  (any_t *)&ret_val1);
    thrd = cthread_fork((any_t(*)())test_mem, 0, REMOTE_PROC2);
    if( thrd == NULL) {
	fprintf( stderr, "\tALERT!! Problem in cthread_fork \n"); 
	cthread_exit((any_t)1);
    }
    cthread_join( thrd, (any_t *)&ret_val2);
    fprintf(tfile, "\tDEBUG: dyn_mem = %lx  ", (long)dyn_mem);
    fprintf(tfile, "ret_val1 = %lx  ", (long)ret_val1);
    fprintf(tfile, "ret_val2 = %lx\n", (long)ret_val2);
    if ((ret_val1 == dyn_mem) || (ret_val2 == dyn_mem)) {
	fprintf(tfile, "\tPASSED: Memory model totally shared\n");
    } else {
	fprintf(tfile, "\tPASSED: Memory model disjoint staticK\n");
    }
    cthread_publish((any_t *)&dyn_mem);
    thrd = cthread_fork((any_t(*)())test_mem, 0, REMOTE_PROC1);
    if( thrd == NULL) {
	fprintf( stderr, "\tALERT!! Problem in cthread_fork \n"); 
	cthread_exit((any_t)1);
    }
    cthread_join(thrd, (any_t *)&ret_val1);

    thrd = cthread_fork((any_t(*)())test_mem, 0, REMOTE_PROC2);
    if( thrd == NULL) {
	fprintf( stderr, "\tALERT!! Problem in cthread_fork \n"); 
	cthread_exit((any_t)1);
    }
    cthread_join( thrd, (any_t *)&ret_val2);
    fprintf(tfile, "\tDEBUG: dyn_mem = %lx  ", (long)dyn_mem);
    fprintf(tfile, "ret_val1 = %lx  ", (long)ret_val1);
    fprintf(tfile, "ret_val2 = %lx\n", (long)ret_val2);
    if ((ret_val1 == dyn_mem) || (ret_val2 == dyn_mem)) {
	fprintf(tfile, "\tPASSED: cthread_publish OK\n");
    } else {
	fprintf(tfile, "\tALERT!! cthread_publish NOT OK\n");
    }
    mutex_alloc(&lock, LOCAL_PROC);
    condition_alloc(&cond, LOCAL_PROC);

#ifdef TEST_SEGERROR
    thrd = cthread_fork((any_t(*)())nullfn2, 0, REMOTE_PROC1);
    if( thrd == NULL) {
	fprintf( stderr, "\tALERT!! Problem in cthread_fork \n"); 
	cthread_exit((any_t)1);
    }
    thrd = cthread_fork((any_t(*)())nullfn2, 0, REMOTE_PROC2);
    if( thrd == NULL) {
	fprintf( stderr, "\tALERT!! Problem in cthread_fork \n"); 
	cthread_exit((any_t)1);
    }
#endif

    thrd = cthread_fork((any_t(*)()) thread_should_stall, 0, LOCAL_PROC);
    if( thrd == NULL) {
	fprintf( stderr, "\tALERT!! Problem in cthread_fork \n"); 
	cthread_exit((any_t)1);
    }
    cthread_yield();
    cthread_yield();
    cthread_yield();
    cthread_yield();
    cthread_yield();
    cthread_yield();
    fprintf( tfile, "END-TEST: Confidence Level 1\n");
    printf("END-TEST: Confidence Level 1\n");
#ifdef HAVE_WINDOWS_H
    /*In case timer hasn't gone off yet, clear mutex so we can terminate */
    didStall=TRUE;
    mutex_unlock(lock);
#endif

    fclose(tfile);
    exit(0);
}

int
main(argc, argv)
int argc;
char **argv;
{
    int res;

/* Open a file to log the test result */
    if ((tfile = fopen("test.log", "w+")) == NULL) {
	printf("Error opening log file \n");	
	exit(1);
    }

/* Initialize the library */

    cthread_parse_args(argc, argv);

    if ((res = cthread_init( NO_OF_PROCS, init)) != T_SUCCEED ) {
	cthread_perror( "main:: cthread_init failure: ", res );
	exit( 1 );
    }
    fprintf( tfile, "ALERT!! main:: Library Initialization Problem\n");
    return 1;
}
