/*
**  test0.c
**	other files:  test0-int.c
**

**   This test exists to ensure that the sizes of struct cth_mutex_t and
**   struct condition are uniform between application level and cthreads
**   internal code.  This is necessary because for simplicity, cthread.h
**   doesn't actually include all the same header files, etc as the internal
**   stuff does.  Sooo, there's the potential for them to get out of sync.
*/

#include "cthread.h"

extern int sizeof_internal_mutex();
extern int sizeof_internal_condition();

extern int printf();


static
int sizeof_app_mutex()
{
    return sizeof(struct cth_mutex);
}

static
int sizeof_app_condition()
{
    return sizeof(struct condition);
}

int
main()
{
    if (sizeof_app_mutex() != sizeof_internal_mutex()) {
	printf("Inconsistent mutex sizes!  cthread.h size is %d, internal is %d\n",
	       sizeof_app_mutex(), sizeof_internal_mutex());
    }
    if (sizeof_app_condition() != sizeof_internal_condition()) {
	printf("Inconsistent condition sizes!  cthread.h size is %d, internal is %d\n",
	       sizeof_app_condition(), sizeof_internal_condition());
    }
    return 0;
}


