/* sync.h
 * Modification history:
 *
 * 1.0	3-May-88	Initial release.
 * 1.1	18-Apr-89	(Ahmed Gheith) Added barriers (bar)
 * 1.2	18-Apr-89	(Ahmed Gheith) Added semaphores (sem)
 * 1.3	20-Apr-89	(Ahmed Gheith) Added events (event)
 * 1.4	24-Apr-89	(Ahmed Gheith) Added dual queues (dualq)
 * 1.5	25-Apr-89	(Ahmed Gheith) Added private conditions (pcond)
 * 1.6	26-Apr-89	(Ahmed Gheith) Added read/write locks (rwlock)
 * 1.7	28-Apr-89	(Ahmed Gheith) Added entries (entry)
 * 1.8   Bodhi Mukherjee	Added Implementation for Sun3/50.
 * 1.9   Bodhi Mukherjee	Added Implementation for Sun3/86.
 * 1.10   Bodhi Mukherjee	Added Implementation for Sparcs.
 * 1.11   Bodhi Mukherjee	Added Implementation for Sequent.
 *
 */
#ifndef SYNC_H
#define SYNC_H

typedef	struct	condition {
	LOCK		clock;
	struct		cth_queue	cqueue;
	string_t	name;
	/* the condition sequence number below is used with monitoring to 
	   establish a partial ordering between monitored events
	 */
	unsigned int	sequence_number;
	void	*mon_info;  /* pointer used to store monitoring information */
} *condition_t;

typedef	struct	cth_mutex {
	LOCK		mlock;
	string_t	name;
	/* the lock sequence number below is used with monitoring to establish
	   a partial ordering between monitored events
	 */
	unsigned int	sequence_number;
	void	*mon_info;  /* pointer used to store monitoring information */
} *mutex_t;

int 
atomadd ARGS((atom_int *i, int j));/* "a formal parameter that promotes to int
				 can only match int in the prototype" ? */

/****************************************************************************/
/* spin locks                                                               */
/****************************************************************************/

void
  cthread_spin_lock ARGS((LOCK	*sl));

void
  cthread_spin_unlock ARGS((LOCK	*sl));

#ifdef	HOT_SPOT
void
  local_hot_spot();

void
  hot_spot_statistics();
     
#endif
/****************************************************************************/
/* mutex                                                                    */
/****************************************************************************/


void
  mutex_lock ARGS((mutex_t m));

void
  mutex_unlock ARGS((mutex_t m));

void
  internal_mutex_lock ARGS((LOCK_T m));

void
  internal_mutex_unlock ARGS((LOCK_T m));

void
  internal_mutex_clear ARGS((mutex_t m));

void
  internal_mutex_init ARGS((mutex_t m));

RESULT
  internal_mutex_alloc ARGS((mutex_t *mptr,
			     int 	node));

void
  internal_mutex_free ARGS((mutex_t m));

void
  mutex_set_name ARGS((mutex_t m,
		       string_t	mname));

string_t
  mutex_name ARGS((mutex_t m));

/***************************************************************************/
/* conditions                                                              */
/***************************************************************************/

void
  queue_self_on_condition ARGS((condition_t c));

void
  unlock_and_yield ARGS((condition_t c,	LOCK_T lock, mutex_t m));

RESULT
  internal_condition_signal ARGS((condition_t c, unsigned int *woken_seq_waiter));

void 
  internal_condition_wait ARGS((condition_t c, LOCK_T lock));

void
  internal_condition_broadcast ARGS((condition_t c, int *begin_seq_num, int*end_seq_num));

void
  internal_condition_init ARGS((condition_t c));

void
  internal_condition_clear ARGS((condition_t c));

void
  internal_condition_free ARGS((condition_t c));

void
  internal_condition_set_name ARGS((condition_t c,
				    string_t cname));

string_t
  condition_name ARGS((condition_t c));

RESULT
  internal_condition_alloc ARGS((condition_t *cptr,
				 int node));

#endif
