#include	"config.h"
#include	<stdio.h>
#include        <sys/types.h>
#include	<varargs.h>
#ifdef HAVE_STRING_H
#include	<string.h>
#else
#include	<strings.h>
#endif

#include	"assert.h"
#include	"general.h"
#include	"results.h"
#include	"lock.h"
#include	"queue.h"
#include	"sync.h"
#include	"internal.h"
#include	"cf_lock.h"
#include 	"memalloc.h"
#include	"hwlib.h"
#include	"threads.h"

extern  shared	struct  local_info  *processor;
extern  cthread_t current_thread_array[MAX_PROC];
extern 		int 	            next_thread_type;
extern    int   *num_of_procs;
extern    private	sched_info_t   local_scheduler[MAX_PROC];

#ifdef WITH_MONITORING
#include "monitor.h"
#endif
#include "mon.sensorextern.h"

#include "arch_sync.h"
#include "arch_init.h"

/* cthreads functions used but not defined here */
extern void internal_cthread_yield();

extern LOCK *ss_lock;

int
atomadd(i, j)
atom_int *i;
int j;
{
	int tmp_i = *i;
#ifdef __ksr__
	assert(((long)i&0xf) == 0);   /* better be aligned on a subpage */
#endif
        cthread_spin_lock(ATOM_ADD_LOCK);
        (*i) = (*i) + j;
        cthread_spin_unlock(ATOM_ADD_LOCK);
	return tmp_i;
}

/****************************************************************************/
/* spin locks                                                               */
/****************************************************************************/

#ifdef	HOT_SPOT
unsigned	long	spin_counter=0;
#endif

void
cthread_spin_lock(sl)
LOCK	*sl;
{

   SPIN_LOCK(sl)
#ifdef	HOT_SPOT	
      spin_counter++;
#endif
      ;
}

void
cthread_spin_unlock(sl)
LOCK	*sl;
{
/*	LOCK_INIT(*sl);*/
   SPIN_UNLOCK(sl);
}

#ifdef	HOT_SPOT
extern		int	*num_of_procs;

void
local_hot_spot()
{
   printf("Logical processor %d, Number of spins %ld\n",
         virtual_processor(), spin_counter);
   spin_counter = 0;
}

void
hot_spot_statistics()
{
   int		i;

   for (i=0; i< *num_of_procs; i++)
     internal_cthread_detach(cthread_fork(local_hot_spot, 0L, i));
}
#endif

/****************************************************************************/
/* mutex                                                                    */
/****************************************************************************/

void
mutex_lock(m)
mutex_t	m;
{
   MUTEX_LOCK(&(m->mlock));
}

void
internal_mutex_lock(m)
LOCK	*m;
{
    DBG1("Internal mutex lock called on lock %x\n", (int) m);
    MUTEX_LOCK(m);
}

void
mutex_unlock(m)
mutex_t	m;
{

   MUTEX_UNLOCK(&(m->mlock));
}

void
internal_mutex_unlock(m)
LOCK	*m;
{
    DBG1("Internal mutex unlock called on lock %x\n", (int) m);
    MUTEX_UNLOCK(m);
}

void
internal_mutex_clear(m)
mutex_t	m;
{
   internal_mutex_unlock(&m->mlock);
}

void
internal_mutex_init(m)
mutex_t	m;
{
   LOCK_INIT(m->mlock);
   m->name = (char *)0;
   m->sequence_number = 0;
   m->mon_info = NULL;
}

RESULT
internal_mutex_alloc(mptr, node)
mutex_t	*mptr;
int		node;
{
   RESULT	tmp;

   if((tmp = memory_alloc((memory_t *)mptr,sizeof(struct cth_mutex), node)) 
            != T_SUCCEED)
      return(tmp);
   internal_mutex_init(*mptr);
   return(T_SUCCEED);
}

void
internal_mutex_free(m)
mutex_t	m;
{
   internal_mutex_clear(m);
#ifdef WITH_MONITORING
   if (monitoring_enabled && default_monitoring_enabled) {
       monitor_delete_mutex(m, m->mon_info);
   }
#endif
#ifdef __sgi
   usfreelock(m->mlock, mem_handle);
#endif
   memory_free((memory_t) m);
}

void
mutex_set_name(m, mname)
mutex_t		m;
string_t	mname;
{
    char *tmp_name;

/*   *NOTE*  This is a memory leak!  Mutex_set_name never frees memory!
     See the Todo file for notes on this....
    if (m->name != NULL) {
	memory_free((memory_t) m->name);
    }
*/
    if (mname != NULL) {
	RESULT res;
	res = memory_alloc((memory_t *) &tmp_name, strlen(mname) + 1,
			   virtual_processor());
	if (res != T_SUCCEED) {
	    m->name = NULL;
	    return;
	}

	strcpy(tmp_name, mname);
	mname = tmp_name;
    }
    m->name = mname;
    DM_Sensor_mutex_set_name(m, mname);
}

string_t
mutex_name(m)
mutex_t		m;
{
   return(m->name);
}

/***************************************************************************/
/* conditions                                                              */
/***************************************************************************/

void
queue_self_on_condition(c)
condition_t	c;
{

   internal_mutex_lock(&c->clock);
   c->sequence_number++;
}

void
unlock_and_yield(c, lock, m)
condition_t	c;
LOCK_T		lock;
mutex_t		m;
{
    int proc = virtual_processor();
    cthread_t current_thread = current_thread_array[proc];
    cthread_t	ttmp = current_thread;
   int          seq = 0;

   enqueue(&c->cqueue, (queue_item_t)ttmp);
   internal_mutex_unlock(&c->clock);
   atomadd(&(local_scheduler[proc]->active_threads), -1);

   if (m != NULL) {
       seq = m->sequence_number;
   }
   internal_mutex_unlock(lock);
   if (m != NULL) {
       DM_Sensor_mutex_unlock(m, seq);
   }
   swap_context_with_func((void (*)()) local_scheduler[proc]->schedule, NULL);
   /*
   ** execution will continue here after condition is signalled or broadcast
   */
   if (m != NULL) {
       DM_Sensor_mutex_begin_lock(m, m->sequence_number);
   }
   internal_mutex_lock(lock);
   if (m != NULL) {
       m->sequence_number++;
       DM_Sensor_mutex_end_lock(m, m->sequence_number);
   }
}

void
internal_condition_wait(c, lock)
condition_t	c;
LOCK_T		lock;
{
    queue_self_on_condition(c);
    unlock_and_yield(c, lock, NULL);
}

RESULT
internal_condition_signal(c, woken_waiter)
condition_t	c;
unsigned int *woken_waiter;
{
    cthread_t	ttmp = NULL;

    internal_mutex_lock(&c->clock);

    /* the sequence number that the dequeued thread will have had is
       the current sequence number minus the queue length
       */
    if ((ttmp = (cthread_t)dequeue(&c->cqueue)) == 0){
	if (woken_waiter != NULL) {
	    /* nobody really wakened.  Give the last sequence number */
	    *woken_waiter = c->sequence_number;
	}
	internal_mutex_unlock(&c->clock);
	return(T_NO_THREAD_QUEUED);
    }
    if (woken_waiter != NULL) {
	/* the seq number of the woken thread is (current - Qlength) */
	*woken_waiter = c->sequence_number - queue_len(&c->cqueue);
    }
    internal_mutex_unlock(&c->clock);
    ((processor[ttmp->on_node].scheduler)->sched_put_thread)(ttmp->on_node,ttmp);
    atomadd(&((processor[ttmp->on_node].scheduler)->active_threads), 1);
    return(T_SUCCEED);
}

void
internal_condition_broadcast(c, begin_seq_num_ptr, end_seq_num_ptr)
condition_t	c;
int 		*begin_seq_num_ptr, *end_seq_num_ptr;
{
    cthread_t	ttmp;

    internal_mutex_lock(&c->clock);

    if (end_seq_num_ptr) *end_seq_num_ptr = c->sequence_number;
    if (begin_seq_num_ptr)
    *begin_seq_num_ptr = c->sequence_number - queue_len(&c->cqueue);
    
    while ((ttmp = (cthread_t)dequeue(&c->cqueue)) != 0) {
	((processor[ttmp->on_node].scheduler)->sched_put_thread)
	(ttmp->on_node,ttmp);
    }
    internal_mutex_unlock(&c->clock);
}

void
internal_condition_init(c)
condition_t	c;
{
   c->clock = 0;	/* to cause the physical memory to be allcated;
			 * else, the KSR produces a SIGSESV */
   LOCK_INIT(c->clock);
   c->cqueue.first = 0;
   c->cqueue.tail = 0;
   c->name = 0;
   c->sequence_number = 0;
   c->mon_info = NULL;
}

void
internal_condition_clear(c)
condition_t	c;
{
    internal_condition_signal(c, NULL);
}


void
internal_condition_free(c)
condition_t	c;
{
    internal_condition_broadcast(c, NULL, NULL);
#ifdef WITH_MONITORING
    if (monitoring_enabled && default_monitoring_enabled) {
	monitor_delete_condition(c, c->mon_info);
    }
#endif
    memory_free((memory_t) c);
}

void
condition_set_name(c, cname)
condition_t	c;
string_t	cname;
{
    char *tmp_name;
/*   *NOTE*  This is a memory leak!  Condition_set_name never frees memory!
     See the Todo file for notes on this....
    if (c->name != NULL) {
	memory_free((memory_t) c->name);
    }
*/
    if (cname != NULL) {
	RESULT res;
	res = memory_alloc((memory_t *) &tmp_name, strlen(cname) + 1,
			   virtual_processor());
	if (res != T_SUCCEED) {
	    c->name = NULL;
	    return;
	}

	strcpy(tmp_name, cname);
	cname = tmp_name;
    }
    c->name = cname;
    DM_Sensor_condition_set_name(c, cname);
}

string_t
condition_name(c)
condition_t	c;
{
   return(c->name);
}

RESULT
internal_condition_alloc(cptr, node)
condition_t	*cptr;
int			node;
{
   RESULT	tmp;

   if((tmp = memory_alloc((memory_t *) cptr, sizeof(struct condition), node)) 
            != T_SUCCEED)
      return(tmp);
   internal_condition_init(*cptr);
   return(T_SUCCEED);
}

extern	atom_int	*total_threads;
extern	atom_int	*total_active;

/* DANGER, DANGER, DANGER, Will Robinson */
/*
**   This is not a very general or capable function and it doesn't appear 
**   in the set of exported and documented routines.  It was added in 
**   April 1994 to support a need of TimeWarp kernel.  Specifically they 
**   needed the ability to terminate threads that were waiting on known 
**   conditions.  This function does that.  Making it more general so that 
**   it can kill running threads or threads queued on unknown conditions
**   is considerably tougher and is unimplemented...   GSE
*/

RESULT
cthread_kill(c, t)
condition_t	c;
cthread_t t;
{
    locked_queue_t	tfreelist;
    cthread_t	ttmp = NULL;

    internal_mutex_lock(&c->clock);

    if ((ttmp = (cthread_t)dequeue_item(&c->cqueue, (queue_item_t) t)) == 0){
	internal_mutex_unlock(&c->clock);
	return(T_NO_THREAD_QUEUED);
    }
    internal_mutex_unlock(&c->clock);
    internal_mutex_lock(&ttmp->tlock);
    ttmp->status |= S_FINISHED;
    ttmp->status |= S_FREED;
    ttmp->already_started = 0;
    internal_mutex_unlock(&ttmp->tlock);

    tfreelist = (processor[ttmp->home /*on_node*/].scheduler)->free_list;

    cthread_spin_lock(&tfreelist->lqlock);
    enqueue(&tfreelist->lcqueue, (queue_item_t) ttmp);
    cthread_spin_unlock(&tfreelist->lqlock);
    atomadd(total_threads, -1);
    atomadd(total_active, -1);
    processor[virtual_processor()].load -= 1;
    atomadd(&(local_scheduler[virtual_processor()]->active_threads), -1);

    return(T_SUCCEED);
}

