#include 	<signal.h>
#include        "general.h"
#include        "lock.h"
#include        "queue.h"
#include        "sync.h"
#include        "internal.h"
#include	"init.h"
#include        "thread_types.h"
#include        "hwlib.h"
#include	"arch_init.h"

extern void child_exit ARGS((int));
extern  shared	struct  local_info  *processor;
extern  private	locked_queue_t      local_thread_queue[MAX_PROC];
extern 		int 	            next_thread_type;


static int next_thread_type;
static int local_top_queue;
extern struct configuration    config;
extern  private	 sched_info_t   local_scheduler[MAX_PROC];

sched_info_t
top_sched_global_init(node)
int node;
{
	   any_t        memptr;
	   int          i, size, kres ;
	   cthread_t    ttmp;
	   queue_t      qtmp;

        sched_info_t   scheduler;

   	size = scb_size();
   	scheduler = (sched_info_t)allocate_and_share(size,node);

     	size = 3*sizeof(struct locked_queue)+ config.threads_per_proc * (sizeof(struct cthread) + config.stack_size);

   	memptr = (any_t)allocate_and_share(size,node);

   	DBG1("memptr is %x\n",(long)memptr);

   	scheduler->free_list = ((locked_queue_t)memptr)++;

   	DBG1("memptr is %x\n",(long)memptr);

   	scheduler->lqueue1 = ((locked_queue_t)memptr)++;
   	scheduler->lqueue2 = ((locked_queue_t)memptr)++;
	LOCK_INIT(scheduler->sched_lock);

	locked_queue_init(scheduler->free_list);
   	locked_queue_init(scheduler->lqueue1);
   	locked_queue_init(scheduler->lqueue2);
   	qtmp = (queue_t)&scheduler->free_list->lcqueue;
   	for (i=0; i< config.threads_per_proc; i++){
      		enqueue(qtmp, (queue_item_t)memptr);
      		DBG2("%2d memptr=%x\n",i,(long)memptr);
      		ttmp = ((cthread_t)memptr)++;
#ifdef SPARC
      		ttmp->stack_top = (any_t)((long)memptr + config.stack_size - 104);

/*********************************************************************/
/*   To make the stack 8 byte alligned                               */
/*********************************************************************/

      		ttmp->stack_top = (any_t)((((long)(ttmp->stack_top))/4096)*4096);
#else
      		ttmp->stack_top = (any_t)((long)memptr + config.stack_size - 4);
#endif SPARC
      		*(long *)(ttmp->stack_top) = 0;   /* Butterfly : Cause a page-in */
      		LOCK_INIT(ttmp->tlock);
      		ttmp->name = 0;
      		ttmp->return_value = 0;
      		ttmp->status = S_INITIALLY;
      		ttmp->thread_data = 0;
      		ttmp->on_node = node;
      		ttmp->home    = node;
      		ttmp->synced = 0;
      		ttmp->already_started = 0;
      		internal_condition_init(&ttmp->done);
      		memptr = (any_t)((long)memptr + config.stack_size);
   	}
      	return(scheduler);
}

void
top_sched_vproc_init(node)
int node;
{

    local_scheduler[node] = processor[node].scheduler;
    local_thread_queue[node] = local_scheduler->lqueue1;
    local_top_queue = local_scheduler->lqueue2;
}

int
top_thread_init(t)
cthread_t t;
{
	return(next_thread_type);
}

void
set_thread_type(type)
int type;
{
	next_thread_type = type;
}

void
top_sched_empty_readyq()
{
    int proc = virtual_processor();
    return((local_thread_queue[proc]->lcqueue.first == 0) && 
	   (local_top_queue->lcqueue.first == 0));
}

cthread_t
top_sched_get_thread(node)
int node;
{
    cthread_t    next_thread;
    int proc = virtual_processor();

    if ((local_top_queue->lcqueue.first == 0)) {
	cthread_spin_lock(&local_thread_queue[proc]->lqlock);
	next_thread = (cthread_t) dequeue(&local_thread_queue[proc]->lcqueue);
	cthread_spin_unlock(&local_thread_queue[proc]->lqlock);
    } else {
	cthread_spin_lock(&local_top_queue[proc]->lqlock);
	next_thread = (cthread_t) dequeue(&local_top_queue[proc]->lcqueue);
	cthread_spin_unlock(&local_top_queue[proc]->lqlock);
    }
    return(next_thread);
}

void
top_sched_put_thread(node,thread)
int node;
cthread_t thread;
{
    if (thread->schedule_type == NORMAL_THREAD) {
	if(node != virtual_processor()) {
	    locked_enqueue((processor[node].scheduler)->lqueue1, thread);
	} else {
	    cthread_spin_lock(&local_thread_queue[node]->lqlock);
	    enqueue(&local_thread_queue[node]->lcqueue, thread);
	    cthread_spin_unlock(&local_thread_queue[node]->lqlock);
	}
    } else if (thread->schedule_type == TOP_THREAD) {
	if(node != virtual_processor()) {
	    locked_enqueue((processor[node].scheduler)->lqueue2, thread);
	} else {
	    cthread_spin_lock(&local_top_queue->lqlock);
	    enqueue(&local_top_queue->lcqueue, thread);
	    cthread_spin_unlock(&local_top_queue->lqlock);
	}
    }
}

void
top_schedule()
{
   cthread_t    next_thread;
   int proc = virtual_processor();

   /* the following loop avoids a spin lock on an empty queue */
   enable_alert();
   while(((local_scheduler[proc]->sched_empty_readyq)()) && 
	 (processor[proc].terminate != TERMINATE)) {
       ;
   }
   next_thread = (cthread_t)(local_scheduler[proc]->sched_get_thread)(proc);
   if (next_thread == 0 && processor[proc].terminate == TERMINATE) {
     child_exit(0);
   }
   sched_dispatch(next_thread);
}
